<?php

namespace Cocorico\EdnBundle\Wsdl;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Find ServiceType
 * @subpackage Services
 */
class Find extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named findRelays
     * Meta information extracted from the WSDL
     * - documentation: Geographic relay search
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Cocorico\EdnBundle\Wsdl\LoginType $login
     * @param \Cocorico\EdnBundle\Wsdl\FindRelaysRequest $params
     * @return array|bool
     */
    public function findRelays(\Cocorico\EdnBundle\Wsdl\LoginType $login, \Cocorico\EdnBundle\Wsdl\FindRelaysRequest $params)
    {
        try {
            $this->setResult($this->getSoapClient()->findRelays($login, $params));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
