<?php

namespace Cocorico\EdnBundle\Wsdl;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for errorType StructType
 * @subpackage Structs
 */
class ErrorType extends AbstractStructBase
{
    /**
     * The error_id
     * Meta information extracted from the WSDL
     * - documentation: Error id, 0 means everything went right, > 0 means an error occurred
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $error_id;
    /**
     * The error_message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $error_message;
    /**
     * The error_severity_level
     * Meta information extracted from the WSDL
     * - documentation: Reserved for future use
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $error_severity_level;
    /**
     * The error_severity_message
     * Meta information extracted from the WSDL
     * - documentation: Reserved for future use
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $error_severity_message;
    /**
     * The error_description
     * Meta information extracted from the WSDL
     * - documentation: Additional optional description
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $error_description;
    /**
     * Constructor method for errorType
     * @uses ErrorType::setError_id()
     * @uses ErrorType::setError_message()
     * @uses ErrorType::setError_severity_level()
     * @uses ErrorType::setError_severity_message()
     * @uses ErrorType::setError_description()
     * @param int $error_id
     * @param string $error_message
     * @param int $error_severity_level
     * @param string $error_severity_message
     * @param string $error_description
     */
    public function __construct($error_id = null, $error_message = null, $error_severity_level = null, $error_severity_message = null, $error_description = null)
    {
        $this
            ->setError_id($error_id)
            ->setError_message($error_message)
            ->setError_severity_level($error_severity_level)
            ->setError_severity_message($error_severity_message)
            ->setError_description($error_description);
    }
    /**
     * Get error_id value
     * @return int
     */
    public function getError_id()
    {
        return $this->error_id;
    }
    /**
     * Set error_id value
     * @param int $error_id
     * @return \Cocorico\EdnBundle\Wsdl\ErrorType
     */
    public function setError_id($error_id = null)
    {
        // validation for constraint: int
        if (!is_null($error_id) && !(is_int($error_id) || ctype_digit($error_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($error_id, true), gettype($error_id)), __LINE__);
        }
        $this->error_id = $error_id;
        return $this;
    }
    /**
     * Get error_message value
     * @return string
     */
    public function getError_message()
    {
        return $this->error_message;
    }
    /**
     * Set error_message value
     * @param string $error_message
     * @return \Cocorico\EdnBundle\Wsdl\ErrorType
     */
    public function setError_message($error_message = null)
    {
        // validation for constraint: string
        if (!is_null($error_message) && !is_string($error_message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($error_message, true), gettype($error_message)), __LINE__);
        }
        $this->error_message = $error_message;
        return $this;
    }
    /**
     * Get error_severity_level value
     * @return int
     */
    public function getError_severity_level()
    {
        return $this->error_severity_level;
    }
    /**
     * Set error_severity_level value
     * @param int $error_severity_level
     * @return \Cocorico\EdnBundle\Wsdl\ErrorType
     */
    public function setError_severity_level($error_severity_level = null)
    {
        // validation for constraint: int
        if (!is_null($error_severity_level) && !(is_int($error_severity_level) || ctype_digit($error_severity_level))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($error_severity_level, true), gettype($error_severity_level)), __LINE__);
        }
        $this->error_severity_level = $error_severity_level;
        return $this;
    }
    /**
     * Get error_severity_message value
     * @return string
     */
    public function getError_severity_message()
    {
        return $this->error_severity_message;
    }
    /**
     * Set error_severity_message value
     * @param string $error_severity_message
     * @return \Cocorico\EdnBundle\Wsdl\ErrorType
     */
    public function setError_severity_message($error_severity_message = null)
    {
        // validation for constraint: string
        if (!is_null($error_severity_message) && !is_string($error_severity_message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($error_severity_message, true), gettype($error_severity_message)), __LINE__);
        }
        $this->error_severity_message = $error_severity_message;
        return $this;
    }
    /**
     * Get error_description value
     * @return string|null
     */
    public function getError_description()
    {
        return $this->error_description;
    }
    /**
     * Set error_description value
     * @param string $error_description
     * @return \Cocorico\EdnBundle\Wsdl\ErrorType
     */
    public function setError_description($error_description = null)
    {
        // validation for constraint: string
        if (!is_null($error_description) && !is_string($error_description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($error_description, true), gettype($error_description)), __LINE__);
        }
        $this->error_description = $error_description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Cocorico\EdnBundle\Wsdl\ErrorType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
