<?php

namespace Cocorico\EdnBundle\Wsdl;

/**
 * This class stands for enumOrientationType EnumType
 * @subpackage Enumerations
 */
class EnumOrientationType
{
    /**
     * Constant for value 'portrait'
     * @return string 'portrait'
     */
    const VALUE_PORTRAIT = 'portrait';
    /**
     * Constant for value 'landscape'
     * @return string 'landscape'
     */
    const VALUE_LANDSCAPE = 'landscape';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PORTRAIT
     * @uses self::VALUE_LANDSCAPE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PORTRAIT,
            self::VALUE_LANDSCAPE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
