<?php

namespace Cocorico\EdnBundle\Wsdl;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createShipmentResponse StructType
 * @subpackage Structs
 */
class CreateShipmentResponse extends AbstractStructBase
{
    /**
     * The pdf
     * Meta information extracted from the WSDL
     * - documentation: Url of the merged PDF labels
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $pdf;
    /**
     * The shipments
     * Meta information extracted from the WSDL
     * - arrayType: tns:shipmentType[]
     * - base: SOAP-ENC:Array
     * - maxOccurs: 1
     * - minOccurs: 1
     * - ref: SOAP-ENC:arrayType
     * @var \Cocorico\EdnBundle\Wsdl\ShipmentType[]
     */
    public $shipments;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - documentation: Reserved for future use
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $price;
    /**
     * The zpl
     * Meta information extracted from the WSDL
     * - documentation: ZPL string representing the merged labels
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $zpl;
    /**
     * The epl2
     * Meta information extracted from the WSDL
     * - documentation: EPL2 string representing the merged labels
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $epl2;
    /**
     * The cn23
     * Meta information extracted from the WSDL
     * - documentation: Url of the merged CN23 forms if applicable
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cn23;
    /**
     * Constructor method for createShipmentResponse
     * @uses CreateShipmentResponse::setPdf()
     * @uses CreateShipmentResponse::setShipments()
     * @uses CreateShipmentResponse::setPrice()
     * @uses CreateShipmentResponse::setZpl()
     * @uses CreateShipmentResponse::setEpl2()
     * @uses CreateShipmentResponse::setCn23()
     * @param string $pdf
     * @param \Cocorico\EdnBundle\Wsdl\ShipmentType[] $shipments
     * @param float $price
     * @param string $zpl
     * @param string $epl2
     * @param string $cn23
     */
    public function __construct($pdf = null, array $shipments = array(), $price = null, $zpl = null, $epl2 = null, $cn23 = null)
    {
        $this
            ->setPdf($pdf)
            ->setShipments($shipments)
            ->setPrice($price)
            ->setZpl($zpl)
            ->setEpl2($epl2)
            ->setCn23($cn23);
    }
    /**
     * Get pdf value
     * @return string
     */
    public function getPdf()
    {
        return $this->pdf;
    }
    /**
     * Set pdf value
     * @param string $pdf
     * @return \Cocorico\EdnBundle\Wsdl\CreateShipmentResponse
     */
    public function setPdf($pdf = null)
    {
        // validation for constraint: string
        if (!is_null($pdf) && !is_string($pdf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pdf, true), gettype($pdf)), __LINE__);
        }
        $this->pdf = $pdf;
        return $this;
    }
    /**
     * Get shipments value
     * @return \Cocorico\EdnBundle\Wsdl\ShipmentType[]
     */
    public function getShipments()
    {
        return $this->shipments;
    }
    /**
     * This method is responsible for validating the values passed to the setShipments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipments method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentsForArrayConstraintsFromSetShipments(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $createShipmentResponseShipmentsItem) {
            // validation for constraint: itemType
            if (!$createShipmentResponseShipmentsItem instanceof \Cocorico\EdnBundle\Wsdl\ShipmentType) {
                $invalidValues[] = is_object($createShipmentResponseShipmentsItem) ? get_class($createShipmentResponseShipmentsItem) : sprintf('%s(%s)', gettype($createShipmentResponseShipmentsItem), var_export($createShipmentResponseShipmentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The shipments property can only contain items of type \Cocorico\EdnBundle\Wsdl\ShipmentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set shipments value
     * @throws \InvalidArgumentException
     * @param \Cocorico\EdnBundle\Wsdl\ShipmentType[] $shipments
     * @return \Cocorico\EdnBundle\Wsdl\CreateShipmentResponse
     */
    public function setShipments(array $shipments = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentsArrayErrorMessage = self::validateShipmentsForArrayConstraintsFromSetShipments($shipments))) {
            throw new \InvalidArgumentException($shipmentsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($shipments) && count($shipments) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 1', count($shipments)), __LINE__);
        }
        $this->shipments = $shipments;
        return $this;
    }
    /**
     * Add item to shipments value
     * @throws \InvalidArgumentException
     * @param \Cocorico\EdnBundle\Wsdl\ShipmentType $item
     * @return \Cocorico\EdnBundle\Wsdl\CreateShipmentResponse
     */
    public function addToShipments(\Cocorico\EdnBundle\Wsdl\ShipmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Cocorico\EdnBundle\Wsdl\ShipmentType) {
            throw new \InvalidArgumentException(sprintf('The shipments property can only contain items of type \Cocorico\EdnBundle\Wsdl\ShipmentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($this->shipments) && count($this->shipments) >= 1) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 1', count($this->shipments)), __LINE__);
        }
        $this->shipments[] = $item;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \Cocorico\EdnBundle\Wsdl\CreateShipmentResponse
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get zpl value
     * @return string|null
     */
    public function getZpl()
    {
        return $this->zpl;
    }
    /**
     * Set zpl value
     * @param string $zpl
     * @return \Cocorico\EdnBundle\Wsdl\CreateShipmentResponse
     */
    public function setZpl($zpl = null)
    {
        // validation for constraint: string
        if (!is_null($zpl) && !is_string($zpl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zpl, true), gettype($zpl)), __LINE__);
        }
        $this->zpl = $zpl;
        return $this;
    }
    /**
     * Get epl2 value
     * @return string|null
     */
    public function getEpl2()
    {
        return $this->epl2;
    }
    /**
     * Set epl2 value
     * @param string $epl2
     * @return \Cocorico\EdnBundle\Wsdl\CreateShipmentResponse
     */
    public function setEpl2($epl2 = null)
    {
        // validation for constraint: string
        if (!is_null($epl2) && !is_string($epl2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($epl2, true), gettype($epl2)), __LINE__);
        }
        $this->epl2 = $epl2;
        return $this;
    }
    /**
     * Get cn23 value
     * @return string|null
     */
    public function getCn23()
    {
        return $this->cn23;
    }
    /**
     * Set cn23 value
     * @param string $cn23
     * @return \Cocorico\EdnBundle\Wsdl\CreateShipmentResponse
     */
    public function setCn23($cn23 = null)
    {
        // validation for constraint: string
        if (!is_null($cn23) && !is_string($cn23)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cn23, true), gettype($cn23)), __LINE__);
        }
        $this->cn23 = $cn23;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Cocorico\EdnBundle\Wsdl\CreateShipmentResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
