<?php

namespace Cocorico\EdnBundle\Wsdl;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createShipmentRequest StructType
 * @subpackage Structs
 */
class CreateShipmentRequest extends AbstractStructBase
{
    /**
     * The reference
     * Meta information extracted from the WSDL
     * - documentation: Unique reference of the shipment. Can be an order id, an internal reference or whatever you want.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $reference;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - documentation: Total value of the shipment, used in international shipments
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $value;
    /**
     * The carrier
     * Meta information extracted from the WSDL
     * - documentation: Carrier
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $carrier;
    /**
     * The format
     * Meta information extracted from the WSDL
     * - documentation: Label format
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $format;
    /**
     * The from
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Cocorico\EdnBundle\Wsdl\AddressType
     */
    public $from;
    /**
     * The to
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Cocorico\EdnBundle\Wsdl\AddressType
     */
    public $to;
    /**
     * The packages
     * Meta information extracted from the WSDL
     * - arrayType: tns:packageType[]
     * - base: SOAP-ENC:Array
     * - maxOccurs: 1
     * - minOccurs: 1
     * - ref: SOAP-ENC:arrayType
     * @var \Cocorico\EdnBundle\Wsdl\PackageType[]
     */
    public $packages;
    /**
     * The client_account
     * Meta information extracted from the WSDL
     * - documentation: Internal parameter, please ignore
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $client_account;
    /**
     * The pack
     * Meta information extracted from the WSDL
     * - documentation: Internal parameter, please ignore
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pack;
    /**
     * The auto_relay
     * Meta information extracted from the WSDL
     * - documentation: Internal parameter, please ignore
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $auto_relay;
    /**
     * The customs_mode
     * Meta information extracted from the WSDL
     * - documentation: Internal parameter, please ignore
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customs_mode;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - documentation: Currency ISO 4217 code, default: EUR
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * The carrier_options
     * Meta information extracted from the WSDL
     * - documentation: Carrier specific options
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Cocorico\EdnBundle\Wsdl\CarrierOptionsType
     */
    public $carrier_options;
    /**
     * The label_type
     * Meta information extracted from the WSDL
     * - documentation: Label type
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $label_type;
    /**
     * The resize
     * Meta information extracted from the WSDL
     * - documentation: Resize labels to format size
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $resize;
    /**
     * The orientation
     * Meta information extracted from the WSDL
     * - documentation: Label orientation
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $orientation;
    /**
     * The pod
     * Meta information extracted from the WSDL
     * - documentation: If a proof of delivery is required
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $pod;
    /**
     * The documents
     * Meta information extracted from the WSDL
     * - documentation: If the shipment is documents (no commercial value), default 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $documents;
    /**
     * The cod
     * Meta information extracted from the WSDL
     * - documentation: If cash on delivery is required
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $cod;
    /**
     * The dangerous
     * Meta information extracted from the WSDL
     * - documentation: If the package contains dangerous goods
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $dangerous;
    /**
     * The relay_id
     * Meta information extracted from the WSDL
     * - documentation: Mandatory when using a relay carrier
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $relay_id;
    /**
     * Constructor method for createShipmentRequest
     * @uses CreateShipmentRequest::setReference()
     * @uses CreateShipmentRequest::setValue()
     * @uses CreateShipmentRequest::setCarrier()
     * @uses CreateShipmentRequest::setFormat()
     * @uses CreateShipmentRequest::setFrom()
     * @uses CreateShipmentRequest::setTo()
     * @uses CreateShipmentRequest::setPackages()
     * @uses CreateShipmentRequest::setClient_account()
     * @uses CreateShipmentRequest::setPack()
     * @uses CreateShipmentRequest::setAuto_relay()
     * @uses CreateShipmentRequest::setCustoms_mode()
     * @uses CreateShipmentRequest::setCurrency()
     * @uses CreateShipmentRequest::setCarrier_options()
     * @uses CreateShipmentRequest::setLabel_type()
     * @uses CreateShipmentRequest::setResize()
     * @uses CreateShipmentRequest::setOrientation()
     * @uses CreateShipmentRequest::setPod()
     * @uses CreateShipmentRequest::setDocuments()
     * @uses CreateShipmentRequest::setCod()
     * @uses CreateShipmentRequest::setDangerous()
     * @uses CreateShipmentRequest::setRelay_id()
     * @param string $reference
     * @param float $value
     * @param string $carrier
     * @param string $format
     * @param \Cocorico\EdnBundle\Wsdl\AddressType $from
     * @param \Cocorico\EdnBundle\Wsdl\AddressType $to
     * @param \Cocorico\EdnBundle\Wsdl\PackageType[] $packages
     * @param bool $client_account
     * @param string $pack
     * @param bool $auto_relay
     * @param string $customs_mode
     * @param string $currency
     * @param \Cocorico\EdnBundle\Wsdl\CarrierOptionsType $carrier_options
     * @param string $label_type
     * @param bool $resize
     * @param string $orientation
     * @param bool $pod
     * @param bool $documents
     * @param bool $cod
     * @param bool $dangerous
     * @param string $relay_id
     */
    public function __construct($reference = null, $value = null, $carrier = null, $format = null, \Cocorico\EdnBundle\Wsdl\AddressType $from = null, \Cocorico\EdnBundle\Wsdl\AddressType $to = null, array $packages = array(), $client_account = null, $pack = null, $auto_relay = null, $customs_mode = null, $currency = null, \Cocorico\EdnBundle\Wsdl\CarrierOptionsType $carrier_options = null, $label_type = null, $resize = null, $orientation = null, $pod = null, $documents = null, $cod = null, $dangerous = null, $relay_id = null)
    {
        $this
            ->setReference($reference)
            ->setValue($value)
            ->setCarrier($carrier)
            ->setFormat($format)
            ->setFrom($from)
            ->setTo($to)
            ->setPackages($packages)
            ->setClient_account($client_account)
            ->setPack($pack)
            ->setAuto_relay($auto_relay)
            ->setCustoms_mode($customs_mode)
            ->setCurrency($currency)
            ->setCarrier_options($carrier_options)
            ->setLabel_type($label_type)
            ->setResize($resize)
            ->setOrientation($orientation)
            ->setPod($pod)
            ->setDocuments($documents)
            ->setCod($cod)
            ->setDangerous($dangerous)
            ->setRelay_id($relay_id);
    }
    /**
     * Get reference value
     * @return string
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \Cocorico\EdnBundle\Wsdl\CreateShipmentRequest
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get value value
     * @return float
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param float $value
     * @return \Cocorico\EdnBundle\Wsdl\CreateShipmentRequest
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get carrier value
     * @return string
     */
    public function getCarrier()
    {
        return $this->carrier;
    }
    /**
     * Set carrier value
     * @uses \Cocorico\EdnBundle\Wsdl\EnumCarrierType::valueIsValid()
     * @uses \Cocorico\EdnBundle\Wsdl\EnumCarrierType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $carrier
     * @return \Cocorico\EdnBundle\Wsdl\CreateShipmentRequest
     */
    public function setCarrier($carrier = null)
    {
        // validation for constraint: enumeration
        if (!\Cocorico\EdnBundle\Wsdl\EnumCarrierType::valueIsValid($carrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Cocorico\EdnBundle\Wsdl\EnumCarrierType', is_array($carrier) ? implode(', ', $carrier) : var_export($carrier, true), implode(', ', \Cocorico\EdnBundle\Wsdl\EnumCarrierType::getValidValues())), __LINE__);
        }
        $this->carrier = $carrier;
        return $this;
    }
    /**
     * Get format value
     * @return string
     */
    public function getFormat()
    {
        return $this->format;
    }
    /**
     * Set format value
     * @uses \Cocorico\EdnBundle\Wsdl\EnumFormatType::valueIsValid()
     * @uses \Cocorico\EdnBundle\Wsdl\EnumFormatType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $format
     * @return \Cocorico\EdnBundle\Wsdl\CreateShipmentRequest
     */
    public function setFormat($format = null)
    {
        // validation for constraint: enumeration
        if (!\Cocorico\EdnBundle\Wsdl\EnumFormatType::valueIsValid($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Cocorico\EdnBundle\Wsdl\EnumFormatType', is_array($format) ? implode(', ', $format) : var_export($format, true), implode(', ', \Cocorico\EdnBundle\Wsdl\EnumFormatType::getValidValues())), __LINE__);
        }
        $this->format = $format;
        return $this;
    }
    /**
     * Get from value
     * @return \Cocorico\EdnBundle\Wsdl\AddressType
     */
    public function getFrom()
    {
        return $this->from;
    }
    /**
     * Set from value
     * @param \Cocorico\EdnBundle\Wsdl\AddressType $from
     * @return \Cocorico\EdnBundle\Wsdl\CreateShipmentRequest
     */
    public function setFrom(\Cocorico\EdnBundle\Wsdl\AddressType $from = null)
    {
        $this->from = $from;
        return $this;
    }
    /**
     * Get to value
     * @return \Cocorico\EdnBundle\Wsdl\AddressType
     */
    public function getTo()
    {
        return $this->to;
    }
    /**
     * Set to value
     * @param \Cocorico\EdnBundle\Wsdl\AddressType $to
     * @return \Cocorico\EdnBundle\Wsdl\CreateShipmentRequest
     */
    public function setTo(\Cocorico\EdnBundle\Wsdl\AddressType $to = null)
    {
        $this->to = $to;
        return $this;
    }
    /**
     * Get packages value
     * @return \Cocorico\EdnBundle\Wsdl\PackageType[]
     */
    public function getPackages()
    {
        return $this->packages;
    }
    /**
     * This method is responsible for validating the values passed to the setPackages method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackages method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackagesForArrayConstraintsFromSetPackages(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $createShipmentRequestPackagesItem) {
            // validation for constraint: itemType
            if (!$createShipmentRequestPackagesItem instanceof \Cocorico\EdnBundle\Wsdl\PackageType) {
                $invalidValues[] = is_object($createShipmentRequestPackagesItem) ? get_class($createShipmentRequestPackagesItem) : sprintf('%s(%s)', gettype($createShipmentRequestPackagesItem), var_export($createShipmentRequestPackagesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The packages property can only contain items of type \Cocorico\EdnBundle\Wsdl\PackageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set packages value
     * @throws \InvalidArgumentException
     * @param \Cocorico\EdnBundle\Wsdl\PackageType[] $packages
     * @return \Cocorico\EdnBundle\Wsdl\CreateShipmentRequest
     */
    public function setPackages(array $packages = array())
    {
        // validation for constraint: array
        if ('' !== ($packagesArrayErrorMessage = self::validatePackagesForArrayConstraintsFromSetPackages($packages))) {
            throw new \InvalidArgumentException($packagesArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($packages) && count($packages) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 1', count($packages)), __LINE__);
        }
        $this->packages = $packages;
        return $this;
    }
    /**
     * Add item to packages value
     * @throws \InvalidArgumentException
     * @param \Cocorico\EdnBundle\Wsdl\PackageType $item
     * @return \Cocorico\EdnBundle\Wsdl\CreateShipmentRequest
     */
    public function addToPackages(\Cocorico\EdnBundle\Wsdl\PackageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Cocorico\EdnBundle\Wsdl\PackageType) {
            throw new \InvalidArgumentException(sprintf('The packages property can only contain items of type \Cocorico\EdnBundle\Wsdl\PackageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($this->packages) && count($this->packages) >= 1) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 1', count($this->packages)), __LINE__);
        }
        $this->packages[] = $item;
        return $this;
    }
    /**
     * Get client_account value
     * @return bool|null
     */
    public function getClient_account()
    {
        return $this->client_account;
    }
    /**
     * Set client_account value
     * @param bool $client_account
     * @return \Cocorico\EdnBundle\Wsdl\CreateShipmentRequest
     */
    public function setClient_account($client_account = null)
    {
        // validation for constraint: boolean
        if (!is_null($client_account) && !is_bool($client_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($client_account, true), gettype($client_account)), __LINE__);
        }
        $this->client_account = $client_account;
        return $this;
    }
    /**
     * Get pack value
     * @return string|null
     */
    public function getPack()
    {
        return $this->pack;
    }
    /**
     * Set pack value
     * @param string $pack
     * @return \Cocorico\EdnBundle\Wsdl\CreateShipmentRequest
     */
    public function setPack($pack = null)
    {
        // validation for constraint: string
        if (!is_null($pack) && !is_string($pack)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pack, true), gettype($pack)), __LINE__);
        }
        $this->pack = $pack;
        return $this;
    }
    /**
     * Get auto_relay value
     * @return bool|null
     */
    public function getAuto_relay()
    {
        return $this->auto_relay;
    }
    /**
     * Set auto_relay value
     * @param bool $auto_relay
     * @return \Cocorico\EdnBundle\Wsdl\CreateShipmentRequest
     */
    public function setAuto_relay($auto_relay = null)
    {
        // validation for constraint: boolean
        if (!is_null($auto_relay) && !is_bool($auto_relay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($auto_relay, true), gettype($auto_relay)), __LINE__);
        }
        $this->auto_relay = $auto_relay;
        return $this;
    }
    /**
     * Get customs_mode value
     * @return string|null
     */
    public function getCustoms_mode()
    {
        return $this->customs_mode;
    }
    /**
     * Set customs_mode value
     * @param string $customs_mode
     * @return \Cocorico\EdnBundle\Wsdl\CreateShipmentRequest
     */
    public function setCustoms_mode($customs_mode = null)
    {
        // validation for constraint: string
        if (!is_null($customs_mode) && !is_string($customs_mode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customs_mode, true), gettype($customs_mode)), __LINE__);
        }
        $this->customs_mode = $customs_mode;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \Cocorico\EdnBundle\Wsdl\CreateShipmentRequest
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get carrier_options value
     * @return \Cocorico\EdnBundle\Wsdl\CarrierOptionsType|null
     */
    public function getCarrier_options()
    {
        return $this->carrier_options;
    }
    /**
     * Set carrier_options value
     * @param \Cocorico\EdnBundle\Wsdl\CarrierOptionsType $carrier_options
     * @return \Cocorico\EdnBundle\Wsdl\CreateShipmentRequest
     */
    public function setCarrier_options(\Cocorico\EdnBundle\Wsdl\CarrierOptionsType $carrier_options = null)
    {
        $this->carrier_options = $carrier_options;
        return $this;
    }
    /**
     * Get label_type value
     * @return string|null
     */
    public function getLabel_type()
    {
        return $this->label_type;
    }
    /**
     * Set label_type value
     * @uses \Cocorico\EdnBundle\Wsdl\EnumLabelType::valueIsValid()
     * @uses \Cocorico\EdnBundle\Wsdl\EnumLabelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $label_type
     * @return \Cocorico\EdnBundle\Wsdl\CreateShipmentRequest
     */
    public function setLabel_type($label_type = null)
    {
        // validation for constraint: enumeration
        if (!\Cocorico\EdnBundle\Wsdl\EnumLabelType::valueIsValid($label_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Cocorico\EdnBundle\Wsdl\EnumLabelType', is_array($label_type) ? implode(', ', $label_type) : var_export($label_type, true), implode(', ', \Cocorico\EdnBundle\Wsdl\EnumLabelType::getValidValues())), __LINE__);
        }
        $this->label_type = $label_type;
        return $this;
    }
    /**
     * Get resize value
     * @return bool|null
     */
    public function getResize()
    {
        return $this->resize;
    }
    /**
     * Set resize value
     * @param bool $resize
     * @return \Cocorico\EdnBundle\Wsdl\CreateShipmentRequest
     */
    public function setResize($resize = null)
    {
        // validation for constraint: boolean
        if (!is_null($resize) && !is_bool($resize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($resize, true), gettype($resize)), __LINE__);
        }
        $this->resize = $resize;
        return $this;
    }
    /**
     * Get orientation value
     * @return string|null
     */
    public function getOrientation()
    {
        return $this->orientation;
    }
    /**
     * Set orientation value
     * @uses \Cocorico\EdnBundle\Wsdl\EnumOrientationType::valueIsValid()
     * @uses \Cocorico\EdnBundle\Wsdl\EnumOrientationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $orientation
     * @return \Cocorico\EdnBundle\Wsdl\CreateShipmentRequest
     */
    public function setOrientation($orientation = null)
    {
        // validation for constraint: enumeration
        if (!\Cocorico\EdnBundle\Wsdl\EnumOrientationType::valueIsValid($orientation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Cocorico\EdnBundle\Wsdl\EnumOrientationType', is_array($orientation) ? implode(', ', $orientation) : var_export($orientation, true), implode(', ', \Cocorico\EdnBundle\Wsdl\EnumOrientationType::getValidValues())), __LINE__);
        }
        $this->orientation = $orientation;
        return $this;
    }
    /**
     * Get pod value
     * @return bool|null
     */
    public function getPod()
    {
        return $this->pod;
    }
    /**
     * Set pod value
     * @param bool $pod
     * @return \Cocorico\EdnBundle\Wsdl\CreateShipmentRequest
     */
    public function setPod($pod = null)
    {
        // validation for constraint: boolean
        if (!is_null($pod) && !is_bool($pod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pod, true), gettype($pod)), __LINE__);
        }
        $this->pod = $pod;
        return $this;
    }
    /**
     * Get documents value
     * @return bool|null
     */
    public function getDocuments()
    {
        return $this->documents;
    }
    /**
     * Set documents value
     * @param bool $documents
     * @return \Cocorico\EdnBundle\Wsdl\CreateShipmentRequest
     */
    public function setDocuments($documents = null)
    {
        // validation for constraint: boolean
        if (!is_null($documents) && !is_bool($documents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($documents, true), gettype($documents)), __LINE__);
        }
        $this->documents = $documents;
        return $this;
    }
    /**
     * Get cod value
     * @return bool|null
     */
    public function getCod()
    {
        return $this->cod;
    }
    /**
     * Set cod value
     * @param bool $cod
     * @return \Cocorico\EdnBundle\Wsdl\CreateShipmentRequest
     */
    public function setCod($cod = null)
    {
        // validation for constraint: boolean
        if (!is_null($cod) && !is_bool($cod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cod, true), gettype($cod)), __LINE__);
        }
        $this->cod = $cod;
        return $this;
    }
    /**
     * Get dangerous value
     * @return bool|null
     */
    public function getDangerous()
    {
        return $this->dangerous;
    }
    /**
     * Set dangerous value
     * @param bool $dangerous
     * @return \Cocorico\EdnBundle\Wsdl\CreateShipmentRequest
     */
    public function setDangerous($dangerous = null)
    {
        // validation for constraint: boolean
        if (!is_null($dangerous) && !is_bool($dangerous)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($dangerous, true), gettype($dangerous)), __LINE__);
        }
        $this->dangerous = $dangerous;
        return $this;
    }
    /**
     * Get relay_id value
     * @return string|null
     */
    public function getRelay_id()
    {
        return $this->relay_id;
    }
    /**
     * Set relay_id value
     * @param string $relay_id
     * @return \Cocorico\EdnBundle\Wsdl\CreateShipmentRequest
     */
    public function setRelay_id($relay_id = null)
    {
        // validation for constraint: string
        if (!is_null($relay_id) && !is_string($relay_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relay_id, true), gettype($relay_id)), __LINE__);
        }
        $this->relay_id = $relay_id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Cocorico\EdnBundle\Wsdl\CreateShipmentRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
