<?php

namespace Cocorico\EdnBundle\Wsdl;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named createShipment
     * Meta information extracted from the WSDL
     * - documentation: Create a shipment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Cocorico\EdnBundle\Wsdl\LoginType $login
     * @param \Cocorico\EdnBundle\Wsdl\CreateShipmentRequest $params
     * @return array|bool
     */
    public function createShipment(\Cocorico\EdnBundle\Wsdl\LoginType $login, \Cocorico\EdnBundle\Wsdl\CreateShipmentRequest $params)
    {
        try {
            $this->setResult($this->getSoapClient()->createShipment($login, $params));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createReturn
     * Meta information extracted from the WSDL
     * - documentation: Create a return
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Cocorico\EdnBundle\Wsdl\LoginType $login
     * @param \Cocorico\EdnBundle\Wsdl\CreateReturnRequest $params
     * @return array|bool
     */
    public function createReturn(\Cocorico\EdnBundle\Wsdl\LoginType $login, \Cocorico\EdnBundle\Wsdl\CreateReturnRequest $params)
    {
        try {
            $this->setResult($this->getSoapClient()->createReturn($login, $params));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createPickup
     * Meta information extracted from the WSDL
     * - documentation: Create a pickup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Cocorico\EdnBundle\Wsdl\LoginType $login
     * @param \Cocorico\EdnBundle\Wsdl\CreatePickupRequest $params
     * @return array|bool
     */
    public function createPickup(\Cocorico\EdnBundle\Wsdl\LoginType $login, \Cocorico\EdnBundle\Wsdl\CreatePickupRequest $params)
    {
        try {
            $this->setResult($this->getSoapClient()->createPickup($login, $params));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
