<?php

namespace Cocorico\EdnBundle\Wsdl;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addressType StructType
 * @subpackage Structs
 */
class AddressType extends AbstractStructBase
{
    /**
     * The address1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $address1;
    /**
     * The postcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $postcode;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $city;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - documentation: 2-letter country ISO code
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $country;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $email;
    /**
     * The company
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $company;
    /**
     * The firstname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $firstname;
    /**
     * The lastname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lastname;
    /**
     * The address2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $address2;
    /**
     * The address3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $address3;
    /**
     * The address4
     * Meta information extracted from the WSDL
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $address4;
    /**
     * The state
     * Meta information extracted from the WSDL
     * - documentation: 2-letter state code, required for US and Canada
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $state;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $phone;
    /**
     * The mobilephone
     * Meta information extracted from the WSDL
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mobilephone;
    /**
     * Constructor method for addressType
     * @uses AddressType::setAddress1()
     * @uses AddressType::setPostcode()
     * @uses AddressType::setCity()
     * @uses AddressType::setCountry()
     * @uses AddressType::setEmail()
     * @uses AddressType::setCompany()
     * @uses AddressType::setFirstname()
     * @uses AddressType::setLastname()
     * @uses AddressType::setAddress2()
     * @uses AddressType::setAddress3()
     * @uses AddressType::setAddress4()
     * @uses AddressType::setState()
     * @uses AddressType::setPhone()
     * @uses AddressType::setMobilephone()
     * @param string $address1
     * @param string $postcode
     * @param string $city
     * @param string $country
     * @param string $email
     * @param string $company
     * @param string $firstname
     * @param string $lastname
     * @param string $address2
     * @param string $address3
     * @param string $address4
     * @param string $state
     * @param string $phone
     * @param string $mobilephone
     */
    public function __construct($address1 = null, $postcode = null, $city = null, $country = null, $email = null, $company = null, $firstname = null, $lastname = null, $address2 = null, $address3 = null, $address4 = null, $state = null, $phone = null, $mobilephone = null)
    {
        $this
            ->setAddress1($address1)
            ->setPostcode($postcode)
            ->setCity($city)
            ->setCountry($country)
            ->setEmail($email)
            ->setCompany($company)
            ->setFirstname($firstname)
            ->setLastname($lastname)
            ->setAddress2($address2)
            ->setAddress3($address3)
            ->setAddress4($address4)
            ->setState($state)
            ->setPhone($phone)
            ->setMobilephone($mobilephone);
    }
    /**
     * Get address1 value
     * @return string
     */
    public function getAddress1()
    {
        return $this->address1;
    }
    /**
     * Set address1 value
     * @param string $address1
     * @return \Cocorico\EdnBundle\Wsdl\AddressType
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address1, true), gettype($address1)), __LINE__);
        }
        $this->address1 = $address1;
        return $this;
    }
    /**
     * Get postcode value
     * @return string
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \Cocorico\EdnBundle\Wsdl\AddressType
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get city value
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \Cocorico\EdnBundle\Wsdl\AddressType
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get country value
     * @return string
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \Cocorico\EdnBundle\Wsdl\AddressType
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get email value
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \Cocorico\EdnBundle\Wsdl\AddressType
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get company value
     * @return string|null
     */
    public function getCompany()
    {
        return $this->company;
    }
    /**
     * Set company value
     * @param string $company
     * @return \Cocorico\EdnBundle\Wsdl\AddressType
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($company, true), gettype($company)), __LINE__);
        }
        $this->company = $company;
        return $this;
    }
    /**
     * Get firstname value
     * @return string|null
     */
    public function getFirstname()
    {
        return $this->firstname;
    }
    /**
     * Set firstname value
     * @param string $firstname
     * @return \Cocorico\EdnBundle\Wsdl\AddressType
     */
    public function setFirstname($firstname = null)
    {
        // validation for constraint: string
        if (!is_null($firstname) && !is_string($firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstname, true), gettype($firstname)), __LINE__);
        }
        $this->firstname = $firstname;
        return $this;
    }
    /**
     * Get lastname value
     * @return string|null
     */
    public function getLastname()
    {
        return $this->lastname;
    }
    /**
     * Set lastname value
     * @param string $lastname
     * @return \Cocorico\EdnBundle\Wsdl\AddressType
     */
    public function setLastname($lastname = null)
    {
        // validation for constraint: string
        if (!is_null($lastname) && !is_string($lastname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastname, true), gettype($lastname)), __LINE__);
        }
        $this->lastname = $lastname;
        return $this;
    }
    /**
     * Get address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->address2;
    }
    /**
     * Set address2 value
     * @param string $address2
     * @return \Cocorico\EdnBundle\Wsdl\AddressType
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address2, true), gettype($address2)), __LINE__);
        }
        $this->address2 = $address2;
        return $this;
    }
    /**
     * Get address3 value
     * @return string|null
     */
    public function getAddress3()
    {
        return $this->address3;
    }
    /**
     * Set address3 value
     * @param string $address3
     * @return \Cocorico\EdnBundle\Wsdl\AddressType
     */
    public function setAddress3($address3 = null)
    {
        // validation for constraint: string
        if (!is_null($address3) && !is_string($address3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address3, true), gettype($address3)), __LINE__);
        }
        $this->address3 = $address3;
        return $this;
    }
    /**
     * Get address4 value
     * @return string|null
     */
    public function getAddress4()
    {
        return $this->address4;
    }
    /**
     * Set address4 value
     * @param string $address4
     * @return \Cocorico\EdnBundle\Wsdl\AddressType
     */
    public function setAddress4($address4 = null)
    {
        // validation for constraint: string
        if (!is_null($address4) && !is_string($address4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address4, true), gettype($address4)), __LINE__);
        }
        $this->address4 = $address4;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @param string $state
     * @return \Cocorico\EdnBundle\Wsdl\AddressType
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \Cocorico\EdnBundle\Wsdl\AddressType
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get mobilephone value
     * @return string|null
     */
    public function getMobilephone()
    {
        return $this->mobilephone;
    }
    /**
     * Set mobilephone value
     * @param string $mobilephone
     * @return \Cocorico\EdnBundle\Wsdl\AddressType
     */
    public function setMobilephone($mobilephone = null)
    {
        // validation for constraint: string
        if (!is_null($mobilephone) && !is_string($mobilephone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobilephone, true), gettype($mobilephone)), __LINE__);
        }
        $this->mobilephone = $mobilephone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Cocorico\EdnBundle\Wsdl\AddressType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
