<?php

namespace Cocorico\EdnBundle\Wsdl;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for zoneType StructType
 * @subpackage Structs
 */
class ZoneType extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $name;
    /**
     * The countries
     * Meta information extracted from the WSDL
     * - arrayType: xsd:string[]
     * - base: SOAP-ENC:Array
     * - maxOccurs: 1
     * - minOccurs: 1
     * - ref: SOAP-ENC:arrayType
     * @var string[]
     */
    public $countries;
    /**
     * Constructor method for zoneType
     * @uses ZoneType::setName()
     * @uses ZoneType::setCountries()
     * @param string $name
     * @param string[] $countries
     */
    public function __construct($name = null, array $countries = array())
    {
        $this
            ->setName($name)
            ->setCountries($countries);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Cocorico\EdnBundle\Wsdl\ZoneType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get countries value
     * @return string[]
     */
    public function getCountries()
    {
        return $this->countries;
    }
    /**
     * This method is responsible for validating the values passed to the setCountries method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCountries method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCountriesForArrayConstraintsFromSetCountries(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $zoneTypeCountriesItem) {
            // validation for constraint: itemType
            if (!is_string($zoneTypeCountriesItem)) {
                $invalidValues[] = is_object($zoneTypeCountriesItem) ? get_class($zoneTypeCountriesItem) : sprintf('%s(%s)', gettype($zoneTypeCountriesItem), var_export($zoneTypeCountriesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The countries property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set countries value
     * @throws \InvalidArgumentException
     * @param string[] $countries
     * @return \Cocorico\EdnBundle\Wsdl\ZoneType
     */
    public function setCountries(array $countries = array())
    {
        // validation for constraint: array
        if ('' !== ($countriesArrayErrorMessage = self::validateCountriesForArrayConstraintsFromSetCountries($countries))) {
            throw new \InvalidArgumentException($countriesArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($countries) && count($countries) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 1', count($countries)), __LINE__);
        }
        $this->countries = $countries;
        return $this;
    }
    /**
     * Add item to countries value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Cocorico\EdnBundle\Wsdl\ZoneType
     */
    public function addToCountries($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The countries property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($this->countries) && count($this->countries) >= 1) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 1', count($this->countries)), __LINE__);
        }
        $this->countries[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Cocorico\EdnBundle\Wsdl\ZoneType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
