<?php

namespace Cocorico\EdnBundle\Wsdl;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getPricingResponse StructType
 * @subpackage Structs
 */
class GetPricingResponse extends AbstractStructBase
{
    /**
     * The query_at
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $query_at;
    /**
     * The zones
     * Meta information extracted from the WSDL
     * - arrayType: tns:zoneType[]
     * - base: SOAP-ENC:Array
     * - maxOccurs: 1
     * - minOccurs: 1
     * - ref: SOAP-ENC:arrayType
     * @var \Cocorico\EdnBundle\Wsdl\ZoneType[]
     */
    public $zones;
    /**
     * The pricing
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var mixed
     */
    public $pricing;
    /**
     * Constructor method for getPricingResponse
     * @uses GetPricingResponse::setQuery_at()
     * @uses GetPricingResponse::setZones()
     * @uses GetPricingResponse::setPricing()
     * @param int $query_at
     * @param \Cocorico\EdnBundle\Wsdl\ZoneType[] $zones
     * @param mixed $pricing
     */
    public function __construct($query_at = null, array $zones = array(), $pricing = null)
    {
        $this
            ->setQuery_at($query_at)
            ->setZones($zones)
            ->setPricing($pricing);
    }
    /**
     * Get query_at value
     * @return int
     */
    public function getQuery_at()
    {
        return $this->query_at;
    }
    /**
     * Set query_at value
     * @param int $query_at
     * @return \Cocorico\EdnBundle\Wsdl\GetPricingResponse
     */
    public function setQuery_at($query_at = null)
    {
        // validation for constraint: int
        if (!is_null($query_at) && !(is_int($query_at) || ctype_digit($query_at))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($query_at, true), gettype($query_at)), __LINE__);
        }
        $this->query_at = $query_at;
        return $this;
    }
    /**
     * Get zones value
     * @return \Cocorico\EdnBundle\Wsdl\ZoneType[]
     */
    public function getZones()
    {
        return $this->zones;
    }
    /**
     * This method is responsible for validating the values passed to the setZones method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZones method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZonesForArrayConstraintsFromSetZones(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getPricingResponseZonesItem) {
            // validation for constraint: itemType
            if (!$getPricingResponseZonesItem instanceof \Cocorico\EdnBundle\Wsdl\ZoneType) {
                $invalidValues[] = is_object($getPricingResponseZonesItem) ? get_class($getPricingResponseZonesItem) : sprintf('%s(%s)', gettype($getPricingResponseZonesItem), var_export($getPricingResponseZonesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The zones property can only contain items of type \Cocorico\EdnBundle\Wsdl\ZoneType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set zones value
     * @throws \InvalidArgumentException
     * @param \Cocorico\EdnBundle\Wsdl\ZoneType[] $zones
     * @return \Cocorico\EdnBundle\Wsdl\GetPricingResponse
     */
    public function setZones(array $zones = array())
    {
        // validation for constraint: array
        if ('' !== ($zonesArrayErrorMessage = self::validateZonesForArrayConstraintsFromSetZones($zones))) {
            throw new \InvalidArgumentException($zonesArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($zones) && count($zones) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 1', count($zones)), __LINE__);
        }
        $this->zones = $zones;
        return $this;
    }
    /**
     * Add item to zones value
     * @throws \InvalidArgumentException
     * @param \Cocorico\EdnBundle\Wsdl\ZoneType $item
     * @return \Cocorico\EdnBundle\Wsdl\GetPricingResponse
     */
    public function addToZones(\Cocorico\EdnBundle\Wsdl\ZoneType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Cocorico\EdnBundle\Wsdl\ZoneType) {
            throw new \InvalidArgumentException(sprintf('The zones property can only contain items of type \Cocorico\EdnBundle\Wsdl\ZoneType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($this->zones) && count($this->zones) >= 1) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 1', count($this->zones)), __LINE__);
        }
        $this->zones[] = $item;
        return $this;
    }
    /**
     * Get pricing value
     * @return mixed
     */
    public function getPricing()
    {
        return $this->pricing;
    }
    /**
     * Set pricing value
     * @param mixed $pricing
     * @return \Cocorico\EdnBundle\Wsdl\GetPricingResponse
     */
    public function setPricing($pricing = null)
    {
        $this->pricing = $pricing;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Cocorico\EdnBundle\Wsdl\GetPricingResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
