<?php

namespace Cocorico\EdnBundle\Wsdl;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createPickupRequest StructType
 * @subpackage Structs
 */
class CreatePickupRequest extends AbstractStructBase
{
    /**
     * The carrier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $carrier;
    /**
     * The date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $date;
    /**
     * The min_hour
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $min_hour;
    /**
     * The max_hour
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $max_hour;
    /**
     * The address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Cocorico\EdnBundle\Wsdl\AddressType
     */
    public $address;
    /**
     * The package_count
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $package_count;
    /**
     * The total_weight
     * Meta information extracted from the WSDL
     * - documentation: Total weight of the packages, in kilograms
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $total_weight;
    /**
     * The regular_pickup
     * Meta information extracted from the WSDL
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $regular_pickup;
    /**
     * Constructor method for createPickupRequest
     * @uses CreatePickupRequest::setCarrier()
     * @uses CreatePickupRequest::setDate()
     * @uses CreatePickupRequest::setMin_hour()
     * @uses CreatePickupRequest::setMax_hour()
     * @uses CreatePickupRequest::setAddress()
     * @uses CreatePickupRequest::setPackage_count()
     * @uses CreatePickupRequest::setTotal_weight()
     * @uses CreatePickupRequest::setRegular_pickup()
     * @param string $carrier
     * @param string $date
     * @param string $min_hour
     * @param string $max_hour
     * @param \Cocorico\EdnBundle\Wsdl\AddressType $address
     * @param int $package_count
     * @param float $total_weight
     * @param bool $regular_pickup
     */
    public function __construct($carrier = null, $date = null, $min_hour = null, $max_hour = null, \Cocorico\EdnBundle\Wsdl\AddressType $address = null, $package_count = null, $total_weight = null, $regular_pickup = null)
    {
        $this
            ->setCarrier($carrier)
            ->setDate($date)
            ->setMin_hour($min_hour)
            ->setMax_hour($max_hour)
            ->setAddress($address)
            ->setPackage_count($package_count)
            ->setTotal_weight($total_weight)
            ->setRegular_pickup($regular_pickup);
    }
    /**
     * Get carrier value
     * @return string
     */
    public function getCarrier()
    {
        return $this->carrier;
    }
    /**
     * Set carrier value
     * @uses \Cocorico\EdnBundle\Wsdl\EnumCarrierType::valueIsValid()
     * @uses \Cocorico\EdnBundle\Wsdl\EnumCarrierType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $carrier
     * @return \Cocorico\EdnBundle\Wsdl\CreatePickupRequest
     */
    public function setCarrier($carrier = null)
    {
        // validation for constraint: enumeration
        if (!\Cocorico\EdnBundle\Wsdl\EnumCarrierType::valueIsValid($carrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Cocorico\EdnBundle\Wsdl\EnumCarrierType', is_array($carrier) ? implode(', ', $carrier) : var_export($carrier, true), implode(', ', \Cocorico\EdnBundle\Wsdl\EnumCarrierType::getValidValues())), __LINE__);
        }
        $this->carrier = $carrier;
        return $this;
    }
    /**
     * Get date value
     * @return string
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \Cocorico\EdnBundle\Wsdl\CreatePickupRequest
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get min_hour value
     * @return string
     */
    public function getMin_hour()
    {
        return $this->min_hour;
    }
    /**
     * Set min_hour value
     * @param string $min_hour
     * @return \Cocorico\EdnBundle\Wsdl\CreatePickupRequest
     */
    public function setMin_hour($min_hour = null)
    {
        // validation for constraint: string
        if (!is_null($min_hour) && !is_string($min_hour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($min_hour, true), gettype($min_hour)), __LINE__);
        }
        $this->min_hour = $min_hour;
        return $this;
    }
    /**
     * Get max_hour value
     * @return string
     */
    public function getMax_hour()
    {
        return $this->max_hour;
    }
    /**
     * Set max_hour value
     * @param string $max_hour
     * @return \Cocorico\EdnBundle\Wsdl\CreatePickupRequest
     */
    public function setMax_hour($max_hour = null)
    {
        // validation for constraint: string
        if (!is_null($max_hour) && !is_string($max_hour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($max_hour, true), gettype($max_hour)), __LINE__);
        }
        $this->max_hour = $max_hour;
        return $this;
    }
    /**
     * Get address value
     * @return \Cocorico\EdnBundle\Wsdl\AddressType
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param \Cocorico\EdnBundle\Wsdl\AddressType $address
     * @return \Cocorico\EdnBundle\Wsdl\CreatePickupRequest
     */
    public function setAddress(\Cocorico\EdnBundle\Wsdl\AddressType $address = null)
    {
        $this->address = $address;
        return $this;
    }
    /**
     * Get package_count value
     * @return int|null
     */
    public function getPackage_count()
    {
        return $this->package_count;
    }
    /**
     * Set package_count value
     * @param int $package_count
     * @return \Cocorico\EdnBundle\Wsdl\CreatePickupRequest
     */
    public function setPackage_count($package_count = null)
    {
        // validation for constraint: int
        if (!is_null($package_count) && !(is_int($package_count) || ctype_digit($package_count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($package_count, true), gettype($package_count)), __LINE__);
        }
        $this->package_count = $package_count;
        return $this;
    }
    /**
     * Get total_weight value
     * @return float|null
     */
    public function getTotal_weight()
    {
        return $this->total_weight;
    }
    /**
     * Set total_weight value
     * @param float $total_weight
     * @return \Cocorico\EdnBundle\Wsdl\CreatePickupRequest
     */
    public function setTotal_weight($total_weight = null)
    {
        // validation for constraint: float
        if (!is_null($total_weight) && !(is_float($total_weight) || is_numeric($total_weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total_weight, true), gettype($total_weight)), __LINE__);
        }
        $this->total_weight = $total_weight;
        return $this;
    }
    /**
     * Get regular_pickup value
     * @return bool|null
     */
    public function getRegular_pickup()
    {
        return $this->regular_pickup;
    }
    /**
     * Set regular_pickup value
     * @param bool $regular_pickup
     * @return \Cocorico\EdnBundle\Wsdl\CreatePickupRequest
     */
    public function setRegular_pickup($regular_pickup = null)
    {
        // validation for constraint: boolean
        if (!is_null($regular_pickup) && !is_bool($regular_pickup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($regular_pickup, true), gettype($regular_pickup)), __LINE__);
        }
        $this->regular_pickup = $regular_pickup;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Cocorico\EdnBundle\Wsdl\CreatePickupRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
