<?php

namespace Cocorico\EdnBundle\Wsdl;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'loginType' => '\\Cocorico\\EdnBundle\\Wsdl\\LoginType',
            'extendedLoginType' => '\\Cocorico\\EdnBundle\\Wsdl\\ExtendedLoginType',
            'errorType' => '\\Cocorico\\EdnBundle\\Wsdl\\ErrorType',
            'addressType' => '\\Cocorico\\EdnBundle\\Wsdl\\AddressType',
            'quoteAddressType' => '\\Cocorico\\EdnBundle\\Wsdl\\QuoteAddressType',
            'productType' => '\\Cocorico\\EdnBundle\\Wsdl\\ProductType',
            'findRelaysRequest' => '\\Cocorico\\EdnBundle\\Wsdl\\FindRelaysRequest',
            'findRelaysResponse' => '\\Cocorico\\EdnBundle\\Wsdl\\FindRelaysResponse',
            'getRelayRequest' => '\\Cocorico\\EdnBundle\\Wsdl\\GetRelayRequest',
            'getRelayResponse' => '\\Cocorico\\EdnBundle\\Wsdl\\GetRelayResponse',
            'getQuoteRequest' => '\\Cocorico\\EdnBundle\\Wsdl\\GetQuoteRequest',
            'getCarrierQuoteRequest' => '\\Cocorico\\EdnBundle\\Wsdl\\GetCarrierQuoteRequest',
            'getBuyingPriceRequest' => '\\Cocorico\\EdnBundle\\Wsdl\\GetBuyingPriceRequest',
            'getQuoteResponse' => '\\Cocorico\\EdnBundle\\Wsdl\\GetQuoteResponse',
            'getPricingResponse' => '\\Cocorico\\EdnBundle\\Wsdl\\GetPricingResponse',
            'carrierType' => '\\Cocorico\\EdnBundle\\Wsdl\\CarrierType',
            'carrierCompanyType' => '\\Cocorico\\EdnBundle\\Wsdl\\CarrierCompanyType',
            'carrierOptionsType' => '\\Cocorico\\EdnBundle\\Wsdl\\CarrierOptionsType',
            'getCarriersResponse' => '\\Cocorico\\EdnBundle\\Wsdl\\GetCarriersResponse',
            'getCarrierCompaniesResponse' => '\\Cocorico\\EdnBundle\\Wsdl\\GetCarrierCompaniesResponse',
            'createShipmentRequest' => '\\Cocorico\\EdnBundle\\Wsdl\\CreateShipmentRequest',
            'createShipmentResponse' => '\\Cocorico\\EdnBundle\\Wsdl\\CreateShipmentResponse',
            'createReturnRequest' => '\\Cocorico\\EdnBundle\\Wsdl\\CreateReturnRequest',
            'createReturnResponse' => '\\Cocorico\\EdnBundle\\Wsdl\\CreateReturnResponse',
            'packageType' => '\\Cocorico\\EdnBundle\\Wsdl\\PackageType',
            'quotePackageType' => '\\Cocorico\\EdnBundle\\Wsdl\\QuotePackageType',
            'quoteType' => '\\Cocorico\\EdnBundle\\Wsdl\\QuoteType',
            'carrierQuoteType' => '\\Cocorico\\EdnBundle\\Wsdl\\CarrierQuoteType',
            'buyingPriceType' => '\\Cocorico\\EdnBundle\\Wsdl\\BuyingPriceType',
            'zoneType' => '\\Cocorico\\EdnBundle\\Wsdl\\ZoneType',
            'getShipmentRequest' => '\\Cocorico\\EdnBundle\\Wsdl\\GetShipmentRequest',
            'getShipmentsRequest' => '\\Cocorico\\EdnBundle\\Wsdl\\GetShipmentsRequest',
            'getShipmentsResponse' => '\\Cocorico\\EdnBundle\\Wsdl\\GetShipmentsResponse',
            'shipmentType' => '\\Cocorico\\EdnBundle\\Wsdl\\ShipmentType',
            'trackingEventType' => '\\Cocorico\\EdnBundle\\Wsdl\\TrackingEventType',
            'relayType' => '\\Cocorico\\EdnBundle\\Wsdl\\RelayType',
            'openingHoursType' => '\\Cocorico\\EdnBundle\\Wsdl\\OpeningHoursType',
            'setTrackingEventsRequest' => '\\Cocorico\\EdnBundle\\Wsdl\\SetTrackingEventsRequest',
            'setTrackingEventsResponse' => '\\Cocorico\\EdnBundle\\Wsdl\\SetTrackingEventsResponse',
            'extendedTrackingEventType' => '\\Cocorico\\EdnBundle\\Wsdl\\ExtendedTrackingEventType',
            'createPickupRequest' => '\\Cocorico\\EdnBundle\\Wsdl\\CreatePickupRequest',
            'createPickupResponse' => '\\Cocorico\\EdnBundle\\Wsdl\\CreatePickupResponse',
            'cancelPickupRequest' => '\\Cocorico\\EdnBundle\\Wsdl\\CancelPickupRequest',
            'cancelPickupResponse' => '\\Cocorico\\EdnBundle\\Wsdl\\CancelPickupResponse',
        );
    }
}
