<?php

namespace Cocorico\EdnBundle\Wsdl;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getQuoteResponse StructType
 * @subpackage Structs
 */
class GetQuoteResponse extends AbstractStructBase
{
    /**
     * The quotes
     * Meta information extracted from the WSDL
     * - documentation: Carrier quotes
     * - arrayType: tns:quoteType[]
     * - base: SOAP-ENC:Array
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: SOAP-ENC:arrayType
     * @var \Cocorico\EdnBundle\Wsdl\QuoteType[]
     */
    public $quotes;
    /**
     * The selection
     * Meta information extracted from the WSDL
     * - documentation: Quote selection (best price by service type)
     * - arrayType: tns:quoteType[]
     * - base: SOAP-ENC:Array
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: SOAP-ENC:arrayType
     * @var \Cocorico\EdnBundle\Wsdl\QuoteType[]
     */
    public $selection;
    /**
     * The best_price
     * Meta information extracted from the WSDL
     * - documentation: Cheapest shipping method
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Cocorico\EdnBundle\Wsdl\QuoteType
     */
    public $best_price;
    /**
     * Constructor method for getQuoteResponse
     * @uses GetQuoteResponse::setQuotes()
     * @uses GetQuoteResponse::setSelection()
     * @uses GetQuoteResponse::setBest_price()
     * @param \Cocorico\EdnBundle\Wsdl\QuoteType[] $quotes
     * @param \Cocorico\EdnBundle\Wsdl\QuoteType[] $selection
     * @param \Cocorico\EdnBundle\Wsdl\QuoteType $best_price
     */
    public function __construct(array $quotes = array(), array $selection = array(), \Cocorico\EdnBundle\Wsdl\QuoteType $best_price = null)
    {
        $this
            ->setQuotes($quotes)
            ->setSelection($selection)
            ->setBest_price($best_price);
    }
    /**
     * Get quotes value
     * @return \Cocorico\EdnBundle\Wsdl\QuoteType[]|null
     */
    public function getQuotes()
    {
        return $this->quotes;
    }
    /**
     * This method is responsible for validating the values passed to the setQuotes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQuotes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQuotesForArrayConstraintsFromSetQuotes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getQuoteResponseQuotesItem) {
            // validation for constraint: itemType
            if (!$getQuoteResponseQuotesItem instanceof \Cocorico\EdnBundle\Wsdl\QuoteType) {
                $invalidValues[] = is_object($getQuoteResponseQuotesItem) ? get_class($getQuoteResponseQuotesItem) : sprintf('%s(%s)', gettype($getQuoteResponseQuotesItem), var_export($getQuoteResponseQuotesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The quotes property can only contain items of type \Cocorico\EdnBundle\Wsdl\QuoteType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set quotes value
     * @throws \InvalidArgumentException
     * @param \Cocorico\EdnBundle\Wsdl\QuoteType[] $quotes
     * @return \Cocorico\EdnBundle\Wsdl\GetQuoteResponse
     */
    public function setQuotes(array $quotes = array())
    {
        // validation for constraint: array
        if ('' !== ($quotesArrayErrorMessage = self::validateQuotesForArrayConstraintsFromSetQuotes($quotes))) {
            throw new \InvalidArgumentException($quotesArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($quotes) && count($quotes) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 1', count($quotes)), __LINE__);
        }
        $this->quotes = $quotes;
        return $this;
    }
    /**
     * Add item to quotes value
     * @throws \InvalidArgumentException
     * @param \Cocorico\EdnBundle\Wsdl\QuoteType $item
     * @return \Cocorico\EdnBundle\Wsdl\GetQuoteResponse
     */
    public function addToQuotes(\Cocorico\EdnBundle\Wsdl\QuoteType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Cocorico\EdnBundle\Wsdl\QuoteType) {
            throw new \InvalidArgumentException(sprintf('The quotes property can only contain items of type \Cocorico\EdnBundle\Wsdl\QuoteType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($this->quotes) && count($this->quotes) >= 1) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 1', count($this->quotes)), __LINE__);
        }
        $this->quotes[] = $item;
        return $this;
    }
    /**
     * Get selection value
     * @return \Cocorico\EdnBundle\Wsdl\QuoteType[]|null
     */
    public function getSelection()
    {
        return $this->selection;
    }
    /**
     * This method is responsible for validating the values passed to the setSelection method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelection method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectionForArrayConstraintsFromSetSelection(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getQuoteResponseSelectionItem) {
            // validation for constraint: itemType
            if (!$getQuoteResponseSelectionItem instanceof \Cocorico\EdnBundle\Wsdl\QuoteType) {
                $invalidValues[] = is_object($getQuoteResponseSelectionItem) ? get_class($getQuoteResponseSelectionItem) : sprintf('%s(%s)', gettype($getQuoteResponseSelectionItem), var_export($getQuoteResponseSelectionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The selection property can only contain items of type \Cocorico\EdnBundle\Wsdl\QuoteType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set selection value
     * @throws \InvalidArgumentException
     * @param \Cocorico\EdnBundle\Wsdl\QuoteType[] $selection
     * @return \Cocorico\EdnBundle\Wsdl\GetQuoteResponse
     */
    public function setSelection(array $selection = array())
    {
        // validation for constraint: array
        if ('' !== ($selectionArrayErrorMessage = self::validateSelectionForArrayConstraintsFromSetSelection($selection))) {
            throw new \InvalidArgumentException($selectionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($selection) && count($selection) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 1', count($selection)), __LINE__);
        }
        $this->selection = $selection;
        return $this;
    }
    /**
     * Add item to selection value
     * @throws \InvalidArgumentException
     * @param \Cocorico\EdnBundle\Wsdl\QuoteType $item
     * @return \Cocorico\EdnBundle\Wsdl\GetQuoteResponse
     */
    public function addToSelection(\Cocorico\EdnBundle\Wsdl\QuoteType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Cocorico\EdnBundle\Wsdl\QuoteType) {
            throw new \InvalidArgumentException(sprintf('The selection property can only contain items of type \Cocorico\EdnBundle\Wsdl\QuoteType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($this->selection) && count($this->selection) >= 1) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 1', count($this->selection)), __LINE__);
        }
        $this->selection[] = $item;
        return $this;
    }
    /**
     * Get best_price value
     * @return \Cocorico\EdnBundle\Wsdl\QuoteType|null
     */
    public function getBest_price()
    {
        return $this->best_price;
    }
    /**
     * Set best_price value
     * @param \Cocorico\EdnBundle\Wsdl\QuoteType $best_price
     * @return \Cocorico\EdnBundle\Wsdl\GetQuoteResponse
     */
    public function setBest_price(\Cocorico\EdnBundle\Wsdl\QuoteType $best_price = null)
    {
        $this->best_price = $best_price;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Cocorico\EdnBundle\Wsdl\GetQuoteResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
