<?php

namespace Cocorico\EdnBundle\Wsdl;

/**
 * This class stands for enumFormatType EnumType
 * @subpackage Enumerations
 */
class EnumFormatType
{
    /**
     * Constant for value 'A4'
     * @return string 'A4'
     */
    const VALUE_A_4 = 'A4';
    /**
     * Constant for value 'A6'
     * @return string 'A6'
     */
    const VALUE_A_6 = 'A6';
    /**
     * Constant for value '11x15'
     * Meta information extracted from the WSDL
     * - hidden: hidden
     * @return string '11x15'
     */
    const VALUE_11_X_15 = '11x15';
    /**
     * Constant for value '10x16'
     * Meta information extracted from the WSDL
     * - hidden: hidden
     * @return string '10x16'
     */
    const VALUE_10_X_16 = '10x16';
    /**
     * Constant for value '10x15'
     * Meta information extracted from the WSDL
     * - hidden: hidden
     * @return string '10x15'
     */
    const VALUE_10_X_15 = '10x15';
    /**
     * Constant for value '8x12'
     * Meta information extracted from the WSDL
     * - hidden: hidden
     * @return string '8x12'
     */
    const VALUE_8_X_12 = '8x12';
    /**
     * Constant for value '8x11'
     * Meta information extracted from the WSDL
     * - hidden: hidden
     * @return string '8x11'
     */
    const VALUE_8_X_11 = '8x11';
    /**
     * Constant for value '11x8'
     * Meta information extracted from the WSDL
     * - hidden: hidden
     * @return string '11x8'
     */
    const VALUE_11_X_8 = '11x8';
    /**
     * Constant for value '10x8'
     * Meta information extracted from the WSDL
     * - hidden: hidden
     * @return string '10x8'
     */
    const VALUE_10_X_8 = '10x8';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_A_4
     * @uses self::VALUE_A_6
     * @uses self::VALUE_11_X_15
     * @uses self::VALUE_10_X_16
     * @uses self::VALUE_10_X_15
     * @uses self::VALUE_8_X_12
     * @uses self::VALUE_8_X_11
     * @uses self::VALUE_11_X_8
     * @uses self::VALUE_10_X_8
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_A_4,
            self::VALUE_A_6,
            self::VALUE_11_X_15,
            self::VALUE_10_X_16,
            self::VALUE_10_X_15,
            self::VALUE_8_X_12,
            self::VALUE_8_X_11,
            self::VALUE_11_X_8,
            self::VALUE_10_X_8,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
