<?php

namespace Cocorico\EdnBundle\Wsdl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for shipmentType StructType
 * @subpackage Structs
 */
class ShipmentType extends AbstractStructBase
{
    /**
     * The service
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $service;
    /**
     * The service_name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $service_name;
    /**
     * The carrier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $carrier;
    /**
     * The carrier_name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $carrier_name;
    /**
     * The carrier_logo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $carrier_logo;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - documentation: Reserved for future use
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $price;
    /**
     * The reference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $reference;
    /**
     * The receiver_company
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $receiver_company;
    /**
     * The receiver_name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $receiver_name;
    /**
     * The receiver_email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $receiver_email;
    /**
     * The receiver_country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $receiver_country;
    /**
     * The receiver_city
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $receiver_city;
    /**
     * The receiver_postcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $receiver_postcode;
    /**
     * The weight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $weight;
    /**
     * The trackingnumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $trackingnumber;
    /**
     * The master
     * Meta information extracted from the WSDL
     * - documentation: Master tracking number, can be different from the tracking number in case of multiple packages
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $master;
    /**
     * The tracking_events
     * Meta information extracted from the WSDL
     * - arrayType: tns:trackingEventType[]
     * - base: SOAP-ENC:Array
     * - maxOccurs: 1
     * - minOccurs: 1
     * - ref: SOAP-ENC:arrayType
     * @var \Cocorico\EdnBundle\Wsdl\StructType\TrackingEventType[]
     */
    public $tracking_events;
    /**
     * The pdf
     * Meta information extracted from the WSDL
     * - documentation: Url of the PDF label
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $pdf;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $status;
    /**
     * The created_at
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $created_at;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $id;
    /**
     * The shipment_order_id
     * Meta information extracted from the WSDL
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $shipment_order_id;
    /**
     * The sender_company
     * Meta information extracted from the WSDL
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sender_company;
    /**
     * The sender_name
     * Meta information extracted from the WSDL
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sender_name;
    /**
     * The sender_email
     * Meta information extracted from the WSDL
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sender_email;
    /**
     * The sender_country
     * Meta information extracted from the WSDL
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sender_country;
    /**
     * The sender_city
     * Meta information extracted from the WSDL
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sender_city;
    /**
     * The sender_postcode
     * Meta information extracted from the WSDL
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sender_postcode;
    /**
     * The insurance
     * Meta information extracted from the WSDL
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $insurance;
    /**
     * The edn_insurance
     * Meta information extracted from the WSDL
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $edn_insurance;
    /**
     * The zpl
     * Meta information extracted from the WSDL
     * - documentation: Url of the ZPL label
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $zpl;
    /**
     * The dpl
     * Meta information extracted from the WSDL
     * - documentation: Url of the DPL label
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dpl;
    /**
     * The epl2
     * Meta information extracted from the WSDL
     * - documentation: Url of the EPL2 label
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $epl2;
    /**
     * The cn23
     * Meta information extracted from the WSDL
     * - documentation: Url of the CN23 form if applicable
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cn23;
    /**
     * The is_shipped
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $is_shipped;
    /**
     * The shipped_at
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $shipped_at;
    /**
     * The is_available
     * Meta information extracted from the WSDL
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $is_available;
    /**
     * The is_returned
     * Meta information extracted from the WSDL
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $is_returned;
    /**
     * The is_delivered
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $is_delivered;
    /**
     * The delivered_at
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $delivered_at;
    /**
     * Constructor method for shipmentType
     * @uses ShipmentType::setService()
     * @uses ShipmentType::setService_name()
     * @uses ShipmentType::setCarrier()
     * @uses ShipmentType::setCarrier_name()
     * @uses ShipmentType::setCarrier_logo()
     * @uses ShipmentType::setPrice()
     * @uses ShipmentType::setReference()
     * @uses ShipmentType::setReceiver_company()
     * @uses ShipmentType::setReceiver_name()
     * @uses ShipmentType::setReceiver_email()
     * @uses ShipmentType::setReceiver_country()
     * @uses ShipmentType::setReceiver_city()
     * @uses ShipmentType::setReceiver_postcode()
     * @uses ShipmentType::setWeight()
     * @uses ShipmentType::setTrackingnumber()
     * @uses ShipmentType::setMaster()
     * @uses ShipmentType::setTracking_events()
     * @uses ShipmentType::setPdf()
     * @uses ShipmentType::setStatus()
     * @uses ShipmentType::setCreated_at()
     * @uses ShipmentType::setId()
     * @uses ShipmentType::setShipment_order_id()
     * @uses ShipmentType::setSender_company()
     * @uses ShipmentType::setSender_name()
     * @uses ShipmentType::setSender_email()
     * @uses ShipmentType::setSender_country()
     * @uses ShipmentType::setSender_city()
     * @uses ShipmentType::setSender_postcode()
     * @uses ShipmentType::setInsurance()
     * @uses ShipmentType::setEdn_insurance()
     * @uses ShipmentType::setZpl()
     * @uses ShipmentType::setDpl()
     * @uses ShipmentType::setEpl2()
     * @uses ShipmentType::setCn23()
     * @uses ShipmentType::setIs_shipped()
     * @uses ShipmentType::setShipped_at()
     * @uses ShipmentType::setIs_available()
     * @uses ShipmentType::setIs_returned()
     * @uses ShipmentType::setIs_delivered()
     * @uses ShipmentType::setDelivered_at()
     * @param string $service
     * @param string $service_name
     * @param string $carrier
     * @param string $carrier_name
     * @param string $carrier_logo
     * @param float $price
     * @param string $reference
     * @param string $receiver_company
     * @param string $receiver_name
     * @param string $receiver_email
     * @param string $receiver_country
     * @param string $receiver_city
     * @param string $receiver_postcode
     * @param float $weight
     * @param string $trackingnumber
     * @param string $master
     * @param \Cocorico\EdnBundle\Wsdl\StructType\TrackingEventType[] $tracking_events
     * @param string $pdf
     * @param string $status
     * @param string $created_at
     * @param int $id
     * @param int $shipment_order_id
     * @param string $sender_company
     * @param string $sender_name
     * @param string $sender_email
     * @param string $sender_country
     * @param string $sender_city
     * @param string $sender_postcode
     * @param float $insurance
     * @param float $edn_insurance
     * @param string $zpl
     * @param string $dpl
     * @param string $epl2
     * @param string $cn23
     * @param bool $is_shipped
     * @param string $shipped_at
     * @param bool $is_available
     * @param bool $is_returned
     * @param bool $is_delivered
     * @param string $delivered_at
     */
    public function __construct($service = null, $service_name = null, $carrier = null, $carrier_name = null, $carrier_logo = null, $price = null, $reference = null, $receiver_company = null, $receiver_name = null, $receiver_email = null, $receiver_country = null, $receiver_city = null, $receiver_postcode = null, $weight = null, $trackingnumber = null, $master = null, array $tracking_events = array(), $pdf = null, $status = null, $created_at = null, $id = null, $shipment_order_id = null, $sender_company = null, $sender_name = null, $sender_email = null, $sender_country = null, $sender_city = null, $sender_postcode = null, $insurance = null, $edn_insurance = null, $zpl = null, $dpl = null, $epl2 = null, $cn23 = null, $is_shipped = null, $shipped_at = null, $is_available = null, $is_returned = null, $is_delivered = null, $delivered_at = null)
    {
        $this
            ->setService($service)
            ->setService_name($service_name)
            ->setCarrier($carrier)
            ->setCarrier_name($carrier_name)
            ->setCarrier_logo($carrier_logo)
            ->setPrice($price)
            ->setReference($reference)
            ->setReceiver_company($receiver_company)
            ->setReceiver_name($receiver_name)
            ->setReceiver_email($receiver_email)
            ->setReceiver_country($receiver_country)
            ->setReceiver_city($receiver_city)
            ->setReceiver_postcode($receiver_postcode)
            ->setWeight($weight)
            ->setTrackingnumber($trackingnumber)
            ->setMaster($master)
            ->setTracking_events($tracking_events)
            ->setPdf($pdf)
            ->setStatus($status)
            ->setCreated_at($created_at)
            ->setId($id)
            ->setShipment_order_id($shipment_order_id)
            ->setSender_company($sender_company)
            ->setSender_name($sender_name)
            ->setSender_email($sender_email)
            ->setSender_country($sender_country)
            ->setSender_city($sender_city)
            ->setSender_postcode($sender_postcode)
            ->setInsurance($insurance)
            ->setEdn_insurance($edn_insurance)
            ->setZpl($zpl)
            ->setDpl($dpl)
            ->setEpl2($epl2)
            ->setCn23($cn23)
            ->setIs_shipped($is_shipped)
            ->setShipped_at($shipped_at)
            ->setIs_available($is_available)
            ->setIs_returned($is_returned)
            ->setIs_delivered($is_delivered)
            ->setDelivered_at($delivered_at);
    }
    /**
     * Get service value
     * @return string
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @uses \Cocorico\EdnBundle\Wsdl\EnumType\EnumServiceType::valueIsValid()
     * @uses \Cocorico\EdnBundle\Wsdl\EnumType\EnumServiceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $service
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setService($service = null)
    {
        // validation for constraint: enumeration
        if (!\Cocorico\EdnBundle\Wsdl\EnumType\EnumServiceType::valueIsValid($service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Cocorico\EdnBundle\Wsdl\EnumType\EnumServiceType', is_array($service) ? implode(', ', $service) : var_export($service, true), implode(', ', \Cocorico\EdnBundle\Wsdl\EnumType\EnumServiceType::getValidValues())), __LINE__);
        }
        $this->service = $service;
        return $this;
    }
    /**
     * Get service_name value
     * @return string
     */
    public function getService_name()
    {
        return $this->service_name;
    }
    /**
     * Set service_name value
     * @param string $service_name
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setService_name($service_name = null)
    {
        // validation for constraint: string
        if (!is_null($service_name) && !is_string($service_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($service_name, true), gettype($service_name)), __LINE__);
        }
        $this->service_name = $service_name;
        return $this;
    }
    /**
     * Get carrier value
     * @return string
     */
    public function getCarrier()
    {
        return $this->carrier;
    }
    /**
     * Set carrier value
     * @uses \Cocorico\EdnBundle\Wsdl\EnumType\EnumCarrierType::valueIsValid()
     * @uses \Cocorico\EdnBundle\Wsdl\EnumType\EnumCarrierType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $carrier
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setCarrier($carrier = null)
    {
        // validation for constraint: enumeration
        if (!\Cocorico\EdnBundle\Wsdl\EnumType\EnumCarrierType::valueIsValid($carrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Cocorico\EdnBundle\Wsdl\EnumType\EnumCarrierType', is_array($carrier) ? implode(', ', $carrier) : var_export($carrier, true), implode(', ', \Cocorico\EdnBundle\Wsdl\EnumType\EnumCarrierType::getValidValues())), __LINE__);
        }
        $this->carrier = $carrier;
        return $this;
    }
    /**
     * Get carrier_name value
     * @return string
     */
    public function getCarrier_name()
    {
        return $this->carrier_name;
    }
    /**
     * Set carrier_name value
     * @param string $carrier_name
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setCarrier_name($carrier_name = null)
    {
        // validation for constraint: string
        if (!is_null($carrier_name) && !is_string($carrier_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrier_name, true), gettype($carrier_name)), __LINE__);
        }
        $this->carrier_name = $carrier_name;
        return $this;
    }
    /**
     * Get carrier_logo value
     * @return string
     */
    public function getCarrier_logo()
    {
        return $this->carrier_logo;
    }
    /**
     * Set carrier_logo value
     * @param string $carrier_logo
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setCarrier_logo($carrier_logo = null)
    {
        // validation for constraint: string
        if (!is_null($carrier_logo) && !is_string($carrier_logo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrier_logo, true), gettype($carrier_logo)), __LINE__);
        }
        $this->carrier_logo = $carrier_logo;
        return $this;
    }
    /**
     * Get price value
     * @return float
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get reference value
     * @return string
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get receiver_company value
     * @return string
     */
    public function getReceiver_company()
    {
        return $this->receiver_company;
    }
    /**
     * Set receiver_company value
     * @param string $receiver_company
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setReceiver_company($receiver_company = null)
    {
        // validation for constraint: string
        if (!is_null($receiver_company) && !is_string($receiver_company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiver_company, true), gettype($receiver_company)), __LINE__);
        }
        $this->receiver_company = $receiver_company;
        return $this;
    }
    /**
     * Get receiver_name value
     * @return string
     */
    public function getReceiver_name()
    {
        return $this->receiver_name;
    }
    /**
     * Set receiver_name value
     * @param string $receiver_name
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setReceiver_name($receiver_name = null)
    {
        // validation for constraint: string
        if (!is_null($receiver_name) && !is_string($receiver_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiver_name, true), gettype($receiver_name)), __LINE__);
        }
        $this->receiver_name = $receiver_name;
        return $this;
    }
    /**
     * Get receiver_email value
     * @return string
     */
    public function getReceiver_email()
    {
        return $this->receiver_email;
    }
    /**
     * Set receiver_email value
     * @param string $receiver_email
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setReceiver_email($receiver_email = null)
    {
        // validation for constraint: string
        if (!is_null($receiver_email) && !is_string($receiver_email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiver_email, true), gettype($receiver_email)), __LINE__);
        }
        $this->receiver_email = $receiver_email;
        return $this;
    }
    /**
     * Get receiver_country value
     * @return string
     */
    public function getReceiver_country()
    {
        return $this->receiver_country;
    }
    /**
     * Set receiver_country value
     * @param string $receiver_country
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setReceiver_country($receiver_country = null)
    {
        // validation for constraint: string
        if (!is_null($receiver_country) && !is_string($receiver_country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiver_country, true), gettype($receiver_country)), __LINE__);
        }
        $this->receiver_country = $receiver_country;
        return $this;
    }
    /**
     * Get receiver_city value
     * @return string
     */
    public function getReceiver_city()
    {
        return $this->receiver_city;
    }
    /**
     * Set receiver_city value
     * @param string $receiver_city
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setReceiver_city($receiver_city = null)
    {
        // validation for constraint: string
        if (!is_null($receiver_city) && !is_string($receiver_city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiver_city, true), gettype($receiver_city)), __LINE__);
        }
        $this->receiver_city = $receiver_city;
        return $this;
    }
    /**
     * Get receiver_postcode value
     * @return string
     */
    public function getReceiver_postcode()
    {
        return $this->receiver_postcode;
    }
    /**
     * Set receiver_postcode value
     * @param string $receiver_postcode
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setReceiver_postcode($receiver_postcode = null)
    {
        // validation for constraint: string
        if (!is_null($receiver_postcode) && !is_string($receiver_postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiver_postcode, true), gettype($receiver_postcode)), __LINE__);
        }
        $this->receiver_postcode = $receiver_postcode;
        return $this;
    }
    /**
     * Get weight value
     * @return float
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param float $weight
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get trackingnumber value
     * @return string
     */
    public function getTrackingnumber()
    {
        return $this->trackingnumber;
    }
    /**
     * Set trackingnumber value
     * @param string $trackingnumber
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setTrackingnumber($trackingnumber = null)
    {
        // validation for constraint: string
        if (!is_null($trackingnumber) && !is_string($trackingnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingnumber, true), gettype($trackingnumber)), __LINE__);
        }
        $this->trackingnumber = $trackingnumber;
        return $this;
    }
    /**
     * Get master value
     * @return string
     */
    public function getMaster()
    {
        return $this->master;
    }
    /**
     * Set master value
     * @param string $master
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setMaster($master = null)
    {
        // validation for constraint: string
        if (!is_null($master) && !is_string($master)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($master, true), gettype($master)), __LINE__);
        }
        $this->master = $master;
        return $this;
    }
    /**
     * Get tracking_events value
     * @return \Cocorico\EdnBundle\Wsdl\StructType\TrackingEventType[]
     */
    public function getTracking_events()
    {
        return $this->tracking_events;
    }
    /**
     * This method is responsible for validating the values passed to the setTracking_events method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTracking_events method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTracking_eventsForArrayConstraintsFromSetTracking_events(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypeTracking_eventsItem) {
            // validation for constraint: itemType
            if (!$shipmentTypeTracking_eventsItem instanceof \Cocorico\EdnBundle\Wsdl\StructType\TrackingEventType) {
                $invalidValues[] = is_object($shipmentTypeTracking_eventsItem) ? get_class($shipmentTypeTracking_eventsItem) : sprintf('%s(%s)', gettype($shipmentTypeTracking_eventsItem), var_export($shipmentTypeTracking_eventsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The tracking_events property can only contain items of type \Cocorico\EdnBundle\Wsdl\StructType\TrackingEventType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set tracking_events value
     * @throws \InvalidArgumentException
     * @param \Cocorico\EdnBundle\Wsdl\StructType\TrackingEventType[] $tracking_events
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setTracking_events(array $tracking_events = array())
    {
        // validation for constraint: array
        if ('' !== ($tracking_eventsArrayErrorMessage = self::validateTracking_eventsForArrayConstraintsFromSetTracking_events($tracking_events))) {
            throw new \InvalidArgumentException($tracking_eventsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($tracking_events) && count($tracking_events) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 1', count($tracking_events)), __LINE__);
        }
        $this->tracking_events = $tracking_events;
        return $this;
    }
    /**
     * Add item to tracking_events value
     * @throws \InvalidArgumentException
     * @param \Cocorico\EdnBundle\Wsdl\StructType\TrackingEventType $item
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function addToTracking_events(\Cocorico\EdnBundle\Wsdl\StructType\TrackingEventType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Cocorico\EdnBundle\Wsdl\StructType\TrackingEventType) {
            throw new \InvalidArgumentException(sprintf('The tracking_events property can only contain items of type \Cocorico\EdnBundle\Wsdl\StructType\TrackingEventType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($this->tracking_events) && count($this->tracking_events) >= 1) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 1', count($this->tracking_events)), __LINE__);
        }
        $this->tracking_events[] = $item;
        return $this;
    }
    /**
     * Get pdf value
     * @return string
     */
    public function getPdf()
    {
        return $this->pdf;
    }
    /**
     * Set pdf value
     * @param string $pdf
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setPdf($pdf = null)
    {
        // validation for constraint: string
        if (!is_null($pdf) && !is_string($pdf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pdf, true), gettype($pdf)), __LINE__);
        }
        $this->pdf = $pdf;
        return $this;
    }
    /**
     * Get status value
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get created_at value
     * @return string
     */
    public function getCreated_at()
    {
        return $this->created_at;
    }
    /**
     * Set created_at value
     * @param string $created_at
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setCreated_at($created_at = null)
    {
        // validation for constraint: string
        if (!is_null($created_at) && !is_string($created_at)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($created_at, true), gettype($created_at)), __LINE__);
        }
        $this->created_at = $created_at;
        return $this;
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get shipment_order_id value
     * @return int|null
     */
    public function getShipment_order_id()
    {
        return $this->shipment_order_id;
    }
    /**
     * Set shipment_order_id value
     * @param int $shipment_order_id
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setShipment_order_id($shipment_order_id = null)
    {
        // validation for constraint: int
        if (!is_null($shipment_order_id) && !(is_int($shipment_order_id) || ctype_digit($shipment_order_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shipment_order_id, true), gettype($shipment_order_id)), __LINE__);
        }
        $this->shipment_order_id = $shipment_order_id;
        return $this;
    }
    /**
     * Get sender_company value
     * @return string|null
     */
    public function getSender_company()
    {
        return $this->sender_company;
    }
    /**
     * Set sender_company value
     * @param string $sender_company
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setSender_company($sender_company = null)
    {
        // validation for constraint: string
        if (!is_null($sender_company) && !is_string($sender_company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sender_company, true), gettype($sender_company)), __LINE__);
        }
        $this->sender_company = $sender_company;
        return $this;
    }
    /**
     * Get sender_name value
     * @return string|null
     */
    public function getSender_name()
    {
        return $this->sender_name;
    }
    /**
     * Set sender_name value
     * @param string $sender_name
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setSender_name($sender_name = null)
    {
        // validation for constraint: string
        if (!is_null($sender_name) && !is_string($sender_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sender_name, true), gettype($sender_name)), __LINE__);
        }
        $this->sender_name = $sender_name;
        return $this;
    }
    /**
     * Get sender_email value
     * @return string|null
     */
    public function getSender_email()
    {
        return $this->sender_email;
    }
    /**
     * Set sender_email value
     * @param string $sender_email
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setSender_email($sender_email = null)
    {
        // validation for constraint: string
        if (!is_null($sender_email) && !is_string($sender_email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sender_email, true), gettype($sender_email)), __LINE__);
        }
        $this->sender_email = $sender_email;
        return $this;
    }
    /**
     * Get sender_country value
     * @return string|null
     */
    public function getSender_country()
    {
        return $this->sender_country;
    }
    /**
     * Set sender_country value
     * @param string $sender_country
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setSender_country($sender_country = null)
    {
        // validation for constraint: string
        if (!is_null($sender_country) && !is_string($sender_country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sender_country, true), gettype($sender_country)), __LINE__);
        }
        $this->sender_country = $sender_country;
        return $this;
    }
    /**
     * Get sender_city value
     * @return string|null
     */
    public function getSender_city()
    {
        return $this->sender_city;
    }
    /**
     * Set sender_city value
     * @param string $sender_city
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setSender_city($sender_city = null)
    {
        // validation for constraint: string
        if (!is_null($sender_city) && !is_string($sender_city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sender_city, true), gettype($sender_city)), __LINE__);
        }
        $this->sender_city = $sender_city;
        return $this;
    }
    /**
     * Get sender_postcode value
     * @return string|null
     */
    public function getSender_postcode()
    {
        return $this->sender_postcode;
    }
    /**
     * Set sender_postcode value
     * @param string $sender_postcode
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setSender_postcode($sender_postcode = null)
    {
        // validation for constraint: string
        if (!is_null($sender_postcode) && !is_string($sender_postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sender_postcode, true), gettype($sender_postcode)), __LINE__);
        }
        $this->sender_postcode = $sender_postcode;
        return $this;
    }
    /**
     * Get insurance value
     * @return float|null
     */
    public function getInsurance()
    {
        return $this->insurance;
    }
    /**
     * Set insurance value
     * @param float $insurance
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setInsurance($insurance = null)
    {
        // validation for constraint: float
        if (!is_null($insurance) && !(is_float($insurance) || is_numeric($insurance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insurance, true), gettype($insurance)), __LINE__);
        }
        $this->insurance = $insurance;
        return $this;
    }
    /**
     * Get edn_insurance value
     * @return float|null
     */
    public function getEdn_insurance()
    {
        return $this->edn_insurance;
    }
    /**
     * Set edn_insurance value
     * @param float $edn_insurance
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setEdn_insurance($edn_insurance = null)
    {
        // validation for constraint: float
        if (!is_null($edn_insurance) && !(is_float($edn_insurance) || is_numeric($edn_insurance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($edn_insurance, true), gettype($edn_insurance)), __LINE__);
        }
        $this->edn_insurance = $edn_insurance;
        return $this;
    }
    /**
     * Get zpl value
     * @return string|null
     */
    public function getZpl()
    {
        return $this->zpl;
    }
    /**
     * Set zpl value
     * @param string $zpl
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setZpl($zpl = null)
    {
        // validation for constraint: string
        if (!is_null($zpl) && !is_string($zpl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zpl, true), gettype($zpl)), __LINE__);
        }
        $this->zpl = $zpl;
        return $this;
    }
    /**
     * Get dpl value
     * @return string|null
     */
    public function getDpl()
    {
        return $this->dpl;
    }
    /**
     * Set dpl value
     * @param string $dpl
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setDpl($dpl = null)
    {
        // validation for constraint: string
        if (!is_null($dpl) && !is_string($dpl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dpl, true), gettype($dpl)), __LINE__);
        }
        $this->dpl = $dpl;
        return $this;
    }
    /**
     * Get epl2 value
     * @return string|null
     */
    public function getEpl2()
    {
        return $this->epl2;
    }
    /**
     * Set epl2 value
     * @param string $epl2
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setEpl2($epl2 = null)
    {
        // validation for constraint: string
        if (!is_null($epl2) && !is_string($epl2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($epl2, true), gettype($epl2)), __LINE__);
        }
        $this->epl2 = $epl2;
        return $this;
    }
    /**
     * Get cn23 value
     * @return string|null
     */
    public function getCn23()
    {
        return $this->cn23;
    }
    /**
     * Set cn23 value
     * @param string $cn23
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setCn23($cn23 = null)
    {
        // validation for constraint: string
        if (!is_null($cn23) && !is_string($cn23)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cn23, true), gettype($cn23)), __LINE__);
        }
        $this->cn23 = $cn23;
        return $this;
    }
    /**
     * Get is_shipped value
     * @return bool|null
     */
    public function getIs_shipped()
    {
        return $this->is_shipped;
    }
    /**
     * Set is_shipped value
     * @param bool $is_shipped
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setIs_shipped($is_shipped = null)
    {
        // validation for constraint: boolean
        if (!is_null($is_shipped) && !is_bool($is_shipped)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($is_shipped, true), gettype($is_shipped)), __LINE__);
        }
        $this->is_shipped = $is_shipped;
        return $this;
    }
    /**
     * Get shipped_at value
     * @return string|null
     */
    public function getShipped_at()
    {
        return $this->shipped_at;
    }
    /**
     * Set shipped_at value
     * @param string $shipped_at
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setShipped_at($shipped_at = null)
    {
        // validation for constraint: string
        if (!is_null($shipped_at) && !is_string($shipped_at)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipped_at, true), gettype($shipped_at)), __LINE__);
        }
        $this->shipped_at = $shipped_at;
        return $this;
    }
    /**
     * Get is_available value
     * @return bool|null
     */
    public function getIs_available()
    {
        return $this->is_available;
    }
    /**
     * Set is_available value
     * @param bool $is_available
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setIs_available($is_available = null)
    {
        // validation for constraint: boolean
        if (!is_null($is_available) && !is_bool($is_available)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($is_available, true), gettype($is_available)), __LINE__);
        }
        $this->is_available = $is_available;
        return $this;
    }
    /**
     * Get is_returned value
     * @return bool|null
     */
    public function getIs_returned()
    {
        return $this->is_returned;
    }
    /**
     * Set is_returned value
     * @param bool $is_returned
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setIs_returned($is_returned = null)
    {
        // validation for constraint: boolean
        if (!is_null($is_returned) && !is_bool($is_returned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($is_returned, true), gettype($is_returned)), __LINE__);
        }
        $this->is_returned = $is_returned;
        return $this;
    }
    /**
     * Get is_delivered value
     * @return bool|null
     */
    public function getIs_delivered()
    {
        return $this->is_delivered;
    }
    /**
     * Set is_delivered value
     * @param bool $is_delivered
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setIs_delivered($is_delivered = null)
    {
        // validation for constraint: boolean
        if (!is_null($is_delivered) && !is_bool($is_delivered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($is_delivered, true), gettype($is_delivered)), __LINE__);
        }
        $this->is_delivered = $is_delivered;
        return $this;
    }
    /**
     * Get delivered_at value
     * @return string|null
     */
    public function getDelivered_at()
    {
        return $this->delivered_at;
    }
    /**
     * Set delivered_at value
     * @param string $delivered_at
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public function setDelivered_at($delivered_at = null)
    {
        // validation for constraint: string
        if (!is_null($delivered_at) && !is_string($delivered_at)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($delivered_at, true), gettype($delivered_at)), __LINE__);
        }
        $this->delivered_at = $delivered_at;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
