<?php

namespace Cocorico\EdnBundle\Wsdl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for quotePackageType StructType
 * @subpackage Structs
 */
class QuotePackageType extends AbstractStructBase
{
    /**
     * The weight
     * Meta information extracted from the WSDL
     * - documentation: Weight of the package in kilograms
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $weight;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - documentation: How many packages of this type are there, defaults to 1 if left empty.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $quantity;
    /**
     * The length
     * Meta information extracted from the WSDL
     * - documentation: Length of the package in centimeters
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $length;
    /**
     * The height
     * Meta information extracted from the WSDL
     * - documentation: Height of the package in centimeters
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $height;
    /**
     * The width
     * Meta information extracted from the WSDL
     * - documentation: Width of the package in centimeters
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $width;
    /**
     * The insurance
     * Meta information extracted from the WSDL
     * - documentation: Shipment value if you want additional insurance
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $insurance;
    /**
     * Constructor method for quotePackageType
     * @uses QuotePackageType::setWeight()
     * @uses QuotePackageType::setQuantity()
     * @uses QuotePackageType::setLength()
     * @uses QuotePackageType::setHeight()
     * @uses QuotePackageType::setWidth()
     * @uses QuotePackageType::setInsurance()
     * @param float $weight
     * @param float $quantity
     * @param float $length
     * @param float $height
     * @param float $width
     * @param float $insurance
     */
    public function __construct($weight = null, $quantity = null, $length = null, $height = null, $width = null, $insurance = null)
    {
        $this
            ->setWeight($weight)
            ->setQuantity($quantity)
            ->setLength($length)
            ->setHeight($height)
            ->setWidth($width)
            ->setInsurance($insurance);
    }
    /**
     * Get weight value
     * @return float
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param float $weight
     * @return \Cocorico\EdnBundle\Wsdl\StructType\QuotePackageType
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param float $quantity
     * @return \Cocorico\EdnBundle\Wsdl\StructType\QuotePackageType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get length value
     * @return float|null
     */
    public function getLength()
    {
        return $this->length;
    }
    /**
     * Set length value
     * @param float $length
     * @return \Cocorico\EdnBundle\Wsdl\StructType\QuotePackageType
     */
    public function setLength($length = null)
    {
        // validation for constraint: float
        if (!is_null($length) && !(is_float($length) || is_numeric($length))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($length, true), gettype($length)), __LINE__);
        }
        $this->length = $length;
        return $this;
    }
    /**
     * Get height value
     * @return float|null
     */
    public function getHeight()
    {
        return $this->height;
    }
    /**
     * Set height value
     * @param float $height
     * @return \Cocorico\EdnBundle\Wsdl\StructType\QuotePackageType
     */
    public function setHeight($height = null)
    {
        // validation for constraint: float
        if (!is_null($height) && !(is_float($height) || is_numeric($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        $this->height = $height;
        return $this;
    }
    /**
     * Get width value
     * @return float|null
     */
    public function getWidth()
    {
        return $this->width;
    }
    /**
     * Set width value
     * @param float $width
     * @return \Cocorico\EdnBundle\Wsdl\StructType\QuotePackageType
     */
    public function setWidth($width = null)
    {
        // validation for constraint: float
        if (!is_null($width) && !(is_float($width) || is_numeric($width))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        $this->width = $width;
        return $this;
    }
    /**
     * Get insurance value
     * @return float|null
     */
    public function getInsurance()
    {
        return $this->insurance;
    }
    /**
     * Set insurance value
     * @param float $insurance
     * @return \Cocorico\EdnBundle\Wsdl\StructType\QuotePackageType
     */
    public function setInsurance($insurance = null)
    {
        // validation for constraint: float
        if (!is_null($insurance) && !(is_float($insurance) || is_numeric($insurance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insurance, true), gettype($insurance)), __LINE__);
        }
        $this->insurance = $insurance;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Cocorico\EdnBundle\Wsdl\StructType\QuotePackageType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
