<?php

namespace Cocorico\EdnBundle\Wsdl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getBuyingPriceRequest StructType
 * @subpackage Structs
 */
class GetBuyingPriceRequest extends AbstractStructBase
{
    /**
     * The shipment_order_id
     * Meta information extracted from the WSDL
     * - documentation: Internal use
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $shipment_order_id;
    /**
     * The date
     * Meta information extracted from the WSDL
     * - documentation: Internal use
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $date;
    /**
     * The ignore_max_weight
     * Meta information extracted from the WSDL
     * - documentation: Internal use
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ignore_max_weight;
    /**
     * The from
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Cocorico\EdnBundle\Wsdl\StructType\QuoteAddressType
     */
    public $from;
    /**
     * The to
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Cocorico\EdnBundle\Wsdl\StructType\QuoteAddressType
     */
    public $to;
    /**
     * The packages
     * Meta information extracted from the WSDL
     * - documentation: When requesting a quote for multiple packages, put them here and leave the root-level weight and dimensions empty
     * - arrayType: tns:quotePackageType[]
     * - base: SOAP-ENC:Array
     * - maxOccurs: 1
     * - minOccurs: 1
     * - ref: SOAP-ENC:arrayType
     * @var \Cocorico\EdnBundle\Wsdl\StructType\QuotePackageType[]
     */
    public $packages;
    /**
     * Constructor method for getBuyingPriceRequest
     * @uses GetBuyingPriceRequest::setShipment_order_id()
     * @uses GetBuyingPriceRequest::setDate()
     * @uses GetBuyingPriceRequest::setIgnore_max_weight()
     * @uses GetBuyingPriceRequest::setFrom()
     * @uses GetBuyingPriceRequest::setTo()
     * @uses GetBuyingPriceRequest::setPackages()
     * @param string $shipment_order_id
     * @param string $date
     * @param bool $ignore_max_weight
     * @param \Cocorico\EdnBundle\Wsdl\StructType\QuoteAddressType $from
     * @param \Cocorico\EdnBundle\Wsdl\StructType\QuoteAddressType $to
     * @param \Cocorico\EdnBundle\Wsdl\StructType\QuotePackageType[] $packages
     */
    public function __construct($shipment_order_id = null, $date = null, $ignore_max_weight = null, \Cocorico\EdnBundle\Wsdl\StructType\QuoteAddressType $from = null, \Cocorico\EdnBundle\Wsdl\StructType\QuoteAddressType $to = null, array $packages = array())
    {
        $this
            ->setShipment_order_id($shipment_order_id)
            ->setDate($date)
            ->setIgnore_max_weight($ignore_max_weight)
            ->setFrom($from)
            ->setTo($to)
            ->setPackages($packages);
    }
    /**
     * Get shipment_order_id value
     * @return string
     */
    public function getShipment_order_id()
    {
        return $this->shipment_order_id;
    }
    /**
     * Set shipment_order_id value
     * @param string $shipment_order_id
     * @return \Cocorico\EdnBundle\Wsdl\StructType\GetBuyingPriceRequest
     */
    public function setShipment_order_id($shipment_order_id = null)
    {
        // validation for constraint: string
        if (!is_null($shipment_order_id) && !is_string($shipment_order_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipment_order_id, true), gettype($shipment_order_id)), __LINE__);
        }
        $this->shipment_order_id = $shipment_order_id;
        return $this;
    }
    /**
     * Get date value
     * @return string
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \Cocorico\EdnBundle\Wsdl\StructType\GetBuyingPriceRequest
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get ignore_max_weight value
     * @return bool
     */
    public function getIgnore_max_weight()
    {
        return $this->ignore_max_weight;
    }
    /**
     * Set ignore_max_weight value
     * @param bool $ignore_max_weight
     * @return \Cocorico\EdnBundle\Wsdl\StructType\GetBuyingPriceRequest
     */
    public function setIgnore_max_weight($ignore_max_weight = null)
    {
        // validation for constraint: boolean
        if (!is_null($ignore_max_weight) && !is_bool($ignore_max_weight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ignore_max_weight, true), gettype($ignore_max_weight)), __LINE__);
        }
        $this->ignore_max_weight = $ignore_max_weight;
        return $this;
    }
    /**
     * Get from value
     * @return \Cocorico\EdnBundle\Wsdl\StructType\QuoteAddressType
     */
    public function getFrom()
    {
        return $this->from;
    }
    /**
     * Set from value
     * @param \Cocorico\EdnBundle\Wsdl\StructType\QuoteAddressType $from
     * @return \Cocorico\EdnBundle\Wsdl\StructType\GetBuyingPriceRequest
     */
    public function setFrom(\Cocorico\EdnBundle\Wsdl\StructType\QuoteAddressType $from = null)
    {
        $this->from = $from;
        return $this;
    }
    /**
     * Get to value
     * @return \Cocorico\EdnBundle\Wsdl\StructType\QuoteAddressType
     */
    public function getTo()
    {
        return $this->to;
    }
    /**
     * Set to value
     * @param \Cocorico\EdnBundle\Wsdl\StructType\QuoteAddressType $to
     * @return \Cocorico\EdnBundle\Wsdl\StructType\GetBuyingPriceRequest
     */
    public function setTo(\Cocorico\EdnBundle\Wsdl\StructType\QuoteAddressType $to = null)
    {
        $this->to = $to;
        return $this;
    }
    /**
     * Get packages value
     * @return \Cocorico\EdnBundle\Wsdl\StructType\QuotePackageType[]
     */
    public function getPackages()
    {
        return $this->packages;
    }
    /**
     * This method is responsible for validating the values passed to the setPackages method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackages method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackagesForArrayConstraintsFromSetPackages(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getBuyingPriceRequestPackagesItem) {
            // validation for constraint: itemType
            if (!$getBuyingPriceRequestPackagesItem instanceof \Cocorico\EdnBundle\Wsdl\StructType\QuotePackageType) {
                $invalidValues[] = is_object($getBuyingPriceRequestPackagesItem) ? get_class($getBuyingPriceRequestPackagesItem) : sprintf('%s(%s)', gettype($getBuyingPriceRequestPackagesItem), var_export($getBuyingPriceRequestPackagesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The packages property can only contain items of type \Cocorico\EdnBundle\Wsdl\StructType\QuotePackageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set packages value
     * @throws \InvalidArgumentException
     * @param \Cocorico\EdnBundle\Wsdl\StructType\QuotePackageType[] $packages
     * @return \Cocorico\EdnBundle\Wsdl\StructType\GetBuyingPriceRequest
     */
    public function setPackages(array $packages = array())
    {
        // validation for constraint: array
        if ('' !== ($packagesArrayErrorMessage = self::validatePackagesForArrayConstraintsFromSetPackages($packages))) {
            throw new \InvalidArgumentException($packagesArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($packages) && count($packages) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 1', count($packages)), __LINE__);
        }
        $this->packages = $packages;
        return $this;
    }
    /**
     * Add item to packages value
     * @throws \InvalidArgumentException
     * @param \Cocorico\EdnBundle\Wsdl\StructType\QuotePackageType $item
     * @return \Cocorico\EdnBundle\Wsdl\StructType\GetBuyingPriceRequest
     */
    public function addToPackages(\Cocorico\EdnBundle\Wsdl\StructType\QuotePackageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Cocorico\EdnBundle\Wsdl\StructType\QuotePackageType) {
            throw new \InvalidArgumentException(sprintf('The packages property can only contain items of type \Cocorico\EdnBundle\Wsdl\StructType\QuotePackageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($this->packages) && count($this->packages) >= 1) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 1', count($this->packages)), __LINE__);
        }
        $this->packages[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Cocorico\EdnBundle\Wsdl\StructType\GetBuyingPriceRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
