<?php

namespace Cocorico\EdnBundle\Wsdl\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cancel ServiceType
 * @subpackage Services
 */
class Cancel extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named cancelPickup
     * Meta information extracted from the WSDL
     * - documentation: Cancel a pickup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Cocorico\EdnBundle\Wsdl\StructType\LoginType $login
     * @param \Cocorico\EdnBundle\Wsdl\StructType\CancelPickupRequest $params
     * @return array|bool
     */
    public function cancelPickup(\Cocorico\EdnBundle\Wsdl\StructType\LoginType $login, \Cocorico\EdnBundle\Wsdl\StructType\CancelPickupRequest $params)
    {
        try {
            $this->setResult($this->getSoapClient()->cancelPickup($login, $params));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
