<?php

namespace Cocorico\EdnBundle\Wsdl\EnumType;

/**
 * This class stands for enumCarrierType EnumType
 * @subpackage Enumerations
 */
class EnumCarrierType
{
    /**
     * Constant for value 'chronopost'
     * @return string 'chronopost'
     */
    const VALUE_CHRONOPOST = 'chronopost';
    /**
     * Constant for value 'chronopost18'
     * @return string 'chronopost18'
     */
    const VALUE_CHRONOPOST_18 = 'chronopost18';
    /**
     * Constant for value 'chronopostinternational'
     * @return string 'chronopostinternational'
     */
    const VALUE_CHRONOPOSTINTERNATIONAL = 'chronopostinternational';
    /**
     * Constant for value 'chronopostpro'
     * @return string 'chronopostpro'
     */
    const VALUE_CHRONOPOSTPRO = 'chronopostpro';
    /**
     * Constant for value 'chronopost_classic'
     * @return string 'chronopost_classic'
     */
    const VALUE_CHRONOPOST_CLASSIC = 'chronopost_classic';
    /**
     * Constant for value 'chronopost_retour'
     * @return string 'chronopost_retour'
     */
    const VALUE_CHRONOPOST_RETOUR = 'chronopost_retour';
    /**
     * Constant for value 'chronorelais'
     * @return string 'chronorelais'
     */
    const VALUE_CHRONORELAIS = 'chronorelais';
    /**
     * Constant for value 'ciblex'
     * @return string 'ciblex'
     */
    const VALUE_CIBLEX = 'ciblex';
    /**
     * Constant for value 'coliposte'
     * @return string 'coliposte'
     */
    const VALUE_COLIPOSTE = 'coliposte';
    /**
     * Constant for value 'colisprive'
     * @return string 'colisprive'
     */
    const VALUE_COLISPRIVE = 'colisprive';
    /**
     * Constant for value 'colisprive_signature'
     * @return string 'colisprive_signature'
     */
    const VALUE_COLISPRIVE_SIGNATURE = 'colisprive_signature';
    /**
     * Constant for value 'colissimo_access'
     * @return string 'colissimo_access'
     */
    const VALUE_COLISSIMO_ACCESS = 'colissimo_access';
    /**
     * Constant for value 'colissimo_dom'
     * @return string 'colissimo_dom'
     */
    const VALUE_COLISSIMO_DOM = 'colissimo_dom';
    /**
     * Constant for value 'colissimo_eco'
     * @return string 'colissimo_eco'
     */
    const VALUE_COLISSIMO_ECO = 'colissimo_eco';
    /**
     * Constant for value 'colissimo_expert'
     * @return string 'colissimo_expert'
     */
    const VALUE_COLISSIMO_EXPERT = 'colissimo_expert';
    /**
     * Constant for value 'colissimo_inter'
     * @return string 'colissimo_inter'
     */
    const VALUE_COLISSIMO_INTER = 'colissimo_inter';
    /**
     * Constant for value 'colissimo_profil'
     * @return string 'colissimo_profil'
     */
    const VALUE_COLISSIMO_PROFIL = 'colissimo_profil';
    /**
     * Constant for value 'colissimo_relais'
     * @return string 'colissimo_relais'
     */
    const VALUE_COLISSIMO_RELAIS = 'colissimo_relais';
    /**
     * Constant for value 'colissimo_retour'
     * @return string 'colissimo_retour'
     */
    const VALUE_COLISSIMO_RETOUR = 'colissimo_retour';
    /**
     * Constant for value 'delivengo_non_suivi'
     * @return string 'delivengo_non_suivi'
     */
    const VALUE_DELIVENGO_NON_SUIVI = 'delivengo_non_suivi';
    /**
     * Constant for value 'delivengo_suivi'
     * @return string 'delivengo_suivi'
     */
    const VALUE_DELIVENGO_SUIVI = 'delivengo_suivi';
    /**
     * Constant for value 'dhl'
     * @return string 'dhl'
     */
    const VALUE_DHL = 'dhl';
    /**
     * Constant for value 'dhl_eco'
     * @return string 'dhl_eco'
     */
    const VALUE_DHL_ECO = 'dhl_eco';
    /**
     * Constant for value 'dhl_france'
     * @return string 'dhl_france'
     */
    const VALUE_DHL_FRANCE = 'dhl_france';
    /**
     * Constant for value 'dhl_global_mail'
     * @return string 'dhl_global_mail'
     */
    const VALUE_DHL_GLOBAL_MAIL = 'dhl_global_mail';
    /**
     * Constant for value 'dhl_global_mail_registered'
     * @return string 'dhl_global_mail_registered'
     */
    const VALUE_DHL_GLOBAL_MAIL_REGISTERED = 'dhl_global_mail_registered';
    /**
     * Constant for value 'dhl_paket'
     * @return string 'dhl_paket'
     */
    const VALUE_DHL_PAKET = 'dhl_paket';
    /**
     * Constant for value 'dhl_spain'
     * @return string 'dhl_spain'
     */
    const VALUE_DHL_SPAIN = 'dhl_spain';
    /**
     * Constant for value 'dpd'
     * @return string 'dpd'
     */
    const VALUE_DPD = 'dpd';
    /**
     * Constant for value 'dpd_b2b'
     * @return string 'dpd_b2b'
     */
    const VALUE_DPD_B_2_B = 'dpd_b2b';
    /**
     * Constant for value 'dpd_relay'
     * @return string 'dpd_relay'
     */
    const VALUE_DPD_RELAY = 'dpd_relay';
    /**
     * Constant for value 'fedex'
     * @return string 'fedex'
     */
    const VALUE_FEDEX = 'fedex';
    /**
     * Constant for value 'fedexeco'
     * @return string 'fedexeco'
     */
    const VALUE_FEDEXECO = 'fedexeco';
    /**
     * Constant for value 'fedexeco_freight_mono'
     * @return string 'fedexeco_freight_mono'
     */
    const VALUE_FEDEXECO_FREIGHT_MONO = 'fedexeco_freight_mono';
    /**
     * Constant for value 'fedexeco_freight_multi'
     * @return string 'fedexeco_freight_multi'
     */
    const VALUE_FEDEXECO_FREIGHT_MULTI = 'fedexeco_freight_multi';
    /**
     * Constant for value 'fedex_france'
     * @return string 'fedex_france'
     */
    const VALUE_FEDEX_FRANCE = 'fedex_france';
    /**
     * Constant for value 'fedex_freight_mono'
     * @return string 'fedex_freight_mono'
     */
    const VALUE_FEDEX_FREIGHT_MONO = 'fedex_freight_mono';
    /**
     * Constant for value 'fedex_freight_multi'
     * @return string 'fedex_freight_multi'
     */
    const VALUE_FEDEX_FREIGHT_MULTI = 'fedex_freight_multi';
    /**
     * Constant for value 'gls'
     * @return string 'gls'
     */
    const VALUE_GLS = 'gls';
    /**
     * Constant for value 'gls_b2b'
     * @return string 'gls_b2b'
     */
    const VALUE_GLS_B_2_B = 'gls_b2b';
    /**
     * Constant for value 'imx'
     * @return string 'imx'
     */
    const VALUE_IMX = 'imx';
    /**
     * Constant for value 'kiala'
     * @return string 'kiala'
     */
    const VALUE_KIALA = 'kiala';
    /**
     * Constant for value 'lettre_max'
     * @return string 'lettre_max'
     */
    const VALUE_LETTRE_MAX = 'lettre_max';
    /**
     * Constant for value 'lettre_max_yourstore'
     * @return string 'lettre_max_yourstore'
     */
    const VALUE_LETTRE_MAX_YOURSTORE = 'lettre_max_yourstore';
    /**
     * Constant for value 'mondialrelay'
     * @return string 'mondialrelay'
     */
    const VALUE_MONDIALRELAY = 'mondialrelay';
    /**
     * Constant for value 'mondialrelay_home'
     * @return string 'mondialrelay_home'
     */
    const VALUE_MONDIALRELAY_HOME = 'mondialrelay_home';
    /**
     * Constant for value 'mondialrelay_xl'
     * @return string 'mondialrelay_xl'
     */
    const VALUE_MONDIALRELAY_XL = 'mondialrelay_xl';
    /**
     * Constant for value 'relaiscolis'
     * @return string 'relaiscolis'
     */
    const VALUE_RELAISCOLIS = 'relaiscolis';
    /**
     * Constant for value 'sda'
     * @return string 'sda'
     */
    const VALUE_SDA = 'sda';
    /**
     * Constant for value 'ups_economy_mono_relay'
     * @return string 'ups_economy_mono_relay'
     */
    const VALUE_UPS_ECONOMY_MONO_RELAY = 'ups_economy_mono_relay';
    /**
     * Constant for value 'ups_economy_multi_relay'
     * @return string 'ups_economy_multi_relay'
     */
    const VALUE_UPS_ECONOMY_MULTI_RELAY = 'ups_economy_multi_relay';
    /**
     * Constant for value 'ups_economy_relay'
     * @return string 'ups_economy_relay'
     */
    const VALUE_UPS_ECONOMY_RELAY = 'ups_economy_relay';
    /**
     * Constant for value 'ups_express'
     * @return string 'ups_express'
     */
    const VALUE_UPS_EXPRESS = 'ups_express';
    /**
     * Constant for value 'ups_express_relay'
     * @return string 'ups_express_relay'
     */
    const VALUE_UPS_EXPRESS_RELAY = 'ups_express_relay';
    /**
     * Constant for value 'ups_express_saver'
     * @return string 'ups_express_saver'
     */
    const VALUE_UPS_EXPRESS_SAVER = 'ups_express_saver';
    /**
     * Constant for value 'ups_express_saver_relay'
     * @return string 'ups_express_saver_relay'
     */
    const VALUE_UPS_EXPRESS_SAVER_RELAY = 'ups_express_saver_relay';
    /**
     * Constant for value 'ups_standard'
     * @return string 'ups_standard'
     */
    const VALUE_UPS_STANDARD = 'ups_standard';
    /**
     * Constant for value 'ups_standard_mono'
     * @return string 'ups_standard_mono'
     */
    const VALUE_UPS_STANDARD_MONO = 'ups_standard_mono';
    /**
     * Constant for value 'ups_standard_mono_relay'
     * @return string 'ups_standard_mono_relay'
     */
    const VALUE_UPS_STANDARD_MONO_RELAY = 'ups_standard_mono_relay';
    /**
     * Constant for value 'ups_standard_multi'
     * @return string 'ups_standard_multi'
     */
    const VALUE_UPS_STANDARD_MULTI = 'ups_standard_multi';
    /**
     * Constant for value 'ups_standard_multi_relay'
     * @return string 'ups_standard_multi_relay'
     */
    const VALUE_UPS_STANDARD_MULTI_RELAY = 'ups_standard_multi_relay';
    /**
     * Constant for value 'ups_standard_relay'
     * @return string 'ups_standard_relay'
     */
    const VALUE_UPS_STANDARD_RELAY = 'ups_standard_relay';
    /**
     * Constant for value 'standard'
     * @return string 'standard'
     */
    const VALUE_STANDARD = 'standard';
    /**
     * Constant for value 'express'
     * @return string 'express'
     */
    const VALUE_EXPRESS = 'express';
    /**
     * Constant for value 'relay'
     * @return string 'relay'
     */
    const VALUE_RELAY = 'relay';
    /**
     * Constant for value 'international'
     * @return string 'international'
     */
    const VALUE_INTERNATIONAL = 'international';
    /**
     * Constant for value 'internationaleco'
     * @return string 'internationaleco'
     */
    const VALUE_INTERNATIONALECO = 'internationaleco';
    /**
     * Constant for value 'expresspro'
     * @return string 'expresspro'
     */
    const VALUE_EXPRESSPRO = 'expresspro';
    /**
     * Constant for value 'best_price'
     * @return string 'best_price'
     */
    const VALUE_BEST_PRICE = 'best_price';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CHRONOPOST
     * @uses self::VALUE_CHRONOPOST_18
     * @uses self::VALUE_CHRONOPOSTINTERNATIONAL
     * @uses self::VALUE_CHRONOPOSTPRO
     * @uses self::VALUE_CHRONOPOST_CLASSIC
     * @uses self::VALUE_CHRONOPOST_RETOUR
     * @uses self::VALUE_CHRONORELAIS
     * @uses self::VALUE_CIBLEX
     * @uses self::VALUE_COLIPOSTE
     * @uses self::VALUE_COLISPRIVE
     * @uses self::VALUE_COLISPRIVE_SIGNATURE
     * @uses self::VALUE_COLISSIMO_ACCESS
     * @uses self::VALUE_COLISSIMO_DOM
     * @uses self::VALUE_COLISSIMO_ECO
     * @uses self::VALUE_COLISSIMO_EXPERT
     * @uses self::VALUE_COLISSIMO_INTER
     * @uses self::VALUE_COLISSIMO_PROFIL
     * @uses self::VALUE_COLISSIMO_RELAIS
     * @uses self::VALUE_COLISSIMO_RETOUR
     * @uses self::VALUE_DELIVENGO_NON_SUIVI
     * @uses self::VALUE_DELIVENGO_SUIVI
     * @uses self::VALUE_DHL
     * @uses self::VALUE_DHL_ECO
     * @uses self::VALUE_DHL_FRANCE
     * @uses self::VALUE_DHL_GLOBAL_MAIL
     * @uses self::VALUE_DHL_GLOBAL_MAIL_REGISTERED
     * @uses self::VALUE_DHL_PAKET
     * @uses self::VALUE_DHL_SPAIN
     * @uses self::VALUE_DPD
     * @uses self::VALUE_DPD_B_2_B
     * @uses self::VALUE_DPD_RELAY
     * @uses self::VALUE_FEDEX
     * @uses self::VALUE_FEDEXECO
     * @uses self::VALUE_FEDEXECO_FREIGHT_MONO
     * @uses self::VALUE_FEDEXECO_FREIGHT_MULTI
     * @uses self::VALUE_FEDEX_FRANCE
     * @uses self::VALUE_FEDEX_FREIGHT_MONO
     * @uses self::VALUE_FEDEX_FREIGHT_MULTI
     * @uses self::VALUE_GLS
     * @uses self::VALUE_GLS_B_2_B
     * @uses self::VALUE_IMX
     * @uses self::VALUE_KIALA
     * @uses self::VALUE_LETTRE_MAX
     * @uses self::VALUE_LETTRE_MAX_YOURSTORE
     * @uses self::VALUE_MONDIALRELAY
     * @uses self::VALUE_MONDIALRELAY_HOME
     * @uses self::VALUE_MONDIALRELAY_XL
     * @uses self::VALUE_RELAISCOLIS
     * @uses self::VALUE_SDA
     * @uses self::VALUE_UPS_ECONOMY_MONO_RELAY
     * @uses self::VALUE_UPS_ECONOMY_MULTI_RELAY
     * @uses self::VALUE_UPS_ECONOMY_RELAY
     * @uses self::VALUE_UPS_EXPRESS
     * @uses self::VALUE_UPS_EXPRESS_RELAY
     * @uses self::VALUE_UPS_EXPRESS_SAVER
     * @uses self::VALUE_UPS_EXPRESS_SAVER_RELAY
     * @uses self::VALUE_UPS_STANDARD
     * @uses self::VALUE_UPS_STANDARD_MONO
     * @uses self::VALUE_UPS_STANDARD_MONO_RELAY
     * @uses self::VALUE_UPS_STANDARD_MULTI
     * @uses self::VALUE_UPS_STANDARD_MULTI_RELAY
     * @uses self::VALUE_UPS_STANDARD_RELAY
     * @uses self::VALUE_STANDARD
     * @uses self::VALUE_EXPRESS
     * @uses self::VALUE_RELAY
     * @uses self::VALUE_INTERNATIONAL
     * @uses self::VALUE_INTERNATIONALECO
     * @uses self::VALUE_EXPRESSPRO
     * @uses self::VALUE_BEST_PRICE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CHRONOPOST,
            self::VALUE_CHRONOPOST_18,
            self::VALUE_CHRONOPOSTINTERNATIONAL,
            self::VALUE_CHRONOPOSTPRO,
            self::VALUE_CHRONOPOST_CLASSIC,
            self::VALUE_CHRONOPOST_RETOUR,
            self::VALUE_CHRONORELAIS,
            self::VALUE_CIBLEX,
            self::VALUE_COLIPOSTE,
            self::VALUE_COLISPRIVE,
            self::VALUE_COLISPRIVE_SIGNATURE,
            self::VALUE_COLISSIMO_ACCESS,
            self::VALUE_COLISSIMO_DOM,
            self::VALUE_COLISSIMO_ECO,
            self::VALUE_COLISSIMO_EXPERT,
            self::VALUE_COLISSIMO_INTER,
            self::VALUE_COLISSIMO_PROFIL,
            self::VALUE_COLISSIMO_RELAIS,
            self::VALUE_COLISSIMO_RETOUR,
            self::VALUE_DELIVENGO_NON_SUIVI,
            self::VALUE_DELIVENGO_SUIVI,
            self::VALUE_DHL,
            self::VALUE_DHL_ECO,
            self::VALUE_DHL_FRANCE,
            self::VALUE_DHL_GLOBAL_MAIL,
            self::VALUE_DHL_GLOBAL_MAIL_REGISTERED,
            self::VALUE_DHL_PAKET,
            self::VALUE_DHL_SPAIN,
            self::VALUE_DPD,
            self::VALUE_DPD_B_2_B,
            self::VALUE_DPD_RELAY,
            self::VALUE_FEDEX,
            self::VALUE_FEDEXECO,
            self::VALUE_FEDEXECO_FREIGHT_MONO,
            self::VALUE_FEDEXECO_FREIGHT_MULTI,
            self::VALUE_FEDEX_FRANCE,
            self::VALUE_FEDEX_FREIGHT_MONO,
            self::VALUE_FEDEX_FREIGHT_MULTI,
            self::VALUE_GLS,
            self::VALUE_GLS_B_2_B,
            self::VALUE_IMX,
            self::VALUE_KIALA,
            self::VALUE_LETTRE_MAX,
            self::VALUE_LETTRE_MAX_YOURSTORE,
            self::VALUE_MONDIALRELAY,
            self::VALUE_MONDIALRELAY_HOME,
            self::VALUE_MONDIALRELAY_XL,
            self::VALUE_RELAISCOLIS,
            self::VALUE_SDA,
            self::VALUE_UPS_ECONOMY_MONO_RELAY,
            self::VALUE_UPS_ECONOMY_MULTI_RELAY,
            self::VALUE_UPS_ECONOMY_RELAY,
            self::VALUE_UPS_EXPRESS,
            self::VALUE_UPS_EXPRESS_RELAY,
            self::VALUE_UPS_EXPRESS_SAVER,
            self::VALUE_UPS_EXPRESS_SAVER_RELAY,
            self::VALUE_UPS_STANDARD,
            self::VALUE_UPS_STANDARD_MONO,
            self::VALUE_UPS_STANDARD_MONO_RELAY,
            self::VALUE_UPS_STANDARD_MULTI,
            self::VALUE_UPS_STANDARD_MULTI_RELAY,
            self::VALUE_UPS_STANDARD_RELAY,
            self::VALUE_STANDARD,
            self::VALUE_EXPRESS,
            self::VALUE_RELAY,
            self::VALUE_INTERNATIONAL,
            self::VALUE_INTERNATIONALECO,
            self::VALUE_EXPRESSPRO,
            self::VALUE_BEST_PRICE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
