<?php

namespace Cocorico\EdnBundle\Wsdl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for packageType StructType
 * @subpackage Structs
 */
class PackageType extends AbstractStructBase
{
    /**
     * The weight
     * Meta information extracted from the WSDL
     * - documentation: Weight of the package in kilograms
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $weight;
    /**
     * The products
     * Meta information extracted from the WSDL
     * - documentation: Products details for customs declarations
     * - arrayType: tns:productType[]
     * - base: SOAP-ENC:Array
     * - maxOccurs: 1
     * - minOccurs: 1
     * - ref: SOAP-ENC:arrayType
     * @var \Cocorico\EdnBundle\Wsdl\StructType\ProductType[]
     */
    public $products;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - documentation: How many packages of this type are there, defaults to 1 if left empty.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $quantity;
    /**
     * The length
     * Meta information extracted from the WSDL
     * - documentation: Length of the package in centimeters
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $length;
    /**
     * The height
     * Meta information extracted from the WSDL
     * - documentation: Height of the package in centimeters
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $height;
    /**
     * The width
     * Meta information extracted from the WSDL
     * - documentation: Width of the package in centimeters
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $width;
    /**
     * The insurance
     * Meta information extracted from the WSDL
     * - documentation: Shipment value if you want additional insurance
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $insurance;
    /**
     * Constructor method for packageType
     * @uses PackageType::setWeight()
     * @uses PackageType::setProducts()
     * @uses PackageType::setQuantity()
     * @uses PackageType::setLength()
     * @uses PackageType::setHeight()
     * @uses PackageType::setWidth()
     * @uses PackageType::setInsurance()
     * @param float $weight
     * @param \Cocorico\EdnBundle\Wsdl\StructType\ProductType[] $products
     * @param float $quantity
     * @param float $length
     * @param float $height
     * @param float $width
     * @param float $insurance
     */
    public function __construct($weight = null, array $products = array(), $quantity = null, $length = null, $height = null, $width = null, $insurance = null)
    {
        $this
            ->setWeight($weight)
            ->setProducts($products)
            ->setQuantity($quantity)
            ->setLength($length)
            ->setHeight($height)
            ->setWidth($width)
            ->setInsurance($insurance);
    }
    /**
     * Get weight value
     * @return float
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param float $weight
     * @return \Cocorico\EdnBundle\Wsdl\StructType\PackageType
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get products value
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ProductType[]
     */
    public function getProducts()
    {
        return $this->products;
    }
    /**
     * This method is responsible for validating the values passed to the setProducts method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProducts method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductsForArrayConstraintsFromSetProducts(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageTypeProductsItem) {
            // validation for constraint: itemType
            if (!$packageTypeProductsItem instanceof \Cocorico\EdnBundle\Wsdl\StructType\ProductType) {
                $invalidValues[] = is_object($packageTypeProductsItem) ? get_class($packageTypeProductsItem) : sprintf('%s(%s)', gettype($packageTypeProductsItem), var_export($packageTypeProductsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The products property can only contain items of type \Cocorico\EdnBundle\Wsdl\StructType\ProductType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set products value
     * @throws \InvalidArgumentException
     * @param \Cocorico\EdnBundle\Wsdl\StructType\ProductType[] $products
     * @return \Cocorico\EdnBundle\Wsdl\StructType\PackageType
     */
    public function setProducts(array $products = array())
    {
        // validation for constraint: array
        if ('' !== ($productsArrayErrorMessage = self::validateProductsForArrayConstraintsFromSetProducts($products))) {
            throw new \InvalidArgumentException($productsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($products) && count($products) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 1', count($products)), __LINE__);
        }
        $this->products = $products;
        return $this;
    }
    /**
     * Add item to products value
     * @throws \InvalidArgumentException
     * @param \Cocorico\EdnBundle\Wsdl\StructType\ProductType $item
     * @return \Cocorico\EdnBundle\Wsdl\StructType\PackageType
     */
    public function addToProducts(\Cocorico\EdnBundle\Wsdl\StructType\ProductType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Cocorico\EdnBundle\Wsdl\StructType\ProductType) {
            throw new \InvalidArgumentException(sprintf('The products property can only contain items of type \Cocorico\EdnBundle\Wsdl\StructType\ProductType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($this->products) && count($this->products) >= 1) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 1', count($this->products)), __LINE__);
        }
        $this->products[] = $item;
        return $this;
    }
    /**
     * Get quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param float $quantity
     * @return \Cocorico\EdnBundle\Wsdl\StructType\PackageType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get length value
     * @return float|null
     */
    public function getLength()
    {
        return $this->length;
    }
    /**
     * Set length value
     * @param float $length
     * @return \Cocorico\EdnBundle\Wsdl\StructType\PackageType
     */
    public function setLength($length = null)
    {
        // validation for constraint: float
        if (!is_null($length) && !(is_float($length) || is_numeric($length))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($length, true), gettype($length)), __LINE__);
        }
        $this->length = $length;
        return $this;
    }
    /**
     * Get height value
     * @return float|null
     */
    public function getHeight()
    {
        return $this->height;
    }
    /**
     * Set height value
     * @param float $height
     * @return \Cocorico\EdnBundle\Wsdl\StructType\PackageType
     */
    public function setHeight($height = null)
    {
        // validation for constraint: float
        if (!is_null($height) && !(is_float($height) || is_numeric($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        $this->height = $height;
        return $this;
    }
    /**
     * Get width value
     * @return float|null
     */
    public function getWidth()
    {
        return $this->width;
    }
    /**
     * Set width value
     * @param float $width
     * @return \Cocorico\EdnBundle\Wsdl\StructType\PackageType
     */
    public function setWidth($width = null)
    {
        // validation for constraint: float
        if (!is_null($width) && !(is_float($width) || is_numeric($width))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        $this->width = $width;
        return $this;
    }
    /**
     * Get insurance value
     * @return float|null
     */
    public function getInsurance()
    {
        return $this->insurance;
    }
    /**
     * Set insurance value
     * @param float $insurance
     * @return \Cocorico\EdnBundle\Wsdl\StructType\PackageType
     */
    public function setInsurance($insurance = null)
    {
        // validation for constraint: float
        if (!is_null($insurance) && !(is_float($insurance) || is_numeric($insurance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insurance, true), gettype($insurance)), __LINE__);
        }
        $this->insurance = $insurance;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Cocorico\EdnBundle\Wsdl\StructType\PackageType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
