<?php

namespace Cocorico\EdnBundle\Wsdl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for loginType StructType
 * @subpackage Structs
 */
class LoginType extends AbstractStructBase
{
    /**
     * The api_account
     * @var string
     */
    public $api_account;
    /**
     * The api_key
     * @var string
     */
    public $api_key;
    /**
     * The origin
     * Meta information extracted from the WSDL
     * - documentation: Origin of call request, possible values are api (default), website, batch, expedamore, prestashop, magento, woocommerce, other
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $origin;
    /**
     * Constructor method for loginType
     * @uses LoginType::setApi_account()
     * @uses LoginType::setApi_key()
     * @uses LoginType::setOrigin()
     * @param string $api_account
     * @param string $api_key
     * @param string $origin
     */
    public function __construct($api_account = null, $api_key = null, $origin = null)
    {
        $this
            ->setApi_account($api_account)
            ->setApi_key($api_key)
            ->setOrigin($origin);
    }
    /**
     * Get api_account value
     * @return string|null
     */
    public function getApi_account()
    {
        return $this->api_account;
    }
    /**
     * Set api_account value
     * @param string $api_account
     * @return \Cocorico\EdnBundle\Wsdl\StructType\LoginType
     */
    public function setApi_account($api_account = null)
    {
        // validation for constraint: string
        if (!is_null($api_account) && !is_string($api_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($api_account, true), gettype($api_account)), __LINE__);
        }
        $this->api_account = $api_account;
        return $this;
    }
    /**
     * Get api_key value
     * @return string|null
     */
    public function getApi_key()
    {
        return $this->api_key;
    }
    /**
     * Set api_key value
     * @param string $api_key
     * @return \Cocorico\EdnBundle\Wsdl\StructType\LoginType
     */
    public function setApi_key($api_key = null)
    {
        // validation for constraint: string
        if (!is_null($api_key) && !is_string($api_key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($api_key, true), gettype($api_key)), __LINE__);
        }
        $this->api_key = $api_key;
        return $this;
    }
    /**
     * Get origin value
     * @return string|null
     */
    public function getOrigin()
    {
        return $this->origin;
    }
    /**
     * Set origin value
     * @param string $origin
     * @return \Cocorico\EdnBundle\Wsdl\StructType\LoginType
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: string
        if (!is_null($origin) && !is_string($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origin, true), gettype($origin)), __LINE__);
        }
        $this->origin = $origin;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Cocorico\EdnBundle\Wsdl\StructType\LoginType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
