<?php

namespace Cocorico\EdnBundle\Wsdl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getShipmentsResponse StructType
 * @subpackage Structs
 */
class GetShipmentsResponse extends AbstractStructBase
{
    /**
     * The shipments
     * Meta information extracted from the WSDL
     * - arrayType: tns:shipmentType[]
     * - base: SOAP-ENC:Array
     * - maxOccurs: 1
     * - minOccurs: 1
     * - ref: SOAP-ENC:arrayType
     * @var \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType[]
     */
    public $shipments;
    /**
     * The pdf
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pdf;
    /**
     * Constructor method for getShipmentsResponse
     * @uses GetShipmentsResponse::setShipments()
     * @uses GetShipmentsResponse::setPdf()
     * @param \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType[] $shipments
     * @param string $pdf
     */
    public function __construct(array $shipments = array(), $pdf = null)
    {
        $this
            ->setShipments($shipments)
            ->setPdf($pdf);
    }
    /**
     * Get shipments value
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType[]
     */
    public function getShipments()
    {
        return $this->shipments;
    }
    /**
     * This method is responsible for validating the values passed to the setShipments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipments method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentsForArrayConstraintsFromSetShipments(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getShipmentsResponseShipmentsItem) {
            // validation for constraint: itemType
            if (!$getShipmentsResponseShipmentsItem instanceof \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType) {
                $invalidValues[] = is_object($getShipmentsResponseShipmentsItem) ? get_class($getShipmentsResponseShipmentsItem) : sprintf('%s(%s)', gettype($getShipmentsResponseShipmentsItem), var_export($getShipmentsResponseShipmentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The shipments property can only contain items of type \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set shipments value
     * @throws \InvalidArgumentException
     * @param \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType[] $shipments
     * @return \Cocorico\EdnBundle\Wsdl\StructType\GetShipmentsResponse
     */
    public function setShipments(array $shipments = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentsArrayErrorMessage = self::validateShipmentsForArrayConstraintsFromSetShipments($shipments))) {
            throw new \InvalidArgumentException($shipmentsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($shipments) && count($shipments) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 1', count($shipments)), __LINE__);
        }
        $this->shipments = $shipments;
        return $this;
    }
    /**
     * Add item to shipments value
     * @throws \InvalidArgumentException
     * @param \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType $item
     * @return \Cocorico\EdnBundle\Wsdl\StructType\GetShipmentsResponse
     */
    public function addToShipments(\Cocorico\EdnBundle\Wsdl\StructType\ShipmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType) {
            throw new \InvalidArgumentException(sprintf('The shipments property can only contain items of type \Cocorico\EdnBundle\Wsdl\StructType\ShipmentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($this->shipments) && count($this->shipments) >= 1) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 1', count($this->shipments)), __LINE__);
        }
        $this->shipments[] = $item;
        return $this;
    }
    /**
     * Get pdf value
     * @return string|null
     */
    public function getPdf()
    {
        return $this->pdf;
    }
    /**
     * Set pdf value
     * @param string $pdf
     * @return \Cocorico\EdnBundle\Wsdl\StructType\GetShipmentsResponse
     */
    public function setPdf($pdf = null)
    {
        // validation for constraint: string
        if (!is_null($pdf) && !is_string($pdf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pdf, true), gettype($pdf)), __LINE__);
        }
        $this->pdf = $pdf;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Cocorico\EdnBundle\Wsdl\StructType\GetShipmentsResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
