<?php

namespace Cocorico\EdnBundle\Wsdl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for findRelaysRequest StructType
 * @subpackage Structs
 */
class FindRelaysRequest extends AbstractStructBase
{
    /**
     * The carrier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $carrier;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - documentation: 2-letter country ISO code
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The postcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $postcode;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $city;
    /**
     * Constructor method for findRelaysRequest
     * @uses FindRelaysRequest::setCarrier()
     * @uses FindRelaysRequest::setCountry()
     * @uses FindRelaysRequest::setPostcode()
     * @uses FindRelaysRequest::setCity()
     * @param string $carrier
     * @param string $country
     * @param string $postcode
     * @param string $city
     */
    public function __construct($carrier = null, $country = null, $postcode = null, $city = null)
    {
        $this
            ->setCarrier($carrier)
            ->setCountry($country)
            ->setPostcode($postcode)
            ->setCity($city);
    }
    /**
     * Get carrier value
     * @return string
     */
    public function getCarrier()
    {
        return $this->carrier;
    }
    /**
     * Set carrier value
     * @uses \Cocorico\EdnBundle\Wsdl\EnumType\EnumCarrierType::valueIsValid()
     * @uses \Cocorico\EdnBundle\Wsdl\EnumType\EnumCarrierType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $carrier
     * @return \Cocorico\EdnBundle\Wsdl\StructType\FindRelaysRequest
     */
    public function setCarrier($carrier = null)
    {
        // validation for constraint: enumeration
        if (!\Cocorico\EdnBundle\Wsdl\EnumType\EnumCarrierType::valueIsValid($carrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Cocorico\EdnBundle\Wsdl\EnumType\EnumCarrierType', is_array($carrier) ? implode(', ', $carrier) : var_export($carrier, true), implode(', ', \Cocorico\EdnBundle\Wsdl\EnumType\EnumCarrierType::getValidValues())), __LINE__);
        }
        $this->carrier = $carrier;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \Cocorico\EdnBundle\Wsdl\StructType\FindRelaysRequest
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get postcode value
     * @return string|null
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \Cocorico\EdnBundle\Wsdl\StructType\FindRelaysRequest
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \Cocorico\EdnBundle\Wsdl\StructType\FindRelaysRequest
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Cocorico\EdnBundle\Wsdl\StructType\FindRelaysRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
