<?php

namespace Cocorico\EdnBundle\Wsdl\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getQuote
     * Meta information extracted from the WSDL
     * - documentation: Get Quote
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Cocorico\EdnBundle\Wsdl\StructType\LoginType $login
     * @param \Cocorico\EdnBundle\Wsdl\StructType\GetQuoteRequest $params
     * @return array|bool
     */
    public function getQuote(\Cocorico\EdnBundle\Wsdl\StructType\LoginType $login, \Cocorico\EdnBundle\Wsdl\StructType\GetQuoteRequest $params)
    {
        try {
            $this->setResult($this->getSoapClient()->getQuote($login, $params));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCarrierQuote
     * Meta information extracted from the WSDL
     * - documentation: Get a quote for a single carrier
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Cocorico\EdnBundle\Wsdl\StructType\ExtendedLoginType $login
     * @param \Cocorico\EdnBundle\Wsdl\StructType\GetCarrierQuoteRequest $params
     * @return array|bool
     */
    public function getCarrierQuote(\Cocorico\EdnBundle\Wsdl\StructType\ExtendedLoginType $login, \Cocorico\EdnBundle\Wsdl\StructType\GetCarrierQuoteRequest $params)
    {
        try {
            $this->setResult($this->getSoapClient()->getCarrierQuote($login, $params));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBuyingPrice
     * Meta information extracted from the WSDL
     * - documentation: Get a buying price for a specific shipment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Cocorico\EdnBundle\Wsdl\StructType\ExtendedLoginType $login
     * @param \Cocorico\EdnBundle\Wsdl\StructType\GetBuyingPriceRequest $params
     * @return array|bool
     */
    public function getBuyingPrice(\Cocorico\EdnBundle\Wsdl\StructType\ExtendedLoginType $login, \Cocorico\EdnBundle\Wsdl\StructType\GetBuyingPriceRequest $params)
    {
        try {
            $this->setResult($this->getSoapClient()->getBuyingPrice($login, $params));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRelay
     * Meta information extracted from the WSDL
     * - documentation: Get a relay by id
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Cocorico\EdnBundle\Wsdl\StructType\LoginType $login
     * @param \Cocorico\EdnBundle\Wsdl\StructType\GetRelayRequest $params
     * @return array|bool
     */
    public function getRelay(\Cocorico\EdnBundle\Wsdl\StructType\LoginType $login, \Cocorico\EdnBundle\Wsdl\StructType\GetRelayRequest $params)
    {
        try {
            $this->setResult($this->getSoapClient()->getRelay($login, $params));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCache
     * Meta information extracted from the WSDL
     * - documentation: Get cache
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Cocorico\EdnBundle\Wsdl\StructType\LoginType $login
     * @return array|bool
     */
    public function getCache(\Cocorico\EdnBundle\Wsdl\StructType\LoginType $login)
    {
        try {
            $this->setResult($this->getSoapClient()->getCache($login));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPricing
     * Meta information extracted from the WSDL
     * - documentation: Get Pricing
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Cocorico\EdnBundle\Wsdl\StructType\LoginType $login
     * @return array|bool
     */
    public function getPricing(\Cocorico\EdnBundle\Wsdl\StructType\LoginType $login)
    {
        try {
            $this->setResult($this->getSoapClient()->getPricing($login));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCarriers
     * Meta information extracted from the WSDL
     * - documentation: Get Carriers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Cocorico\EdnBundle\Wsdl\StructType\LoginType $login
     * @return array|bool
     */
    public function getCarriers(\Cocorico\EdnBundle\Wsdl\StructType\LoginType $login)
    {
        try {
            $this->setResult($this->getSoapClient()->getCarriers($login));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCarrierCompanies
     * Meta information extracted from the WSDL
     * - documentation: Get Carrier Companies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Cocorico\EdnBundle\Wsdl\StructType\ExtendedLoginType $login
     * @return array|bool
     */
    public function getCarrierCompanies(\Cocorico\EdnBundle\Wsdl\StructType\ExtendedLoginType $login)
    {
        try {
            $this->setResult($this->getSoapClient()->getCarrierCompanies($login));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRelayCache
     * Meta information extracted from the WSDL
     * - documentation: Get Relay Cache
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Cocorico\EdnBundle\Wsdl\StructType\LoginType $login
     * @return array|bool
     */
    public function getRelayCache(\Cocorico\EdnBundle\Wsdl\StructType\LoginType $login)
    {
        try {
            $this->setResult($this->getSoapClient()->getRelayCache($login));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getShipment
     * Meta information extracted from the WSDL
     * - documentation: Get Shipment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Cocorico\EdnBundle\Wsdl\StructType\ExtendedLoginType $login
     * @param \Cocorico\EdnBundle\Wsdl\StructType\GetShipmentRequest $params
     * @return array|bool
     */
    public function getShipment(\Cocorico\EdnBundle\Wsdl\StructType\ExtendedLoginType $login, \Cocorico\EdnBundle\Wsdl\StructType\GetShipmentRequest $params)
    {
        try {
            $this->setResult($this->getSoapClient()->getShipment($login, $params));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getShipments
     * Meta information extracted from the WSDL
     * - documentation: Get Shipments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Cocorico\EdnBundle\Wsdl\StructType\LoginType $login
     * @param \Cocorico\EdnBundle\Wsdl\StructType\GetShipmentsRequest $params
     * @return array|bool
     */
    public function getShipments(\Cocorico\EdnBundle\Wsdl\StructType\LoginType $login, \Cocorico\EdnBundle\Wsdl\StructType\GetShipmentsRequest $params)
    {
        try {
            $this->setResult($this->getSoapClient()->getShipments($login, $params));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
