<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://api.envoidunet.com/?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://api.envoidunet.com/?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \Cocorico\EdnBundle\Wsdl\ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \Cocorico\EdnBundle\Wsdl\ServiceType\Get($options);
/**
 * Sample call for getQuote operation/method
 */
if ($get->getQuote(new \Cocorico\EdnBundle\Wsdl\StructType\LoginType(), new \Cocorico\EdnBundle\Wsdl\StructType\GetQuoteRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCarrierQuote operation/method
 */
if ($get->getCarrierQuote(new \Cocorico\EdnBundle\Wsdl\StructType\ExtendedLoginType(), new \Cocorico\EdnBundle\Wsdl\StructType\GetCarrierQuoteRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBuyingPrice operation/method
 */
if ($get->getBuyingPrice(new \Cocorico\EdnBundle\Wsdl\StructType\ExtendedLoginType(), new \Cocorico\EdnBundle\Wsdl\StructType\GetBuyingPriceRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRelay operation/method
 */
if ($get->getRelay(new \Cocorico\EdnBundle\Wsdl\StructType\LoginType(), new \Cocorico\EdnBundle\Wsdl\StructType\GetRelayRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCache operation/method
 */
if ($get->getCache(new \Cocorico\EdnBundle\Wsdl\StructType\LoginType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPricing operation/method
 */
if ($get->getPricing(new \Cocorico\EdnBundle\Wsdl\StructType\LoginType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCarriers operation/method
 */
if ($get->getCarriers(new \Cocorico\EdnBundle\Wsdl\StructType\LoginType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCarrierCompanies operation/method
 */
if ($get->getCarrierCompanies(new \Cocorico\EdnBundle\Wsdl\StructType\ExtendedLoginType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRelayCache operation/method
 */
if ($get->getRelayCache(new \Cocorico\EdnBundle\Wsdl\StructType\LoginType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getShipment operation/method
 */
if ($get->getShipment(new \Cocorico\EdnBundle\Wsdl\StructType\ExtendedLoginType(), new \Cocorico\EdnBundle\Wsdl\StructType\GetShipmentRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getShipments operation/method
 */
if ($get->getShipments(new \Cocorico\EdnBundle\Wsdl\StructType\LoginType(), new \Cocorico\EdnBundle\Wsdl\StructType\GetShipmentsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \Cocorico\EdnBundle\Wsdl\ServiceType\Create($options);
/**
 * Sample call for createShipment operation/method
 */
if ($create->createShipment(new \Cocorico\EdnBundle\Wsdl\StructType\LoginType(), new \Cocorico\EdnBundle\Wsdl\StructType\CreateShipmentRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createReturn operation/method
 */
if ($create->createReturn(new \Cocorico\EdnBundle\Wsdl\StructType\LoginType(), new \Cocorico\EdnBundle\Wsdl\StructType\CreateReturnRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createPickup operation/method
 */
if ($create->createPickup(new \Cocorico\EdnBundle\Wsdl\StructType\LoginType(), new \Cocorico\EdnBundle\Wsdl\StructType\CreatePickupRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \Cocorico\EdnBundle\Wsdl\ServiceType\Set($options);
/**
 * Sample call for setTrackingEvents operation/method
 */
if ($set->setTrackingEvents(new \Cocorico\EdnBundle\Wsdl\StructType\LoginType(), new \Cocorico\EdnBundle\Wsdl\StructType\SetTrackingEventsRequest()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \Cocorico\EdnBundle\Wsdl\ServiceType\Cancel($options);
/**
 * Sample call for cancelPickup operation/method
 */
if ($cancel->cancelPickup(new \Cocorico\EdnBundle\Wsdl\StructType\LoginType(), new \Cocorico\EdnBundle\Wsdl\StructType\CancelPickupRequest()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Find ServiceType
 */
$find = new \Cocorico\EdnBundle\Wsdl\ServiceType\Find($options);
/**
 * Sample call for findRelays operation/method
 */
if ($find->findRelays(new \Cocorico\EdnBundle\Wsdl\StructType\LoginType(), new \Cocorico\EdnBundle\Wsdl\StructType\FindRelaysRequest()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
