<?php

namespace Cocorico\EdnBundle\Wsdl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for setTrackingEventsRequest StructType
 * @subpackage Structs
 */
class SetTrackingEventsRequest extends AbstractStructBase
{
    /**
     * The events
     * Meta information extracted from the WSDL
     * - arrayType: tns:extendedTrackingEventType[]
     * - base: SOAP-ENC:Array
     * - maxOccurs: 1
     * - minOccurs: 1
     * - ref: SOAP-ENC:arrayType
     * @var \Cocorico\EdnBundle\Wsdl\StructType\ExtendedTrackingEventType[]
     */
    public $events;
    /**
     * Constructor method for setTrackingEventsRequest
     * @uses SetTrackingEventsRequest::setEvents()
     * @param \Cocorico\EdnBundle\Wsdl\StructType\ExtendedTrackingEventType[] $events
     */
    public function __construct(array $events = array())
    {
        $this
            ->setEvents($events);
    }
    /**
     * Get events value
     * @return \Cocorico\EdnBundle\Wsdl\StructType\ExtendedTrackingEventType[]
     */
    public function getEvents()
    {
        return $this->events;
    }
    /**
     * This method is responsible for validating the values passed to the setEvents method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEvents method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEventsForArrayConstraintsFromSetEvents(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $setTrackingEventsRequestEventsItem) {
            // validation for constraint: itemType
            if (!$setTrackingEventsRequestEventsItem instanceof \Cocorico\EdnBundle\Wsdl\StructType\ExtendedTrackingEventType) {
                $invalidValues[] = is_object($setTrackingEventsRequestEventsItem) ? get_class($setTrackingEventsRequestEventsItem) : sprintf('%s(%s)', gettype($setTrackingEventsRequestEventsItem), var_export($setTrackingEventsRequestEventsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The events property can only contain items of type \Cocorico\EdnBundle\Wsdl\StructType\ExtendedTrackingEventType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set events value
     * @throws \InvalidArgumentException
     * @param \Cocorico\EdnBundle\Wsdl\StructType\ExtendedTrackingEventType[] $events
     * @return \Cocorico\EdnBundle\Wsdl\StructType\SetTrackingEventsRequest
     */
    public function setEvents(array $events = array())
    {
        // validation for constraint: array
        if ('' !== ($eventsArrayErrorMessage = self::validateEventsForArrayConstraintsFromSetEvents($events))) {
            throw new \InvalidArgumentException($eventsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($events) && count($events) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 1', count($events)), __LINE__);
        }
        $this->events = $events;
        return $this;
    }
    /**
     * Add item to events value
     * @throws \InvalidArgumentException
     * @param \Cocorico\EdnBundle\Wsdl\StructType\ExtendedTrackingEventType $item
     * @return \Cocorico\EdnBundle\Wsdl\StructType\SetTrackingEventsRequest
     */
    public function addToEvents(\Cocorico\EdnBundle\Wsdl\StructType\ExtendedTrackingEventType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Cocorico\EdnBundle\Wsdl\StructType\ExtendedTrackingEventType) {
            throw new \InvalidArgumentException(sprintf('The events property can only contain items of type \Cocorico\EdnBundle\Wsdl\StructType\ExtendedTrackingEventType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($this->events) && count($this->events) >= 1) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 1', count($this->events)), __LINE__);
        }
        $this->events[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Cocorico\EdnBundle\Wsdl\StructType\SetTrackingEventsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
