<?php

namespace Cocorico\EdnBundle\Wsdl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for quoteType StructType
 * @subpackage Structs
 */
class QuoteType extends AbstractStructBase
{
    /**
     * The service
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $service;
    /**
     * The service_name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $service_name;
    /**
     * The carrier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $carrier;
    /**
     * The carrier_name
     * Meta information extracted from the WSDL
     * - documentation: Full carrier name
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $carrier_name;
    /**
     * The carrier_logo
     * Meta information extracted from the WSDL
     * - documentation: Url of the carrier logo
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $carrier_logo;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - documentation: Price, VAT not included. This should be the sum of the base price and the surcharges
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $price;
    /**
     * The carrier_description
     * Meta information extracted from the WSDL
     * - documentation: Full carrier description
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $carrier_description;
    /**
     * The base_price
     * Meta information extracted from the WSDL
     * - documentation: Base price
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $base_price;
    /**
     * The fuel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $fuel;
    /**
     * The fuel_rate
     * Meta information extracted from the WSDL
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $fuel_rate;
    /**
     * The security
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $security;
    /**
     * The ecotax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $ecotax;
    /**
     * The remote
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $remote;
    /**
     * The insurance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $insurance;
    /**
     * The misc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $misc;
    /**
     * The vat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $vat;
    /**
     * Constructor method for quoteType
     * @uses QuoteType::setService()
     * @uses QuoteType::setService_name()
     * @uses QuoteType::setCarrier()
     * @uses QuoteType::setCarrier_name()
     * @uses QuoteType::setCarrier_logo()
     * @uses QuoteType::setPrice()
     * @uses QuoteType::setCarrier_description()
     * @uses QuoteType::setBase_price()
     * @uses QuoteType::setFuel()
     * @uses QuoteType::setFuel_rate()
     * @uses QuoteType::setSecurity()
     * @uses QuoteType::setEcotax()
     * @uses QuoteType::setRemote()
     * @uses QuoteType::setInsurance()
     * @uses QuoteType::setMisc()
     * @uses QuoteType::setVat()
     * @param string $service
     * @param string $service_name
     * @param string $carrier
     * @param string $carrier_name
     * @param string $carrier_logo
     * @param float $price
     * @param string $carrier_description
     * @param float $base_price
     * @param float $fuel
     * @param float $fuel_rate
     * @param float $security
     * @param float $ecotax
     * @param float $remote
     * @param float $insurance
     * @param float $misc
     * @param float $vat
     */
    public function __construct($service = null, $service_name = null, $carrier = null, $carrier_name = null, $carrier_logo = null, $price = null, $carrier_description = null, $base_price = null, $fuel = null, $fuel_rate = null, $security = null, $ecotax = null, $remote = null, $insurance = null, $misc = null, $vat = null)
    {
        $this
            ->setService($service)
            ->setService_name($service_name)
            ->setCarrier($carrier)
            ->setCarrier_name($carrier_name)
            ->setCarrier_logo($carrier_logo)
            ->setPrice($price)
            ->setCarrier_description($carrier_description)
            ->setBase_price($base_price)
            ->setFuel($fuel)
            ->setFuel_rate($fuel_rate)
            ->setSecurity($security)
            ->setEcotax($ecotax)
            ->setRemote($remote)
            ->setInsurance($insurance)
            ->setMisc($misc)
            ->setVat($vat);
    }
    /**
     * Get service value
     * @return string
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @uses \Cocorico\EdnBundle\Wsdl\EnumType\EnumServiceType::valueIsValid()
     * @uses \Cocorico\EdnBundle\Wsdl\EnumType\EnumServiceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $service
     * @return \Cocorico\EdnBundle\Wsdl\StructType\QuoteType
     */
    public function setService($service = null)
    {
        // validation for constraint: enumeration
        if (!\Cocorico\EdnBundle\Wsdl\EnumType\EnumServiceType::valueIsValid($service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Cocorico\EdnBundle\Wsdl\EnumType\EnumServiceType', is_array($service) ? implode(', ', $service) : var_export($service, true), implode(', ', \Cocorico\EdnBundle\Wsdl\EnumType\EnumServiceType::getValidValues())), __LINE__);
        }
        $this->service = $service;
        return $this;
    }
    /**
     * Get service_name value
     * @return string
     */
    public function getService_name()
    {
        return $this->service_name;
    }
    /**
     * Set service_name value
     * @param string $service_name
     * @return \Cocorico\EdnBundle\Wsdl\StructType\QuoteType
     */
    public function setService_name($service_name = null)
    {
        // validation for constraint: string
        if (!is_null($service_name) && !is_string($service_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($service_name, true), gettype($service_name)), __LINE__);
        }
        $this->service_name = $service_name;
        return $this;
    }
    /**
     * Get carrier value
     * @return string
     */
    public function getCarrier()
    {
        return $this->carrier;
    }
    /**
     * Set carrier value
     * @uses \Cocorico\EdnBundle\Wsdl\EnumType\EnumCarrierType::valueIsValid()
     * @uses \Cocorico\EdnBundle\Wsdl\EnumType\EnumCarrierType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $carrier
     * @return \Cocorico\EdnBundle\Wsdl\StructType\QuoteType
     */
    public function setCarrier($carrier = null)
    {
        // validation for constraint: enumeration
        if (!\Cocorico\EdnBundle\Wsdl\EnumType\EnumCarrierType::valueIsValid($carrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Cocorico\EdnBundle\Wsdl\EnumType\EnumCarrierType', is_array($carrier) ? implode(', ', $carrier) : var_export($carrier, true), implode(', ', \Cocorico\EdnBundle\Wsdl\EnumType\EnumCarrierType::getValidValues())), __LINE__);
        }
        $this->carrier = $carrier;
        return $this;
    }
    /**
     * Get carrier_name value
     * @return string
     */
    public function getCarrier_name()
    {
        return $this->carrier_name;
    }
    /**
     * Set carrier_name value
     * @param string $carrier_name
     * @return \Cocorico\EdnBundle\Wsdl\StructType\QuoteType
     */
    public function setCarrier_name($carrier_name = null)
    {
        // validation for constraint: string
        if (!is_null($carrier_name) && !is_string($carrier_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrier_name, true), gettype($carrier_name)), __LINE__);
        }
        $this->carrier_name = $carrier_name;
        return $this;
    }
    /**
     * Get carrier_logo value
     * @return string
     */
    public function getCarrier_logo()
    {
        return $this->carrier_logo;
    }
    /**
     * Set carrier_logo value
     * @param string $carrier_logo
     * @return \Cocorico\EdnBundle\Wsdl\StructType\QuoteType
     */
    public function setCarrier_logo($carrier_logo = null)
    {
        // validation for constraint: string
        if (!is_null($carrier_logo) && !is_string($carrier_logo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrier_logo, true), gettype($carrier_logo)), __LINE__);
        }
        $this->carrier_logo = $carrier_logo;
        return $this;
    }
    /**
     * Get price value
     * @return float
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \Cocorico\EdnBundle\Wsdl\StructType\QuoteType
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get carrier_description value
     * @return string|null
     */
    public function getCarrier_description()
    {
        return $this->carrier_description;
    }
    /**
     * Set carrier_description value
     * @param string $carrier_description
     * @return \Cocorico\EdnBundle\Wsdl\StructType\QuoteType
     */
    public function setCarrier_description($carrier_description = null)
    {
        // validation for constraint: string
        if (!is_null($carrier_description) && !is_string($carrier_description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrier_description, true), gettype($carrier_description)), __LINE__);
        }
        $this->carrier_description = $carrier_description;
        return $this;
    }
    /**
     * Get base_price value
     * @return float|null
     */
    public function getBase_price()
    {
        return $this->base_price;
    }
    /**
     * Set base_price value
     * @param float $base_price
     * @return \Cocorico\EdnBundle\Wsdl\StructType\QuoteType
     */
    public function setBase_price($base_price = null)
    {
        // validation for constraint: float
        if (!is_null($base_price) && !(is_float($base_price) || is_numeric($base_price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($base_price, true), gettype($base_price)), __LINE__);
        }
        $this->base_price = $base_price;
        return $this;
    }
    /**
     * Get fuel value
     * @return float|null
     */
    public function getFuel()
    {
        return $this->fuel;
    }
    /**
     * Set fuel value
     * @param float $fuel
     * @return \Cocorico\EdnBundle\Wsdl\StructType\QuoteType
     */
    public function setFuel($fuel = null)
    {
        // validation for constraint: float
        if (!is_null($fuel) && !(is_float($fuel) || is_numeric($fuel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fuel, true), gettype($fuel)), __LINE__);
        }
        $this->fuel = $fuel;
        return $this;
    }
    /**
     * Get fuel_rate value
     * @return float|null
     */
    public function getFuel_rate()
    {
        return $this->fuel_rate;
    }
    /**
     * Set fuel_rate value
     * @param float $fuel_rate
     * @return \Cocorico\EdnBundle\Wsdl\StructType\QuoteType
     */
    public function setFuel_rate($fuel_rate = null)
    {
        // validation for constraint: float
        if (!is_null($fuel_rate) && !(is_float($fuel_rate) || is_numeric($fuel_rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fuel_rate, true), gettype($fuel_rate)), __LINE__);
        }
        $this->fuel_rate = $fuel_rate;
        return $this;
    }
    /**
     * Get security value
     * @return float|null
     */
    public function getSecurity()
    {
        return $this->security;
    }
    /**
     * Set security value
     * @param float $security
     * @return \Cocorico\EdnBundle\Wsdl\StructType\QuoteType
     */
    public function setSecurity($security = null)
    {
        // validation for constraint: float
        if (!is_null($security) && !(is_float($security) || is_numeric($security))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($security, true), gettype($security)), __LINE__);
        }
        $this->security = $security;
        return $this;
    }
    /**
     * Get ecotax value
     * @return float|null
     */
    public function getEcotax()
    {
        return $this->ecotax;
    }
    /**
     * Set ecotax value
     * @param float $ecotax
     * @return \Cocorico\EdnBundle\Wsdl\StructType\QuoteType
     */
    public function setEcotax($ecotax = null)
    {
        // validation for constraint: float
        if (!is_null($ecotax) && !(is_float($ecotax) || is_numeric($ecotax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ecotax, true), gettype($ecotax)), __LINE__);
        }
        $this->ecotax = $ecotax;
        return $this;
    }
    /**
     * Get remote value
     * @return float|null
     */
    public function getRemote()
    {
        return $this->remote;
    }
    /**
     * Set remote value
     * @param float $remote
     * @return \Cocorico\EdnBundle\Wsdl\StructType\QuoteType
     */
    public function setRemote($remote = null)
    {
        // validation for constraint: float
        if (!is_null($remote) && !(is_float($remote) || is_numeric($remote))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($remote, true), gettype($remote)), __LINE__);
        }
        $this->remote = $remote;
        return $this;
    }
    /**
     * Get insurance value
     * @return float|null
     */
    public function getInsurance()
    {
        return $this->insurance;
    }
    /**
     * Set insurance value
     * @param float $insurance
     * @return \Cocorico\EdnBundle\Wsdl\StructType\QuoteType
     */
    public function setInsurance($insurance = null)
    {
        // validation for constraint: float
        if (!is_null($insurance) && !(is_float($insurance) || is_numeric($insurance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insurance, true), gettype($insurance)), __LINE__);
        }
        $this->insurance = $insurance;
        return $this;
    }
    /**
     * Get misc value
     * @return float|null
     */
    public function getMisc()
    {
        return $this->misc;
    }
    /**
     * Set misc value
     * @param float $misc
     * @return \Cocorico\EdnBundle\Wsdl\StructType\QuoteType
     */
    public function setMisc($misc = null)
    {
        // validation for constraint: float
        if (!is_null($misc) && !(is_float($misc) || is_numeric($misc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($misc, true), gettype($misc)), __LINE__);
        }
        $this->misc = $misc;
        return $this;
    }
    /**
     * Get vat value
     * @return float|null
     */
    public function getVat()
    {
        return $this->vat;
    }
    /**
     * Set vat value
     * @param float $vat
     * @return \Cocorico\EdnBundle\Wsdl\StructType\QuoteType
     */
    public function setVat($vat = null)
    {
        // validation for constraint: float
        if (!is_null($vat) && !(is_float($vat) || is_numeric($vat))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vat, true), gettype($vat)), __LINE__);
        }
        $this->vat = $vat;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Cocorico\EdnBundle\Wsdl\StructType\QuoteType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
