<?php

namespace Cocorico\EdnBundle\Wsdl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for openingHoursType StructType
 * @subpackage Structs
 */
class OpeningHoursType extends AbstractStructBase
{
    /**
     * The day
     * Meta information extracted from the WSDL
     * - documentation: Day of week, 1 is for Monday, 2 for Tuesday, etc
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $day;
    /**
     * The hours
     * Meta information extracted from the WSDL
     * - documentation: Opening hours as string, eg: 09:00-12:00 14:00-18:00
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $hours;
    /**
     * Constructor method for openingHoursType
     * @uses OpeningHoursType::setDay()
     * @uses OpeningHoursType::setHours()
     * @param int $day
     * @param string $hours
     */
    public function __construct($day = null, $hours = null)
    {
        $this
            ->setDay($day)
            ->setHours($hours);
    }
    /**
     * Get day value
     * @return int
     */
    public function getDay()
    {
        return $this->day;
    }
    /**
     * Set day value
     * @param int $day
     * @return \Cocorico\EdnBundle\Wsdl\StructType\OpeningHoursType
     */
    public function setDay($day = null)
    {
        // validation for constraint: int
        if (!is_null($day) && !(is_int($day) || ctype_digit($day))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($day, true), gettype($day)), __LINE__);
        }
        $this->day = $day;
        return $this;
    }
    /**
     * Get hours value
     * @return string
     */
    public function getHours()
    {
        return $this->hours;
    }
    /**
     * Set hours value
     * @param string $hours
     * @return \Cocorico\EdnBundle\Wsdl\StructType\OpeningHoursType
     */
    public function setHours($hours = null)
    {
        // validation for constraint: string
        if (!is_null($hours) && !is_string($hours)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hours, true), gettype($hours)), __LINE__);
        }
        $this->hours = $hours;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Cocorico\EdnBundle\Wsdl\StructType\OpeningHoursType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
