<?php

namespace Cocorico\EdnBundle\Wsdl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getCarrierQuoteRequest StructType
 * @subpackage Structs
 */
class GetCarrierQuoteRequest extends GetQuoteRequest
{
    /**
     * The pricing_grids
     * Meta information extracted from the WSDL
     * - documentation: Internal use
     * - arrayType: xsd:positiveInteger[]
     * - base: SOAP-ENC:Array
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: SOAP-ENC:arrayType
     * @var int[]
     */
    public $pricing_grids;
    /**
     * The date
     * Meta information extracted from the WSDL
     * - documentation: Internal use
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $date;
    /**
     * Constructor method for getCarrierQuoteRequest
     * @uses GetCarrierQuoteRequest::setPricing_grids()
     * @uses GetCarrierQuoteRequest::setDate()
     * @param int[] $pricing_grids
     * @param string $date
     */
    public function __construct(array $pricing_grids = array(), $date = null)
    {
        $this
            ->setPricing_grids($pricing_grids)
            ->setDate($date);
    }
    /**
     * Get pricing_grids value
     * @return int[]|null
     */
    public function getPricing_grids()
    {
        return $this->pricing_grids;
    }
    /**
     * This method is responsible for validating the values passed to the setPricing_grids method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPricing_grids method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePricing_gridsForArrayConstraintsFromSetPricing_grids(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getCarrierQuoteRequestPricing_gridsItem) {
            // validation for constraint: itemType
            if (!(is_int($getCarrierQuoteRequestPricing_gridsItem) || ctype_digit($getCarrierQuoteRequestPricing_gridsItem))) {
                $invalidValues[] = is_object($getCarrierQuoteRequestPricing_gridsItem) ? get_class($getCarrierQuoteRequestPricing_gridsItem) : sprintf('%s(%s)', gettype($getCarrierQuoteRequestPricing_gridsItem), var_export($getCarrierQuoteRequestPricing_gridsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The pricing_grids property can only contain items of type positiveInteger, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set pricing_grids value
     * @throws \InvalidArgumentException
     * @param int[] $pricing_grids
     * @return \Cocorico\EdnBundle\Wsdl\StructType\GetCarrierQuoteRequest
     */
    public function setPricing_grids(array $pricing_grids = array())
    {
        // validation for constraint: array
        if ('' !== ($pricing_gridsArrayErrorMessage = self::validatePricing_gridsForArrayConstraintsFromSetPricing_grids($pricing_grids))) {
            throw new \InvalidArgumentException($pricing_gridsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($pricing_grids) && count($pricing_grids) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 1', count($pricing_grids)), __LINE__);
        }
        $this->pricing_grids = $pricing_grids;
        return $this;
    }
    /**
     * Add item to pricing_grids value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \Cocorico\EdnBundle\Wsdl\StructType\GetCarrierQuoteRequest
     */
    public function addToPricing_grids($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The pricing_grids property can only contain items of type positiveInteger, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($this->pricing_grids) && count($this->pricing_grids) >= 1) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 1', count($this->pricing_grids)), __LINE__);
        }
        $this->pricing_grids[] = $item;
        return $this;
    }
    /**
     * Get date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \Cocorico\EdnBundle\Wsdl\StructType\GetCarrierQuoteRequest
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Cocorico\EdnBundle\Wsdl\StructType\GetCarrierQuoteRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
