<?php

namespace Cocorico\EdnBundle\Wsdl\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named setTrackingEvents
     * Meta information extracted from the WSDL
     * - documentation: Set a pickup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Cocorico\EdnBundle\Wsdl\StructType\LoginType $login
     * @param \Cocorico\EdnBundle\Wsdl\StructType\SetTrackingEventsRequest $params
     * @return array|bool
     */
    public function setTrackingEvents(\Cocorico\EdnBundle\Wsdl\StructType\LoginType $login, \Cocorico\EdnBundle\Wsdl\StructType\SetTrackingEventsRequest $params)
    {
        try {
            $this->setResult($this->getSoapClient()->setTrackingEvents($login, $params));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
