<?php

namespace Cocorico\EdnBundle\Wsdl\EnumType;

/**
 * This class stands for enumServiceType EnumType
 * @subpackage Enumerations
 */
class EnumServiceType
{
    /**
     * Constant for value 'express'
     * @return string 'express'
     */
    const VALUE_EXPRESS = 'express';
    /**
     * Constant for value 'expresspro'
     * @return string 'expresspro'
     */
    const VALUE_EXPRESSPRO = 'expresspro';
    /**
     * Constant for value 'postal'
     * @return string 'postal'
     */
    const VALUE_POSTAL = 'postal';
    /**
     * Constant for value 'relay'
     * @return string 'relay'
     */
    const VALUE_RELAY = 'relay';
    /**
     * Constant for value 'standard'
     * @return string 'standard'
     */
    const VALUE_STANDARD = 'standard';
    /**
     * Constant for value 'international'
     * @return string 'international'
     */
    const VALUE_INTERNATIONAL = 'international';
    /**
     * Constant for value 'internationaleco'
     * @return string 'internationaleco'
     */
    const VALUE_INTERNATIONALECO = 'internationaleco';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EXPRESS
     * @uses self::VALUE_EXPRESSPRO
     * @uses self::VALUE_POSTAL
     * @uses self::VALUE_RELAY
     * @uses self::VALUE_STANDARD
     * @uses self::VALUE_INTERNATIONAL
     * @uses self::VALUE_INTERNATIONALECO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EXPRESS,
            self::VALUE_EXPRESSPRO,
            self::VALUE_POSTAL,
            self::VALUE_RELAY,
            self::VALUE_STANDARD,
            self::VALUE_INTERNATIONAL,
            self::VALUE_INTERNATIONALECO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
