<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NegativeKeywordConflictReportRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:NegativeKeywordConflictReportRequest
 * @subpackage Structs
 */
class NegativeKeywordConflictReportRequest extends ReportRequest
{
    /**
     * The Columns
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfNegativeKeywordConflictReportColumn
     */
    public $Columns;
    /**
     * The Filter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\NegativeKeywordConflictReportFilter
     */
    public $Filter;
    /**
     * The Scope
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\AccountThroughAdGroupReportScope
     */
    public $Scope;
    /**
     * Constructor method for NegativeKeywordConflictReportRequest
     * @uses NegativeKeywordConflictReportRequest::setColumns()
     * @uses NegativeKeywordConflictReportRequest::setFilter()
     * @uses NegativeKeywordConflictReportRequest::setScope()
     * @param \ArrayType\ArrayOfNegativeKeywordConflictReportColumn $columns
     * @param \StructType\NegativeKeywordConflictReportFilter $filter
     * @param \StructType\AccountThroughAdGroupReportScope $scope
     */
    public function __construct(\ArrayType\ArrayOfNegativeKeywordConflictReportColumn $columns = null, \StructType\NegativeKeywordConflictReportFilter $filter = null, \StructType\AccountThroughAdGroupReportScope $scope = null)
    {
        $this
            ->setColumns($columns)
            ->setFilter($filter)
            ->setScope($scope);
    }
    /**
     * Get Columns value
     * @return \ArrayType\ArrayOfNegativeKeywordConflictReportColumn|null
     */
    public function getColumns()
    {
        return $this->Columns;
    }
    /**
     * Set Columns value
     * @param \ArrayType\ArrayOfNegativeKeywordConflictReportColumn $columns
     * @return \StructType\NegativeKeywordConflictReportRequest
     */
    public function setColumns(\ArrayType\ArrayOfNegativeKeywordConflictReportColumn $columns = null)
    {
        $this->Columns = $columns;
        return $this;
    }
    /**
     * Get Filter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\NegativeKeywordConflictReportFilter|null
     */
    public function getFilter()
    {
        return isset($this->Filter) ? $this->Filter : null;
    }
    /**
     * Set Filter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\NegativeKeywordConflictReportFilter $filter
     * @return \StructType\NegativeKeywordConflictReportRequest
     */
    public function setFilter(\StructType\NegativeKeywordConflictReportFilter $filter = null)
    {
        if (is_null($filter) || (is_array($filter) && empty($filter))) {
            unset($this->Filter);
        } else {
            $this->Filter = $filter;
        }
        return $this;
    }
    /**
     * Get Scope value
     * @return \StructType\AccountThroughAdGroupReportScope|null
     */
    public function getScope()
    {
        return $this->Scope;
    }
    /**
     * Set Scope value
     * @param \StructType\AccountThroughAdGroupReportScope $scope
     * @return \StructType\NegativeKeywordConflictReportRequest
     */
    public function setScope(\StructType\AccountThroughAdGroupReportScope $scope = null)
    {
        $this->Scope = $scope;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NegativeKeywordConflictReportRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
