<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CallDetailReportFilter StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CallDetailReportFilter
 * @subpackage Structs
 */
class CallDetailReportFilter extends AbstractStructBase
{
    /**
     * The AccountStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AccountStatus;
    /**
     * The AdGroupStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AdGroupStatus;
    /**
     * The CampaignStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $CampaignStatus;
    /**
     * Constructor method for CallDetailReportFilter
     * @uses CallDetailReportFilter::setAccountStatus()
     * @uses CallDetailReportFilter::setAdGroupStatus()
     * @uses CallDetailReportFilter::setCampaignStatus()
     * @param string[] $accountStatus
     * @param string[] $adGroupStatus
     * @param string[] $campaignStatus
     */
    public function __construct(array $accountStatus = array(), array $adGroupStatus = array(), array $campaignStatus = array())
    {
        $this
            ->setAccountStatus($accountStatus)
            ->setAdGroupStatus($adGroupStatus)
            ->setCampaignStatus($campaignStatus);
    }
    /**
     * Get AccountStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAccountStatus()
    {
        return isset($this->AccountStatus) ? $this->AccountStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAccountStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountStatusForArrayConstraintsFromSetAccountStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $callDetailReportFilterAccountStatusItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AccountStatusReportFilter::valueIsValid($callDetailReportFilterAccountStatusItem)) {
                $invalidValues[] = is_object($callDetailReportFilterAccountStatusItem) ? get_class($callDetailReportFilterAccountStatusItem) : sprintf('%s(%s)', gettype($callDetailReportFilterAccountStatusItem), var_export($callDetailReportFilterAccountStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AccountStatusReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AccountStatusReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AccountStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AccountStatusReportFilter::valueIsValid()
     * @uses \EnumType\AccountStatusReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $accountStatus
     * @return \StructType\CallDetailReportFilter
     */
    public function setAccountStatus(array $accountStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($accountStatusArrayErrorMessage = self::validateAccountStatusForArrayConstraintsFromSetAccountStatus($accountStatus))) {
            throw new \InvalidArgumentException($accountStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($accountStatus) || (is_array($accountStatus) && empty($accountStatus))) {
            unset($this->AccountStatus);
        } else {
            $this->AccountStatus = is_array($accountStatus) ? implode(' ', $accountStatus) : null;
        }
        return $this;
    }
    /**
     * Get AdGroupStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAdGroupStatus()
    {
        return isset($this->AdGroupStatus) ? $this->AdGroupStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAdGroupStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdGroupStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdGroupStatusForArrayConstraintsFromSetAdGroupStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $callDetailReportFilterAdGroupStatusItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AdGroupStatusReportFilter::valueIsValid($callDetailReportFilterAdGroupStatusItem)) {
                $invalidValues[] = is_object($callDetailReportFilterAdGroupStatusItem) ? get_class($callDetailReportFilterAdGroupStatusItem) : sprintf('%s(%s)', gettype($callDetailReportFilterAdGroupStatusItem), var_export($callDetailReportFilterAdGroupStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdGroupStatusReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AdGroupStatusReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdGroupStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AdGroupStatusReportFilter::valueIsValid()
     * @uses \EnumType\AdGroupStatusReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $adGroupStatus
     * @return \StructType\CallDetailReportFilter
     */
    public function setAdGroupStatus(array $adGroupStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($adGroupStatusArrayErrorMessage = self::validateAdGroupStatusForArrayConstraintsFromSetAdGroupStatus($adGroupStatus))) {
            throw new \InvalidArgumentException($adGroupStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($adGroupStatus) || (is_array($adGroupStatus) && empty($adGroupStatus))) {
            unset($this->AdGroupStatus);
        } else {
            $this->AdGroupStatus = is_array($adGroupStatus) ? implode(' ', $adGroupStatus) : null;
        }
        return $this;
    }
    /**
     * Get CampaignStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getCampaignStatus()
    {
        return isset($this->CampaignStatus) ? $this->CampaignStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCampaignStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCampaignStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCampaignStatusForArrayConstraintsFromSetCampaignStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $callDetailReportFilterCampaignStatusItem) {
            // validation for constraint: enumeration
            if (!\EnumType\CampaignStatusReportFilter::valueIsValid($callDetailReportFilterCampaignStatusItem)) {
                $invalidValues[] = is_object($callDetailReportFilterCampaignStatusItem) ? get_class($callDetailReportFilterCampaignStatusItem) : sprintf('%s(%s)', gettype($callDetailReportFilterCampaignStatusItem), var_export($callDetailReportFilterCampaignStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CampaignStatusReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\CampaignStatusReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CampaignStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\CampaignStatusReportFilter::valueIsValid()
     * @uses \EnumType\CampaignStatusReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $campaignStatus
     * @return \StructType\CallDetailReportFilter
     */
    public function setCampaignStatus(array $campaignStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($campaignStatusArrayErrorMessage = self::validateCampaignStatusForArrayConstraintsFromSetCampaignStatus($campaignStatus))) {
            throw new \InvalidArgumentException($campaignStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($campaignStatus) || (is_array($campaignStatus) && empty($campaignStatus))) {
            unset($this->CampaignStatus);
        } else {
            $this->CampaignStatus = is_array($campaignStatus) ? implode(' ', $campaignStatus) : null;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CallDetailReportFilter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
