<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountThroughAdGroupReportScope StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AccountThroughAdGroupReportScope
 * @subpackage Structs
 */
class AccountThroughAdGroupReportScope extends AbstractStructBase
{
    /**
     * The AccountIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $AccountIds;
    /**
     * The AdGroups
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAdGroupReportScope
     */
    public $AdGroups;
    /**
     * The Campaigns
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfCampaignReportScope
     */
    public $Campaigns;
    /**
     * Constructor method for AccountThroughAdGroupReportScope
     * @uses AccountThroughAdGroupReportScope::setAccountIds()
     * @uses AccountThroughAdGroupReportScope::setAdGroups()
     * @uses AccountThroughAdGroupReportScope::setCampaigns()
     * @param \ArrayType\ArrayOflong $accountIds
     * @param \ArrayType\ArrayOfAdGroupReportScope $adGroups
     * @param \ArrayType\ArrayOfCampaignReportScope $campaigns
     */
    public function __construct(\ArrayType\ArrayOflong $accountIds = null, \ArrayType\ArrayOfAdGroupReportScope $adGroups = null, \ArrayType\ArrayOfCampaignReportScope $campaigns = null)
    {
        $this
            ->setAccountIds($accountIds)
            ->setAdGroups($adGroups)
            ->setCampaigns($campaigns);
    }
    /**
     * Get AccountIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getAccountIds()
    {
        return isset($this->AccountIds) ? $this->AccountIds : null;
    }
    /**
     * Set AccountIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $accountIds
     * @return \StructType\AccountThroughAdGroupReportScope
     */
    public function setAccountIds(\ArrayType\ArrayOflong $accountIds = null)
    {
        if (is_null($accountIds) || (is_array($accountIds) && empty($accountIds))) {
            unset($this->AccountIds);
        } else {
            $this->AccountIds = $accountIds;
        }
        return $this;
    }
    /**
     * Get AdGroups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAdGroupReportScope|null
     */
    public function getAdGroups()
    {
        return isset($this->AdGroups) ? $this->AdGroups : null;
    }
    /**
     * Set AdGroups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAdGroupReportScope $adGroups
     * @return \StructType\AccountThroughAdGroupReportScope
     */
    public function setAdGroups(\ArrayType\ArrayOfAdGroupReportScope $adGroups = null)
    {
        if (is_null($adGroups) || (is_array($adGroups) && empty($adGroups))) {
            unset($this->AdGroups);
        } else {
            $this->AdGroups = $adGroups;
        }
        return $this;
    }
    /**
     * Get Campaigns value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfCampaignReportScope|null
     */
    public function getCampaigns()
    {
        return isset($this->Campaigns) ? $this->Campaigns : null;
    }
    /**
     * Set Campaigns value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfCampaignReportScope $campaigns
     * @return \StructType\AccountThroughAdGroupReportScope
     */
    public function setCampaigns(\ArrayType\ArrayOfCampaignReportScope $campaigns = null)
    {
        if (is_null($campaigns) || (is_array($campaigns) && empty($campaigns))) {
            unset($this->Campaigns);
        } else {
            $this->Campaigns = $campaigns;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccountThroughAdGroupReportScope
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
