<?php

namespace EnumType;

/**
 * This class stands for ReportTimeZone EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ReportTimeZone
 * @subpackage Enumerations
 */
class ReportTimeZone
{
    /**
     * Constant for value 'Nukualofa'
     * @return string 'Nukualofa'
     */
    const VALUE_NUKUALOFA = 'Nukualofa';
    /**
     * Constant for value 'FijiKamchatkaMarshallIsland'
     * @return string 'FijiKamchatkaMarshallIsland'
     */
    const VALUE_FIJI_KAMCHATKA_MARSHALL_ISLAND = 'FijiKamchatkaMarshallIsland';
    /**
     * Constant for value 'AucklandWellington'
     * @return string 'AucklandWellington'
     */
    const VALUE_AUCKLAND_WELLINGTON = 'AucklandWellington';
    /**
     * Constant for value 'MagadanSolomonIslandNewCaledonia'
     * @return string 'MagadanSolomonIslandNewCaledonia'
     */
    const VALUE_MAGADAN_SOLOMON_ISLAND_NEW_CALEDONIA = 'MagadanSolomonIslandNewCaledonia';
    /**
     * Constant for value 'Vladivostok'
     * @return string 'Vladivostok'
     */
    const VALUE_VLADIVOSTOK = 'Vladivostok';
    /**
     * Constant for value 'Hobart'
     * @return string 'Hobart'
     */
    const VALUE_HOBART = 'Hobart';
    /**
     * Constant for value 'GuamPortMoresby'
     * @return string 'GuamPortMoresby'
     */
    const VALUE_GUAM_PORT_MORESBY = 'GuamPortMoresby';
    /**
     * Constant for value 'CanberraMelbourneSydney'
     * @return string 'CanberraMelbourneSydney'
     */
    const VALUE_CANBERRA_MELBOURNE_SYDNEY = 'CanberraMelbourneSydney';
    /**
     * Constant for value 'Brisbane'
     * @return string 'Brisbane'
     */
    const VALUE_BRISBANE = 'Brisbane';
    /**
     * Constant for value 'Darwin'
     * @return string 'Darwin'
     */
    const VALUE_DARWIN = 'Darwin';
    /**
     * Constant for value 'Adelaide'
     * @return string 'Adelaide'
     */
    const VALUE_ADELAIDE = 'Adelaide';
    /**
     * Constant for value 'Yakutsk'
     * @return string 'Yakutsk'
     */
    const VALUE_YAKUTSK = 'Yakutsk';
    /**
     * Constant for value 'Seoul'
     * @return string 'Seoul'
     */
    const VALUE_SEOUL = 'Seoul';
    /**
     * Constant for value 'OsakaSapporoTokyo'
     * @return string 'OsakaSapporoTokyo'
     */
    const VALUE_OSAKA_SAPPORO_TOKYO = 'OsakaSapporoTokyo';
    /**
     * Constant for value 'Taipei'
     * @return string 'Taipei'
     */
    const VALUE_TAIPEI = 'Taipei';
    /**
     * Constant for value 'Perth'
     * @return string 'Perth'
     */
    const VALUE_PERTH = 'Perth';
    /**
     * Constant for value 'KualaLumpurSingapore'
     * @return string 'KualaLumpurSingapore'
     */
    const VALUE_KUALA_LUMPUR_SINGAPORE = 'KualaLumpurSingapore';
    /**
     * Constant for value 'IrkutskUlaanBataar'
     * @return string 'IrkutskUlaanBataar'
     */
    const VALUE_IRKUTSK_ULAAN_BATAAR = 'IrkutskUlaanBataar';
    /**
     * Constant for value 'BeijingChongqingHongKongUrumqi'
     * @return string 'BeijingChongqingHongKongUrumqi'
     */
    const VALUE_BEIJING_CHONGQING_HONG_KONG_URUMQI = 'BeijingChongqingHongKongUrumqi';
    /**
     * Constant for value 'Krasnoyarsk'
     * @return string 'Krasnoyarsk'
     */
    const VALUE_KRASNOYARSK = 'Krasnoyarsk';
    /**
     * Constant for value 'BangkokHanoiJakarta'
     * @return string 'BangkokHanoiJakarta'
     */
    const VALUE_BANGKOK_HANOI_JAKARTA = 'BangkokHanoiJakarta';
    /**
     * Constant for value 'Rangoon'
     * @return string 'Rangoon'
     */
    const VALUE_RANGOON = 'Rangoon';
    /**
     * Constant for value 'SriJayawardenepura'
     * @return string 'SriJayawardenepura'
     */
    const VALUE_SRI_JAYAWARDENEPURA = 'SriJayawardenepura';
    /**
     * Constant for value 'AstanaDhaka'
     * @return string 'AstanaDhaka'
     */
    const VALUE_ASTANA_DHAKA = 'AstanaDhaka';
    /**
     * Constant for value 'AlmatyNovosibirsk'
     * @return string 'AlmatyNovosibirsk'
     */
    const VALUE_ALMATY_NOVOSIBIRSK = 'AlmatyNovosibirsk';
    /**
     * Constant for value 'Kathmandu'
     * @return string 'Kathmandu'
     */
    const VALUE_KATHMANDU = 'Kathmandu';
    /**
     * Constant for value 'ChennaiKolkataMumbaiNewDelhi'
     * @return string 'ChennaiKolkataMumbaiNewDelhi'
     */
    const VALUE_CHENNAI_KOLKATA_MUMBAI_NEW_DELHI = 'ChennaiKolkataMumbaiNewDelhi';
    /**
     * Constant for value 'IslandamabadKarachiTashkent'
     * @return string 'IslandamabadKarachiTashkent'
     */
    const VALUE_ISLANDAMABAD_KARACHI_TASHKENT = 'IslandamabadKarachiTashkent';
    /**
     * Constant for value 'Ekaterinburg'
     * @return string 'Ekaterinburg'
     */
    const VALUE_EKATERINBURG = 'Ekaterinburg';
    /**
     * Constant for value 'Kabul'
     * @return string 'Kabul'
     */
    const VALUE_KABUL = 'Kabul';
    /**
     * Constant for value 'BakuTbilisiYerevan'
     * @return string 'BakuTbilisiYerevan'
     */
    const VALUE_BAKU_TBILISI_YEREVAN = 'BakuTbilisiYerevan';
    /**
     * Constant for value 'AbuDhabiMuscat'
     * @return string 'AbuDhabiMuscat'
     */
    const VALUE_ABU_DHABI_MUSCAT = 'AbuDhabiMuscat';
    /**
     * Constant for value 'Tehran'
     * @return string 'Tehran'
     */
    const VALUE_TEHRAN = 'Tehran';
    /**
     * Constant for value 'Nairobi'
     * @return string 'Nairobi'
     */
    const VALUE_NAIROBI = 'Nairobi';
    /**
     * Constant for value 'MoscowStPetersburgVolgograd'
     * @return string 'MoscowStPetersburgVolgograd'
     */
    const VALUE_MOSCOW_ST_PETERSBURG_VOLGOGRAD = 'MoscowStPetersburgVolgograd';
    /**
     * Constant for value 'KuwaitRiyadh'
     * @return string 'KuwaitRiyadh'
     */
    const VALUE_KUWAIT_RIYADH = 'KuwaitRiyadh';
    /**
     * Constant for value 'Baghdad'
     * @return string 'Baghdad'
     */
    const VALUE_BAGHDAD = 'Baghdad';
    /**
     * Constant for value 'Jerusalem'
     * @return string 'Jerusalem'
     */
    const VALUE_JERUSALEM = 'Jerusalem';
    /**
     * Constant for value 'HelsinkiKyivRigaSofiaTallinnVilnius'
     * @return string 'HelsinkiKyivRigaSofiaTallinnVilnius'
     */
    const VALUE_HELSINKI_KYIV_RIGA_SOFIA_TALLINN_VILNIUS = 'HelsinkiKyivRigaSofiaTallinnVilnius';
    /**
     * Constant for value 'HararePretoria'
     * @return string 'HararePretoria'
     */
    const VALUE_HARARE_PRETORIA = 'HararePretoria';
    /**
     * Constant for value 'Cairo'
     * @return string 'Cairo'
     */
    const VALUE_CAIRO = 'Cairo';
    /**
     * Constant for value 'Bucharest'
     * @return string 'Bucharest'
     */
    const VALUE_BUCHAREST = 'Bucharest';
    /**
     * Constant for value 'AthensIslandanbulMinsk'
     * @return string 'AthensIslandanbulMinsk'
     */
    const VALUE_ATHENS_ISLANDANBUL_MINSK = 'AthensIslandanbulMinsk';
    /**
     * Constant for value 'WestCentralAfrica'
     * @return string 'WestCentralAfrica'
     */
    const VALUE_WEST_CENTRAL_AFRICA = 'WestCentralAfrica';
    /**
     * Constant for value 'SarajevoSkopjeWarsawZagreb'
     * @return string 'SarajevoSkopjeWarsawZagreb'
     */
    const VALUE_SARAJEVO_SKOPJE_WARSAW_ZAGREB = 'SarajevoSkopjeWarsawZagreb';
    /**
     * Constant for value 'BrusselsCopenhagenMadridParis'
     * @return string 'BrusselsCopenhagenMadridParis'
     */
    const VALUE_BRUSSELS_COPENHAGEN_MADRID_PARIS = 'BrusselsCopenhagenMadridParis';
    /**
     * Constant for value 'BelgradeBratislavaBudapestLjubljanaPrague'
     * @return string 'BelgradeBratislavaBudapestLjubljanaPrague'
     */
    const VALUE_BELGRADE_BRATISLAVA_BUDAPEST_LJUBLJANA_PRAGUE = 'BelgradeBratislavaBudapestLjubljanaPrague';
    /**
     * Constant for value 'AmsterdamBerlinBernRomeStockholmVienna'
     * @return string 'AmsterdamBerlinBernRomeStockholmVienna'
     */
    const VALUE_AMSTERDAM_BERLIN_BERN_ROME_STOCKHOLM_VIENNA = 'AmsterdamBerlinBernRomeStockholmVienna';
    /**
     * Constant for value 'CasablancaMonrovia'
     * @return string 'CasablancaMonrovia'
     */
    const VALUE_CASABLANCA_MONROVIA = 'CasablancaMonrovia';
    /**
     * Constant for value 'GreenwichMeanTimeDublinEdinburghLisbonLondon'
     * @return string 'GreenwichMeanTimeDublinEdinburghLisbonLondon'
     */
    const VALUE_GREENWICH_MEAN_TIME_DUBLIN_EDINBURGH_LISBON_LONDON = 'GreenwichMeanTimeDublinEdinburghLisbonLondon';
    /**
     * Constant for value 'Azores'
     * @return string 'Azores'
     */
    const VALUE_AZORES = 'Azores';
    /**
     * Constant for value 'CapeVerdeIsland'
     * @return string 'CapeVerdeIsland'
     */
    const VALUE_CAPE_VERDE_ISLAND = 'CapeVerdeIsland';
    /**
     * Constant for value 'MidAtlantic'
     * @return string 'MidAtlantic'
     */
    const VALUE_MID_ATLANTIC = 'MidAtlantic';
    /**
     * Constant for value 'Brasilia'
     * @return string 'Brasilia'
     */
    const VALUE_BRASILIA = 'Brasilia';
    /**
     * Constant for value 'BuenosAiresGeorgetown'
     * @return string 'BuenosAiresGeorgetown'
     */
    const VALUE_BUENOS_AIRES_GEORGETOWN = 'BuenosAiresGeorgetown';
    /**
     * Constant for value 'Greenland'
     * @return string 'Greenland'
     */
    const VALUE_GREENLAND = 'Greenland';
    /**
     * Constant for value 'Newfoundland'
     * @return string 'Newfoundland'
     */
    const VALUE_NEWFOUNDLAND = 'Newfoundland';
    /**
     * Constant for value 'AtlanticTimeCanada'
     * @return string 'AtlanticTimeCanada'
     */
    const VALUE_ATLANTIC_TIME_CANADA = 'AtlanticTimeCanada';
    /**
     * Constant for value 'CaracasLaPaz'
     * @return string 'CaracasLaPaz'
     */
    const VALUE_CARACAS_LA_PAZ = 'CaracasLaPaz';
    /**
     * Constant for value 'Santiago'
     * @return string 'Santiago'
     */
    const VALUE_SANTIAGO = 'Santiago';
    /**
     * Constant for value 'BogotaLimaQuito'
     * @return string 'BogotaLimaQuito'
     */
    const VALUE_BOGOTA_LIMA_QUITO = 'BogotaLimaQuito';
    /**
     * Constant for value 'EasternTimeUSCanada'
     * @return string 'EasternTimeUSCanada'
     */
    const VALUE_EASTERN_TIME_USCANADA = 'EasternTimeUSCanada';
    /**
     * Constant for value 'IndianaEast'
     * @return string 'IndianaEast'
     */
    const VALUE_INDIANA_EAST = 'IndianaEast';
    /**
     * Constant for value 'CentralAmerica'
     * @return string 'CentralAmerica'
     */
    const VALUE_CENTRAL_AMERICA = 'CentralAmerica';
    /**
     * Constant for value 'CentralTimeUSCanada'
     * @return string 'CentralTimeUSCanada'
     */
    const VALUE_CENTRAL_TIME_USCANADA = 'CentralTimeUSCanada';
    /**
     * Constant for value 'GuadalajaraMexicoCityMonterrey'
     * @return string 'GuadalajaraMexicoCityMonterrey'
     */
    const VALUE_GUADALAJARA_MEXICO_CITY_MONTERREY = 'GuadalajaraMexicoCityMonterrey';
    /**
     * Constant for value 'Saskatchewan'
     * @return string 'Saskatchewan'
     */
    const VALUE_SASKATCHEWAN = 'Saskatchewan';
    /**
     * Constant for value 'Arizona'
     * @return string 'Arizona'
     */
    const VALUE_ARIZONA = 'Arizona';
    /**
     * Constant for value 'ChihuahuaLaPazMazatlan'
     * @return string 'ChihuahuaLaPazMazatlan'
     */
    const VALUE_CHIHUAHUA_LA_PAZ_MAZATLAN = 'ChihuahuaLaPazMazatlan';
    /**
     * Constant for value 'MountainTimeUSCanada'
     * @return string 'MountainTimeUSCanada'
     */
    const VALUE_MOUNTAIN_TIME_USCANADA = 'MountainTimeUSCanada';
    /**
     * Constant for value 'PacificTimeUSCanadaTijuana'
     * @return string 'PacificTimeUSCanadaTijuana'
     */
    const VALUE_PACIFIC_TIME_USCANADA_TIJUANA = 'PacificTimeUSCanadaTijuana';
    /**
     * Constant for value 'Alaska'
     * @return string 'Alaska'
     */
    const VALUE_ALASKA = 'Alaska';
    /**
     * Constant for value 'Hawaii'
     * @return string 'Hawaii'
     */
    const VALUE_HAWAII = 'Hawaii';
    /**
     * Constant for value 'MidwayIslandandSamoa'
     * @return string 'MidwayIslandandSamoa'
     */
    const VALUE_MIDWAY_ISLANDAND_SAMOA = 'MidwayIslandandSamoa';
    /**
     * Constant for value 'InternationalDateLineWest'
     * @return string 'InternationalDateLineWest'
     */
    const VALUE_INTERNATIONAL_DATE_LINE_WEST = 'InternationalDateLineWest';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NUKUALOFA
     * @uses self::VALUE_FIJI_KAMCHATKA_MARSHALL_ISLAND
     * @uses self::VALUE_AUCKLAND_WELLINGTON
     * @uses self::VALUE_MAGADAN_SOLOMON_ISLAND_NEW_CALEDONIA
     * @uses self::VALUE_VLADIVOSTOK
     * @uses self::VALUE_HOBART
     * @uses self::VALUE_GUAM_PORT_MORESBY
     * @uses self::VALUE_CANBERRA_MELBOURNE_SYDNEY
     * @uses self::VALUE_BRISBANE
     * @uses self::VALUE_DARWIN
     * @uses self::VALUE_ADELAIDE
     * @uses self::VALUE_YAKUTSK
     * @uses self::VALUE_SEOUL
     * @uses self::VALUE_OSAKA_SAPPORO_TOKYO
     * @uses self::VALUE_TAIPEI
     * @uses self::VALUE_PERTH
     * @uses self::VALUE_KUALA_LUMPUR_SINGAPORE
     * @uses self::VALUE_IRKUTSK_ULAAN_BATAAR
     * @uses self::VALUE_BEIJING_CHONGQING_HONG_KONG_URUMQI
     * @uses self::VALUE_KRASNOYARSK
     * @uses self::VALUE_BANGKOK_HANOI_JAKARTA
     * @uses self::VALUE_RANGOON
     * @uses self::VALUE_SRI_JAYAWARDENEPURA
     * @uses self::VALUE_ASTANA_DHAKA
     * @uses self::VALUE_ALMATY_NOVOSIBIRSK
     * @uses self::VALUE_KATHMANDU
     * @uses self::VALUE_CHENNAI_KOLKATA_MUMBAI_NEW_DELHI
     * @uses self::VALUE_ISLANDAMABAD_KARACHI_TASHKENT
     * @uses self::VALUE_EKATERINBURG
     * @uses self::VALUE_KABUL
     * @uses self::VALUE_BAKU_TBILISI_YEREVAN
     * @uses self::VALUE_ABU_DHABI_MUSCAT
     * @uses self::VALUE_TEHRAN
     * @uses self::VALUE_NAIROBI
     * @uses self::VALUE_MOSCOW_ST_PETERSBURG_VOLGOGRAD
     * @uses self::VALUE_KUWAIT_RIYADH
     * @uses self::VALUE_BAGHDAD
     * @uses self::VALUE_JERUSALEM
     * @uses self::VALUE_HELSINKI_KYIV_RIGA_SOFIA_TALLINN_VILNIUS
     * @uses self::VALUE_HARARE_PRETORIA
     * @uses self::VALUE_CAIRO
     * @uses self::VALUE_BUCHAREST
     * @uses self::VALUE_ATHENS_ISLANDANBUL_MINSK
     * @uses self::VALUE_WEST_CENTRAL_AFRICA
     * @uses self::VALUE_SARAJEVO_SKOPJE_WARSAW_ZAGREB
     * @uses self::VALUE_BRUSSELS_COPENHAGEN_MADRID_PARIS
     * @uses self::VALUE_BELGRADE_BRATISLAVA_BUDAPEST_LJUBLJANA_PRAGUE
     * @uses self::VALUE_AMSTERDAM_BERLIN_BERN_ROME_STOCKHOLM_VIENNA
     * @uses self::VALUE_CASABLANCA_MONROVIA
     * @uses self::VALUE_GREENWICH_MEAN_TIME_DUBLIN_EDINBURGH_LISBON_LONDON
     * @uses self::VALUE_AZORES
     * @uses self::VALUE_CAPE_VERDE_ISLAND
     * @uses self::VALUE_MID_ATLANTIC
     * @uses self::VALUE_BRASILIA
     * @uses self::VALUE_BUENOS_AIRES_GEORGETOWN
     * @uses self::VALUE_GREENLAND
     * @uses self::VALUE_NEWFOUNDLAND
     * @uses self::VALUE_ATLANTIC_TIME_CANADA
     * @uses self::VALUE_CARACAS_LA_PAZ
     * @uses self::VALUE_SANTIAGO
     * @uses self::VALUE_BOGOTA_LIMA_QUITO
     * @uses self::VALUE_EASTERN_TIME_USCANADA
     * @uses self::VALUE_INDIANA_EAST
     * @uses self::VALUE_CENTRAL_AMERICA
     * @uses self::VALUE_CENTRAL_TIME_USCANADA
     * @uses self::VALUE_GUADALAJARA_MEXICO_CITY_MONTERREY
     * @uses self::VALUE_SASKATCHEWAN
     * @uses self::VALUE_ARIZONA
     * @uses self::VALUE_CHIHUAHUA_LA_PAZ_MAZATLAN
     * @uses self::VALUE_MOUNTAIN_TIME_USCANADA
     * @uses self::VALUE_PACIFIC_TIME_USCANADA_TIJUANA
     * @uses self::VALUE_ALASKA
     * @uses self::VALUE_HAWAII
     * @uses self::VALUE_MIDWAY_ISLANDAND_SAMOA
     * @uses self::VALUE_INTERNATIONAL_DATE_LINE_WEST
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NUKUALOFA,
            self::VALUE_FIJI_KAMCHATKA_MARSHALL_ISLAND,
            self::VALUE_AUCKLAND_WELLINGTON,
            self::VALUE_MAGADAN_SOLOMON_ISLAND_NEW_CALEDONIA,
            self::VALUE_VLADIVOSTOK,
            self::VALUE_HOBART,
            self::VALUE_GUAM_PORT_MORESBY,
            self::VALUE_CANBERRA_MELBOURNE_SYDNEY,
            self::VALUE_BRISBANE,
            self::VALUE_DARWIN,
            self::VALUE_ADELAIDE,
            self::VALUE_YAKUTSK,
            self::VALUE_SEOUL,
            self::VALUE_OSAKA_SAPPORO_TOKYO,
            self::VALUE_TAIPEI,
            self::VALUE_PERTH,
            self::VALUE_KUALA_LUMPUR_SINGAPORE,
            self::VALUE_IRKUTSK_ULAAN_BATAAR,
            self::VALUE_BEIJING_CHONGQING_HONG_KONG_URUMQI,
            self::VALUE_KRASNOYARSK,
            self::VALUE_BANGKOK_HANOI_JAKARTA,
            self::VALUE_RANGOON,
            self::VALUE_SRI_JAYAWARDENEPURA,
            self::VALUE_ASTANA_DHAKA,
            self::VALUE_ALMATY_NOVOSIBIRSK,
            self::VALUE_KATHMANDU,
            self::VALUE_CHENNAI_KOLKATA_MUMBAI_NEW_DELHI,
            self::VALUE_ISLANDAMABAD_KARACHI_TASHKENT,
            self::VALUE_EKATERINBURG,
            self::VALUE_KABUL,
            self::VALUE_BAKU_TBILISI_YEREVAN,
            self::VALUE_ABU_DHABI_MUSCAT,
            self::VALUE_TEHRAN,
            self::VALUE_NAIROBI,
            self::VALUE_MOSCOW_ST_PETERSBURG_VOLGOGRAD,
            self::VALUE_KUWAIT_RIYADH,
            self::VALUE_BAGHDAD,
            self::VALUE_JERUSALEM,
            self::VALUE_HELSINKI_KYIV_RIGA_SOFIA_TALLINN_VILNIUS,
            self::VALUE_HARARE_PRETORIA,
            self::VALUE_CAIRO,
            self::VALUE_BUCHAREST,
            self::VALUE_ATHENS_ISLANDANBUL_MINSK,
            self::VALUE_WEST_CENTRAL_AFRICA,
            self::VALUE_SARAJEVO_SKOPJE_WARSAW_ZAGREB,
            self::VALUE_BRUSSELS_COPENHAGEN_MADRID_PARIS,
            self::VALUE_BELGRADE_BRATISLAVA_BUDAPEST_LJUBLJANA_PRAGUE,
            self::VALUE_AMSTERDAM_BERLIN_BERN_ROME_STOCKHOLM_VIENNA,
            self::VALUE_CASABLANCA_MONROVIA,
            self::VALUE_GREENWICH_MEAN_TIME_DUBLIN_EDINBURGH_LISBON_LONDON,
            self::VALUE_AZORES,
            self::VALUE_CAPE_VERDE_ISLAND,
            self::VALUE_MID_ATLANTIC,
            self::VALUE_BRASILIA,
            self::VALUE_BUENOS_AIRES_GEORGETOWN,
            self::VALUE_GREENLAND,
            self::VALUE_NEWFOUNDLAND,
            self::VALUE_ATLANTIC_TIME_CANADA,
            self::VALUE_CARACAS_LA_PAZ,
            self::VALUE_SANTIAGO,
            self::VALUE_BOGOTA_LIMA_QUITO,
            self::VALUE_EASTERN_TIME_USCANADA,
            self::VALUE_INDIANA_EAST,
            self::VALUE_CENTRAL_AMERICA,
            self::VALUE_CENTRAL_TIME_USCANADA,
            self::VALUE_GUADALAJARA_MEXICO_CITY_MONTERREY,
            self::VALUE_SASKATCHEWAN,
            self::VALUE_ARIZONA,
            self::VALUE_CHIHUAHUA_LA_PAZ_MAZATLAN,
            self::VALUE_MOUNTAIN_TIME_USCANADA,
            self::VALUE_PACIFIC_TIME_USCANADA_TIJUANA,
            self::VALUE_ALASKA,
            self::VALUE_HAWAII,
            self::VALUE_MIDWAY_ISLANDAND_SAMOA,
            self::VALUE_INTERNATIONAL_DATE_LINE_WEST,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
