<?php

namespace EnumType;

/**
 * This class stands for ReportFormat EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ReportFormat
 * @subpackage Enumerations
 */
class ReportFormat
{
    /**
     * Constant for value 'Csv'
     * @return string 'Csv'
     */
    const VALUE_CSV = 'Csv';
    /**
     * Constant for value 'Tsv'
     * @return string 'Tsv'
     */
    const VALUE_TSV = 'Tsv';
    /**
     * Constant for value 'Xml'
     * @return string 'Xml'
     */
    const VALUE_XML = 'Xml';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CSV
     * @uses self::VALUE_TSV
     * @uses self::VALUE_XML
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CSV,
            self::VALUE_TSV,
            self::VALUE_XML,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
