<?php

namespace EnumType;

/**
 * This class stands for NegativeKeywordConflictReportColumn EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:NegativeKeywordConflictReportColumn
 * @subpackage Enumerations
 */
class NegativeKeywordConflictReportColumn
{
    /**
     * Constant for value 'AccountName'
     * @return string 'AccountName'
     */
    const VALUE_ACCOUNT_NAME = 'AccountName';
    /**
     * Constant for value 'AccountNumber'
     * @return string 'AccountNumber'
     */
    const VALUE_ACCOUNT_NUMBER = 'AccountNumber';
    /**
     * Constant for value 'AccountId'
     * @return string 'AccountId'
     */
    const VALUE_ACCOUNT_ID = 'AccountId';
    /**
     * Constant for value 'CampaignName'
     * @return string 'CampaignName'
     */
    const VALUE_CAMPAIGN_NAME = 'CampaignName';
    /**
     * Constant for value 'CampaignId'
     * @return string 'CampaignId'
     */
    const VALUE_CAMPAIGN_ID = 'CampaignId';
    /**
     * Constant for value 'AdGroupName'
     * @return string 'AdGroupName'
     */
    const VALUE_AD_GROUP_NAME = 'AdGroupName';
    /**
     * Constant for value 'AdGroupId'
     * @return string 'AdGroupId'
     */
    const VALUE_AD_GROUP_ID = 'AdGroupId';
    /**
     * Constant for value 'Keyword'
     * @return string 'Keyword'
     */
    const VALUE_KEYWORD = 'Keyword';
    /**
     * Constant for value 'KeywordId'
     * @return string 'KeywordId'
     */
    const VALUE_KEYWORD_ID = 'KeywordId';
    /**
     * Constant for value 'NegativeKeyword'
     * @return string 'NegativeKeyword'
     */
    const VALUE_NEGATIVE_KEYWORD = 'NegativeKeyword';
    /**
     * Constant for value 'ConflictLevel'
     * @return string 'ConflictLevel'
     */
    const VALUE_CONFLICT_LEVEL = 'ConflictLevel';
    /**
     * Constant for value 'BidMatchType'
     * @return string 'BidMatchType'
     */
    const VALUE_BID_MATCH_TYPE = 'BidMatchType';
    /**
     * Constant for value 'NegativeKeywordListId'
     * @return string 'NegativeKeywordListId'
     */
    const VALUE_NEGATIVE_KEYWORD_LIST_ID = 'NegativeKeywordListId';
    /**
     * Constant for value 'NegativeKeywordList'
     * @return string 'NegativeKeywordList'
     */
    const VALUE_NEGATIVE_KEYWORD_LIST = 'NegativeKeywordList';
    /**
     * Constant for value 'NegativeKeywordId'
     * @return string 'NegativeKeywordId'
     */
    const VALUE_NEGATIVE_KEYWORD_ID = 'NegativeKeywordId';
    /**
     * Constant for value 'NegativeKeywordMatchType'
     * @return string 'NegativeKeywordMatchType'
     */
    const VALUE_NEGATIVE_KEYWORD_MATCH_TYPE = 'NegativeKeywordMatchType';
    /**
     * Constant for value 'AccountStatus'
     * @return string 'AccountStatus'
     */
    const VALUE_ACCOUNT_STATUS = 'AccountStatus';
    /**
     * Constant for value 'CampaignStatus'
     * @return string 'CampaignStatus'
     */
    const VALUE_CAMPAIGN_STATUS = 'CampaignStatus';
    /**
     * Constant for value 'AdGroupStatus'
     * @return string 'AdGroupStatus'
     */
    const VALUE_AD_GROUP_STATUS = 'AdGroupStatus';
    /**
     * Constant for value 'KeywordStatus'
     * @return string 'KeywordStatus'
     */
    const VALUE_KEYWORD_STATUS = 'KeywordStatus';
    /**
     * Constant for value 'ConflictType'
     * @return string 'ConflictType'
     */
    const VALUE_CONFLICT_TYPE = 'ConflictType';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACCOUNT_NAME
     * @uses self::VALUE_ACCOUNT_NUMBER
     * @uses self::VALUE_ACCOUNT_ID
     * @uses self::VALUE_CAMPAIGN_NAME
     * @uses self::VALUE_CAMPAIGN_ID
     * @uses self::VALUE_AD_GROUP_NAME
     * @uses self::VALUE_AD_GROUP_ID
     * @uses self::VALUE_KEYWORD
     * @uses self::VALUE_KEYWORD_ID
     * @uses self::VALUE_NEGATIVE_KEYWORD
     * @uses self::VALUE_CONFLICT_LEVEL
     * @uses self::VALUE_BID_MATCH_TYPE
     * @uses self::VALUE_NEGATIVE_KEYWORD_LIST_ID
     * @uses self::VALUE_NEGATIVE_KEYWORD_LIST
     * @uses self::VALUE_NEGATIVE_KEYWORD_ID
     * @uses self::VALUE_NEGATIVE_KEYWORD_MATCH_TYPE
     * @uses self::VALUE_ACCOUNT_STATUS
     * @uses self::VALUE_CAMPAIGN_STATUS
     * @uses self::VALUE_AD_GROUP_STATUS
     * @uses self::VALUE_KEYWORD_STATUS
     * @uses self::VALUE_CONFLICT_TYPE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACCOUNT_NAME,
            self::VALUE_ACCOUNT_NUMBER,
            self::VALUE_ACCOUNT_ID,
            self::VALUE_CAMPAIGN_NAME,
            self::VALUE_CAMPAIGN_ID,
            self::VALUE_AD_GROUP_NAME,
            self::VALUE_AD_GROUP_ID,
            self::VALUE_KEYWORD,
            self::VALUE_KEYWORD_ID,
            self::VALUE_NEGATIVE_KEYWORD,
            self::VALUE_CONFLICT_LEVEL,
            self::VALUE_BID_MATCH_TYPE,
            self::VALUE_NEGATIVE_KEYWORD_LIST_ID,
            self::VALUE_NEGATIVE_KEYWORD_LIST,
            self::VALUE_NEGATIVE_KEYWORD_ID,
            self::VALUE_NEGATIVE_KEYWORD_MATCH_TYPE,
            self::VALUE_ACCOUNT_STATUS,
            self::VALUE_CAMPAIGN_STATUS,
            self::VALUE_AD_GROUP_STATUS,
            self::VALUE_KEYWORD_STATUS,
            self::VALUE_CONFLICT_TYPE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
