<?php

namespace EnumType;

/**
 * This class stands for LanguageReportFilter EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LanguageReportFilter
 * @subpackage Enumerations
 */
class LanguageReportFilter
{
    /**
     * Constant for value 'Danish'
     * @return string 'Danish'
     */
    const VALUE_DANISH = 'Danish';
    /**
     * Constant for value 'Dutch'
     * @return string 'Dutch'
     */
    const VALUE_DUTCH = 'Dutch';
    /**
     * Constant for value 'English'
     * @return string 'English'
     */
    const VALUE_ENGLISH = 'English';
    /**
     * Constant for value 'Finnish'
     * @return string 'Finnish'
     */
    const VALUE_FINNISH = 'Finnish';
    /**
     * Constant for value 'French'
     * @return string 'French'
     */
    const VALUE_FRENCH = 'French';
    /**
     * Constant for value 'German'
     * @return string 'German'
     */
    const VALUE_GERMAN = 'German';
    /**
     * Constant for value 'Italian'
     * @return string 'Italian'
     */
    const VALUE_ITALIAN = 'Italian';
    /**
     * Constant for value 'Japanese'
     * @return string 'Japanese'
     */
    const VALUE_JAPANESE = 'Japanese';
    /**
     * Constant for value 'Norwegian'
     * @return string 'Norwegian'
     */
    const VALUE_NORWEGIAN = 'Norwegian';
    /**
     * Constant for value 'Portuguese'
     * @return string 'Portuguese'
     */
    const VALUE_PORTUGUESE = 'Portuguese';
    /**
     * Constant for value 'Swedish'
     * @return string 'Swedish'
     */
    const VALUE_SWEDISH = 'Swedish';
    /**
     * Constant for value 'Spanish'
     * @return string 'Spanish'
     */
    const VALUE_SPANISH = 'Spanish';
    /**
     * Constant for value 'Arabic'
     * @return string 'Arabic'
     */
    const VALUE_ARABIC = 'Arabic';
    /**
     * Constant for value 'Hebrew'
     * @return string 'Hebrew'
     */
    const VALUE_HEBREW = 'Hebrew';
    /**
     * Constant for value 'Korean'
     * @return string 'Korean'
     */
    const VALUE_KOREAN = 'Korean';
    /**
     * Constant for value 'Russian'
     * @return string 'Russian'
     */
    const VALUE_RUSSIAN = 'Russian';
    /**
     * Constant for value 'TraditionalChinese'
     * @return string 'TraditionalChinese'
     */
    const VALUE_TRADITIONAL_CHINESE = 'TraditionalChinese';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DANISH
     * @uses self::VALUE_DUTCH
     * @uses self::VALUE_ENGLISH
     * @uses self::VALUE_FINNISH
     * @uses self::VALUE_FRENCH
     * @uses self::VALUE_GERMAN
     * @uses self::VALUE_ITALIAN
     * @uses self::VALUE_JAPANESE
     * @uses self::VALUE_NORWEGIAN
     * @uses self::VALUE_PORTUGUESE
     * @uses self::VALUE_SWEDISH
     * @uses self::VALUE_SPANISH
     * @uses self::VALUE_ARABIC
     * @uses self::VALUE_HEBREW
     * @uses self::VALUE_KOREAN
     * @uses self::VALUE_RUSSIAN
     * @uses self::VALUE_TRADITIONAL_CHINESE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DANISH,
            self::VALUE_DUTCH,
            self::VALUE_ENGLISH,
            self::VALUE_FINNISH,
            self::VALUE_FRENCH,
            self::VALUE_GERMAN,
            self::VALUE_ITALIAN,
            self::VALUE_JAPANESE,
            self::VALUE_NORWEGIAN,
            self::VALUE_PORTUGUESE,
            self::VALUE_SWEDISH,
            self::VALUE_SPANISH,
            self::VALUE_ARABIC,
            self::VALUE_HEBREW,
            self::VALUE_KOREAN,
            self::VALUE_RUSSIAN,
            self::VALUE_TRADITIONAL_CHINESE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
