<?php

namespace EnumType;

/**
 * This class stands for GoalsAndFunnelsReportColumn EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GoalsAndFunnelsReportColumn
 * @subpackage Enumerations
 */
class GoalsAndFunnelsReportColumn
{
    /**
     * Constant for value 'AccountName'
     * @return string 'AccountName'
     */
    const VALUE_ACCOUNT_NAME = 'AccountName';
    /**
     * Constant for value 'AccountNumber'
     * @return string 'AccountNumber'
     */
    const VALUE_ACCOUNT_NUMBER = 'AccountNumber';
    /**
     * Constant for value 'AccountId'
     * @return string 'AccountId'
     */
    const VALUE_ACCOUNT_ID = 'AccountId';
    /**
     * Constant for value 'TimePeriod'
     * @return string 'TimePeriod'
     */
    const VALUE_TIME_PERIOD = 'TimePeriod';
    /**
     * Constant for value 'CampaignName'
     * @return string 'CampaignName'
     */
    const VALUE_CAMPAIGN_NAME = 'CampaignName';
    /**
     * Constant for value 'CampaignId'
     * @return string 'CampaignId'
     */
    const VALUE_CAMPAIGN_ID = 'CampaignId';
    /**
     * Constant for value 'AdGroupName'
     * @return string 'AdGroupName'
     */
    const VALUE_AD_GROUP_NAME = 'AdGroupName';
    /**
     * Constant for value 'AdGroupId'
     * @return string 'AdGroupId'
     */
    const VALUE_AD_GROUP_ID = 'AdGroupId';
    /**
     * Constant for value 'Keyword'
     * @return string 'Keyword'
     */
    const VALUE_KEYWORD = 'Keyword';
    /**
     * Constant for value 'KeywordId'
     * @return string 'KeywordId'
     */
    const VALUE_KEYWORD_ID = 'KeywordId';
    /**
     * Constant for value 'Goal'
     * @return string 'Goal'
     */
    const VALUE_GOAL = 'Goal';
    /**
     * Constant for value 'AllConversions'
     * @return string 'AllConversions'
     */
    const VALUE_ALL_CONVERSIONS = 'AllConversions';
    /**
     * Constant for value 'Assists'
     * @return string 'Assists'
     */
    const VALUE_ASSISTS = 'Assists';
    /**
     * Constant for value 'AllRevenue'
     * @return string 'AllRevenue'
     */
    const VALUE_ALL_REVENUE = 'AllRevenue';
    /**
     * Constant for value 'GoalId'
     * @return string 'GoalId'
     */
    const VALUE_GOAL_ID = 'GoalId';
    /**
     * Constant for value 'DeviceType'
     * @return string 'DeviceType'
     */
    const VALUE_DEVICE_TYPE = 'DeviceType';
    /**
     * Constant for value 'DeviceOS'
     * @return string 'DeviceOS'
     */
    const VALUE_DEVICE_OS = 'DeviceOS';
    /**
     * Constant for value 'AccountStatus'
     * @return string 'AccountStatus'
     */
    const VALUE_ACCOUNT_STATUS = 'AccountStatus';
    /**
     * Constant for value 'CampaignStatus'
     * @return string 'CampaignStatus'
     */
    const VALUE_CAMPAIGN_STATUS = 'CampaignStatus';
    /**
     * Constant for value 'AdGroupStatus'
     * @return string 'AdGroupStatus'
     */
    const VALUE_AD_GROUP_STATUS = 'AdGroupStatus';
    /**
     * Constant for value 'KeywordStatus'
     * @return string 'KeywordStatus'
     */
    const VALUE_KEYWORD_STATUS = 'KeywordStatus';
    /**
     * Constant for value 'GoalType'
     * @return string 'GoalType'
     */
    const VALUE_GOAL_TYPE = 'GoalType';
    /**
     * Constant for value 'ViewThroughConversions'
     * @return string 'ViewThroughConversions'
     */
    const VALUE_VIEW_THROUGH_CONVERSIONS = 'ViewThroughConversions';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACCOUNT_NAME
     * @uses self::VALUE_ACCOUNT_NUMBER
     * @uses self::VALUE_ACCOUNT_ID
     * @uses self::VALUE_TIME_PERIOD
     * @uses self::VALUE_CAMPAIGN_NAME
     * @uses self::VALUE_CAMPAIGN_ID
     * @uses self::VALUE_AD_GROUP_NAME
     * @uses self::VALUE_AD_GROUP_ID
     * @uses self::VALUE_KEYWORD
     * @uses self::VALUE_KEYWORD_ID
     * @uses self::VALUE_GOAL
     * @uses self::VALUE_ALL_CONVERSIONS
     * @uses self::VALUE_ASSISTS
     * @uses self::VALUE_ALL_REVENUE
     * @uses self::VALUE_GOAL_ID
     * @uses self::VALUE_DEVICE_TYPE
     * @uses self::VALUE_DEVICE_OS
     * @uses self::VALUE_ACCOUNT_STATUS
     * @uses self::VALUE_CAMPAIGN_STATUS
     * @uses self::VALUE_AD_GROUP_STATUS
     * @uses self::VALUE_KEYWORD_STATUS
     * @uses self::VALUE_GOAL_TYPE
     * @uses self::VALUE_VIEW_THROUGH_CONVERSIONS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACCOUNT_NAME,
            self::VALUE_ACCOUNT_NUMBER,
            self::VALUE_ACCOUNT_ID,
            self::VALUE_TIME_PERIOD,
            self::VALUE_CAMPAIGN_NAME,
            self::VALUE_CAMPAIGN_ID,
            self::VALUE_AD_GROUP_NAME,
            self::VALUE_AD_GROUP_ID,
            self::VALUE_KEYWORD,
            self::VALUE_KEYWORD_ID,
            self::VALUE_GOAL,
            self::VALUE_ALL_CONVERSIONS,
            self::VALUE_ASSISTS,
            self::VALUE_ALL_REVENUE,
            self::VALUE_GOAL_ID,
            self::VALUE_DEVICE_TYPE,
            self::VALUE_DEVICE_OS,
            self::VALUE_ACCOUNT_STATUS,
            self::VALUE_CAMPAIGN_STATUS,
            self::VALUE_AD_GROUP_STATUS,
            self::VALUE_KEYWORD_STATUS,
            self::VALUE_GOAL_TYPE,
            self::VALUE_VIEW_THROUGH_CONVERSIONS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
