<?php

namespace EnumType;

/**
 * This class stands for DeviceTypeReportFilter EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DeviceTypeReportFilter
 * @subpackage Enumerations
 */
class DeviceTypeReportFilter
{
    /**
     * Constant for value 'Computer'
     * @return string 'Computer'
     */
    const VALUE_COMPUTER = 'Computer';
    /**
     * Constant for value 'SmartPhone'
     * @return string 'SmartPhone'
     */
    const VALUE_SMART_PHONE = 'SmartPhone';
    /**
     * Constant for value 'NonSmartPhone'
     * @return string 'NonSmartPhone'
     */
    const VALUE_NON_SMART_PHONE = 'NonSmartPhone';
    /**
     * Constant for value 'Tablet'
     * @return string 'Tablet'
     */
    const VALUE_TABLET = 'Tablet';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_COMPUTER
     * @uses self::VALUE_SMART_PHONE
     * @uses self::VALUE_NON_SMART_PHONE
     * @uses self::VALUE_TABLET
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_COMPUTER,
            self::VALUE_SMART_PHONE,
            self::VALUE_NON_SMART_PHONE,
            self::VALUE_TABLET,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
