<?php

namespace EnumType;

/**
 * This class stands for DeliveredMatchTypeReportFilter EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DeliveredMatchTypeReportFilter
 * @subpackage Enumerations
 */
class DeliveredMatchTypeReportFilter
{
    /**
     * Constant for value 'Exact'
     * @return string 'Exact'
     */
    const VALUE_EXACT = 'Exact';
    /**
     * Constant for value 'Phrase'
     * @return string 'Phrase'
     */
    const VALUE_PHRASE = 'Phrase';
    /**
     * Constant for value 'Broad'
     * @return string 'Broad'
     */
    const VALUE_BROAD = 'Broad';
    /**
     * Constant for value 'ExactCloseVariant'
     * @return string 'ExactCloseVariant'
     */
    const VALUE_EXACT_CLOSE_VARIANT = 'ExactCloseVariant';
    /**
     * Constant for value 'PhraseCloseVariant'
     * @return string 'PhraseCloseVariant'
     */
    const VALUE_PHRASE_CLOSE_VARIANT = 'PhraseCloseVariant';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EXACT
     * @uses self::VALUE_PHRASE
     * @uses self::VALUE_BROAD
     * @uses self::VALUE_EXACT_CLOSE_VARIANT
     * @uses self::VALUE_PHRASE_CLOSE_VARIANT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EXACT,
            self::VALUE_PHRASE,
            self::VALUE_BROAD,
            self::VALUE_EXACT_CLOSE_VARIANT,
            self::VALUE_PHRASE_CLOSE_VARIANT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
