<?php

namespace EnumType;

/**
 * This class stands for DSASearchQueryPerformanceReportColumn EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DSASearchQueryPerformanceReportColumn
 * @subpackage Enumerations
 */
class DSASearchQueryPerformanceReportColumn
{
    /**
     * Constant for value 'TimePeriod'
     * @return string 'TimePeriod'
     */
    const VALUE_TIME_PERIOD = 'TimePeriod';
    /**
     * Constant for value 'AccountId'
     * @return string 'AccountId'
     */
    const VALUE_ACCOUNT_ID = 'AccountId';
    /**
     * Constant for value 'AccountName'
     * @return string 'AccountName'
     */
    const VALUE_ACCOUNT_NAME = 'AccountName';
    /**
     * Constant for value 'AccountNumber'
     * @return string 'AccountNumber'
     */
    const VALUE_ACCOUNT_NUMBER = 'AccountNumber';
    /**
     * Constant for value 'AccountStatus'
     * @return string 'AccountStatus'
     */
    const VALUE_ACCOUNT_STATUS = 'AccountStatus';
    /**
     * Constant for value 'CampaignId'
     * @return string 'CampaignId'
     */
    const VALUE_CAMPAIGN_ID = 'CampaignId';
    /**
     * Constant for value 'CampaignName'
     * @return string 'CampaignName'
     */
    const VALUE_CAMPAIGN_NAME = 'CampaignName';
    /**
     * Constant for value 'CampaignStatus'
     * @return string 'CampaignStatus'
     */
    const VALUE_CAMPAIGN_STATUS = 'CampaignStatus';
    /**
     * Constant for value 'AdGroupId'
     * @return string 'AdGroupId'
     */
    const VALUE_AD_GROUP_ID = 'AdGroupId';
    /**
     * Constant for value 'AdGroupName'
     * @return string 'AdGroupName'
     */
    const VALUE_AD_GROUP_NAME = 'AdGroupName';
    /**
     * Constant for value 'AdGroupStatus'
     * @return string 'AdGroupStatus'
     */
    const VALUE_AD_GROUP_STATUS = 'AdGroupStatus';
    /**
     * Constant for value 'AdId'
     * @return string 'AdId'
     */
    const VALUE_AD_ID = 'AdId';
    /**
     * Constant for value 'AdStatus'
     * @return string 'AdStatus'
     */
    const VALUE_AD_STATUS = 'AdStatus';
    /**
     * Constant for value 'SearchQuery'
     * @return string 'SearchQuery'
     */
    const VALUE_SEARCH_QUERY = 'SearchQuery';
    /**
     * Constant for value 'Headline'
     * @return string 'Headline'
     */
    const VALUE_HEADLINE = 'Headline';
    /**
     * Constant for value 'CategoryList'
     * @return string 'CategoryList'
     */
    const VALUE_CATEGORY_LIST = 'CategoryList';
    /**
     * Constant for value 'LandingPageTitle'
     * @return string 'LandingPageTitle'
     */
    const VALUE_LANDING_PAGE_TITLE = 'LandingPageTitle';
    /**
     * Constant for value 'FinalUrl'
     * @return string 'FinalUrl'
     */
    const VALUE_FINAL_URL = 'FinalUrl';
    /**
     * Constant for value 'DynamicAdTarget'
     * @return string 'DynamicAdTarget'
     */
    const VALUE_DYNAMIC_AD_TARGET = 'DynamicAdTarget';
    /**
     * Constant for value 'DynamicAdTargetId'
     * @return string 'DynamicAdTargetId'
     */
    const VALUE_DYNAMIC_AD_TARGET_ID = 'DynamicAdTargetId';
    /**
     * Constant for value 'AdDistribution'
     * @return string 'AdDistribution'
     */
    const VALUE_AD_DISTRIBUTION = 'AdDistribution';
    /**
     * Constant for value 'Language'
     * @return string 'Language'
     */
    const VALUE_LANGUAGE = 'Language';
    /**
     * Constant for value 'Network'
     * @return string 'Network'
     */
    const VALUE_NETWORK = 'Network';
    /**
     * Constant for value 'TopVsOther'
     * @return string 'TopVsOther'
     */
    const VALUE_TOP_VS_OTHER = 'TopVsOther';
    /**
     * Constant for value 'DeviceType'
     * @return string 'DeviceType'
     */
    const VALUE_DEVICE_TYPE = 'DeviceType';
    /**
     * Constant for value 'DeviceOS'
     * @return string 'DeviceOS'
     */
    const VALUE_DEVICE_OS = 'DeviceOS';
    /**
     * Constant for value 'Impressions'
     * @return string 'Impressions'
     */
    const VALUE_IMPRESSIONS = 'Impressions';
    /**
     * Constant for value 'Clicks'
     * @return string 'Clicks'
     */
    const VALUE_CLICKS = 'Clicks';
    /**
     * Constant for value 'Ctr'
     * @return string 'Ctr'
     */
    const VALUE_CTR = 'Ctr';
    /**
     * Constant for value 'AverageCpc'
     * @return string 'AverageCpc'
     */
    const VALUE_AVERAGE_CPC = 'AverageCpc';
    /**
     * Constant for value 'Spend'
     * @return string 'Spend'
     */
    const VALUE_SPEND = 'Spend';
    /**
     * Constant for value 'AveragePosition'
     * @return string 'AveragePosition'
     */
    const VALUE_AVERAGE_POSITION = 'AveragePosition';
    /**
     * Constant for value 'Conversions'
     * @return string 'Conversions'
     */
    const VALUE_CONVERSIONS = 'Conversions';
    /**
     * Constant for value 'ConversionRate'
     * @return string 'ConversionRate'
     */
    const VALUE_CONVERSION_RATE = 'ConversionRate';
    /**
     * Constant for value 'CostPerConversion'
     * @return string 'CostPerConversion'
     */
    const VALUE_COST_PER_CONVERSION = 'CostPerConversion';
    /**
     * Constant for value 'Assists'
     * @return string 'Assists'
     */
    const VALUE_ASSISTS = 'Assists';
    /**
     * Constant for value 'Revenue'
     * @return string 'Revenue'
     */
    const VALUE_REVENUE = 'Revenue';
    /**
     * Constant for value 'ReturnOnAdSpend'
     * @return string 'ReturnOnAdSpend'
     */
    const VALUE_RETURN_ON_AD_SPEND = 'ReturnOnAdSpend';
    /**
     * Constant for value 'CostPerAssist'
     * @return string 'CostPerAssist'
     */
    const VALUE_COST_PER_ASSIST = 'CostPerAssist';
    /**
     * Constant for value 'RevenuePerConversion'
     * @return string 'RevenuePerConversion'
     */
    const VALUE_REVENUE_PER_CONVERSION = 'RevenuePerConversion';
    /**
     * Constant for value 'RevenuePerAssist'
     * @return string 'RevenuePerAssist'
     */
    const VALUE_REVENUE_PER_ASSIST = 'RevenuePerAssist';
    /**
     * Constant for value 'CustomerId'
     * @return string 'CustomerId'
     */
    const VALUE_CUSTOMER_ID = 'CustomerId';
    /**
     * Constant for value 'CustomerName'
     * @return string 'CustomerName'
     */
    const VALUE_CUSTOMER_NAME = 'CustomerName';
    /**
     * Constant for value 'FeedUrl'
     * @return string 'FeedUrl'
     */
    const VALUE_FEED_URL = 'FeedUrl';
    /**
     * Constant for value 'AllConversions'
     * @return string 'AllConversions'
     */
    const VALUE_ALL_CONVERSIONS = 'AllConversions';
    /**
     * Constant for value 'AllRevenue'
     * @return string 'AllRevenue'
     */
    const VALUE_ALL_REVENUE = 'AllRevenue';
    /**
     * Constant for value 'AllConversionRate'
     * @return string 'AllConversionRate'
     */
    const VALUE_ALL_CONVERSION_RATE = 'AllConversionRate';
    /**
     * Constant for value 'AllCostPerConversion'
     * @return string 'AllCostPerConversion'
     */
    const VALUE_ALL_COST_PER_CONVERSION = 'AllCostPerConversion';
    /**
     * Constant for value 'AllReturnOnAdSpend'
     * @return string 'AllReturnOnAdSpend'
     */
    const VALUE_ALL_RETURN_ON_AD_SPEND = 'AllReturnOnAdSpend';
    /**
     * Constant for value 'AllRevenuePerConversion'
     * @return string 'AllRevenuePerConversion'
     */
    const VALUE_ALL_REVENUE_PER_CONVERSION = 'AllRevenuePerConversion';
    /**
     * Constant for value 'Goal'
     * @return string 'Goal'
     */
    const VALUE_GOAL = 'Goal';
    /**
     * Constant for value 'GoalType'
     * @return string 'GoalType'
     */
    const VALUE_GOAL_TYPE = 'GoalType';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TIME_PERIOD
     * @uses self::VALUE_ACCOUNT_ID
     * @uses self::VALUE_ACCOUNT_NAME
     * @uses self::VALUE_ACCOUNT_NUMBER
     * @uses self::VALUE_ACCOUNT_STATUS
     * @uses self::VALUE_CAMPAIGN_ID
     * @uses self::VALUE_CAMPAIGN_NAME
     * @uses self::VALUE_CAMPAIGN_STATUS
     * @uses self::VALUE_AD_GROUP_ID
     * @uses self::VALUE_AD_GROUP_NAME
     * @uses self::VALUE_AD_GROUP_STATUS
     * @uses self::VALUE_AD_ID
     * @uses self::VALUE_AD_STATUS
     * @uses self::VALUE_SEARCH_QUERY
     * @uses self::VALUE_HEADLINE
     * @uses self::VALUE_CATEGORY_LIST
     * @uses self::VALUE_LANDING_PAGE_TITLE
     * @uses self::VALUE_FINAL_URL
     * @uses self::VALUE_DYNAMIC_AD_TARGET
     * @uses self::VALUE_DYNAMIC_AD_TARGET_ID
     * @uses self::VALUE_AD_DISTRIBUTION
     * @uses self::VALUE_LANGUAGE
     * @uses self::VALUE_NETWORK
     * @uses self::VALUE_TOP_VS_OTHER
     * @uses self::VALUE_DEVICE_TYPE
     * @uses self::VALUE_DEVICE_OS
     * @uses self::VALUE_IMPRESSIONS
     * @uses self::VALUE_CLICKS
     * @uses self::VALUE_CTR
     * @uses self::VALUE_AVERAGE_CPC
     * @uses self::VALUE_SPEND
     * @uses self::VALUE_AVERAGE_POSITION
     * @uses self::VALUE_CONVERSIONS
     * @uses self::VALUE_CONVERSION_RATE
     * @uses self::VALUE_COST_PER_CONVERSION
     * @uses self::VALUE_ASSISTS
     * @uses self::VALUE_REVENUE
     * @uses self::VALUE_RETURN_ON_AD_SPEND
     * @uses self::VALUE_COST_PER_ASSIST
     * @uses self::VALUE_REVENUE_PER_CONVERSION
     * @uses self::VALUE_REVENUE_PER_ASSIST
     * @uses self::VALUE_CUSTOMER_ID
     * @uses self::VALUE_CUSTOMER_NAME
     * @uses self::VALUE_FEED_URL
     * @uses self::VALUE_ALL_CONVERSIONS
     * @uses self::VALUE_ALL_REVENUE
     * @uses self::VALUE_ALL_CONVERSION_RATE
     * @uses self::VALUE_ALL_COST_PER_CONVERSION
     * @uses self::VALUE_ALL_RETURN_ON_AD_SPEND
     * @uses self::VALUE_ALL_REVENUE_PER_CONVERSION
     * @uses self::VALUE_GOAL
     * @uses self::VALUE_GOAL_TYPE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TIME_PERIOD,
            self::VALUE_ACCOUNT_ID,
            self::VALUE_ACCOUNT_NAME,
            self::VALUE_ACCOUNT_NUMBER,
            self::VALUE_ACCOUNT_STATUS,
            self::VALUE_CAMPAIGN_ID,
            self::VALUE_CAMPAIGN_NAME,
            self::VALUE_CAMPAIGN_STATUS,
            self::VALUE_AD_GROUP_ID,
            self::VALUE_AD_GROUP_NAME,
            self::VALUE_AD_GROUP_STATUS,
            self::VALUE_AD_ID,
            self::VALUE_AD_STATUS,
            self::VALUE_SEARCH_QUERY,
            self::VALUE_HEADLINE,
            self::VALUE_CATEGORY_LIST,
            self::VALUE_LANDING_PAGE_TITLE,
            self::VALUE_FINAL_URL,
            self::VALUE_DYNAMIC_AD_TARGET,
            self::VALUE_DYNAMIC_AD_TARGET_ID,
            self::VALUE_AD_DISTRIBUTION,
            self::VALUE_LANGUAGE,
            self::VALUE_NETWORK,
            self::VALUE_TOP_VS_OTHER,
            self::VALUE_DEVICE_TYPE,
            self::VALUE_DEVICE_OS,
            self::VALUE_IMPRESSIONS,
            self::VALUE_CLICKS,
            self::VALUE_CTR,
            self::VALUE_AVERAGE_CPC,
            self::VALUE_SPEND,
            self::VALUE_AVERAGE_POSITION,
            self::VALUE_CONVERSIONS,
            self::VALUE_CONVERSION_RATE,
            self::VALUE_COST_PER_CONVERSION,
            self::VALUE_ASSISTS,
            self::VALUE_REVENUE,
            self::VALUE_RETURN_ON_AD_SPEND,
            self::VALUE_COST_PER_ASSIST,
            self::VALUE_REVENUE_PER_CONVERSION,
            self::VALUE_REVENUE_PER_ASSIST,
            self::VALUE_CUSTOMER_ID,
            self::VALUE_CUSTOMER_NAME,
            self::VALUE_FEED_URL,
            self::VALUE_ALL_CONVERSIONS,
            self::VALUE_ALL_REVENUE,
            self::VALUE_ALL_CONVERSION_RATE,
            self::VALUE_ALL_COST_PER_CONVERSION,
            self::VALUE_ALL_RETURN_ON_AD_SPEND,
            self::VALUE_ALL_REVENUE_PER_CONVERSION,
            self::VALUE_GOAL,
            self::VALUE_GOAL_TYPE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
