<?php

namespace EnumType;

/**
 * This class stands for ChangeEntityReportFilter EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ChangeEntityReportFilter
 * @subpackage Enumerations
 */
class ChangeEntityReportFilter
{
    /**
     * Constant for value 'Account'
     * @return string 'Account'
     */
    const VALUE_ACCOUNT = 'Account';
    /**
     * Constant for value 'Campaign'
     * @return string 'Campaign'
     */
    const VALUE_CAMPAIGN = 'Campaign';
    /**
     * Constant for value 'AdGroup'
     * @return string 'AdGroup'
     */
    const VALUE_AD_GROUP = 'AdGroup';
    /**
     * Constant for value 'Ad'
     * @return string 'Ad'
     */
    const VALUE_AD = 'Ad';
    /**
     * Constant for value 'Keyword'
     * @return string 'Keyword'
     */
    const VALUE_KEYWORD = 'Keyword';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACCOUNT
     * @uses self::VALUE_CAMPAIGN
     * @uses self::VALUE_AD_GROUP
     * @uses self::VALUE_AD
     * @uses self::VALUE_KEYWORD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACCOUNT,
            self::VALUE_CAMPAIGN,
            self::VALUE_AD_GROUP,
            self::VALUE_AD,
            self::VALUE_KEYWORD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
