<?php

namespace EnumType;

/**
 * This class stands for BidStrategyTypeReportFilter EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BidStrategyTypeReportFilter
 * @subpackage Enumerations
 */
class BidStrategyTypeReportFilter
{
    /**
     * Constant for value 'ManualCpc'
     * @return string 'ManualCpc'
     */
    const VALUE_MANUAL_CPC = 'ManualCpc';
    /**
     * Constant for value 'EnhancedCpc'
     * @return string 'EnhancedCpc'
     */
    const VALUE_ENHANCED_CPC = 'EnhancedCpc';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MANUAL_CPC
     * @uses self::VALUE_ENHANCED_CPC
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MANUAL_CPC,
            self::VALUE_ENHANCED_CPC,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
