<?php

namespace EnumType;

/**
 * This class stands for AdTypeReportFilter EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AdTypeReportFilter
 * @subpackage Enumerations
 */
class AdTypeReportFilter
{
    /**
     * Constant for value 'Text'
     * @return string 'Text'
     */
    const VALUE_TEXT = 'Text';
    /**
     * Constant for value 'Local'
     * @return string 'Local'
     */
    const VALUE_LOCAL = 'Local';
    /**
     * Constant for value 'Product'
     * @return string 'Product'
     */
    const VALUE_PRODUCT = 'Product';
    /**
     * Constant for value 'AppInstall'
     * @return string 'AppInstall'
     */
    const VALUE_APP_INSTALL = 'AppInstall';
    /**
     * Constant for value 'DynamicSearchAd'
     * @return string 'DynamicSearchAd'
     */
    const VALUE_DYNAMIC_SEARCH_AD = 'DynamicSearchAd';
    /**
     * Constant for value 'ExpandedText'
     * @return string 'ExpandedText'
     */
    const VALUE_EXPANDED_TEXT = 'ExpandedText';
    /**
     * Constant for value 'ResponsiveAd'
     * @return string 'ResponsiveAd'
     */
    const VALUE_RESPONSIVE_AD = 'ResponsiveAd';
    /**
     * Constant for value 'ResponsiveSearchAd'
     * @return string 'ResponsiveSearchAd'
     */
    const VALUE_RESPONSIVE_SEARCH_AD = 'ResponsiveSearchAd';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TEXT
     * @uses self::VALUE_LOCAL
     * @uses self::VALUE_PRODUCT
     * @uses self::VALUE_APP_INSTALL
     * @uses self::VALUE_DYNAMIC_SEARCH_AD
     * @uses self::VALUE_EXPANDED_TEXT
     * @uses self::VALUE_RESPONSIVE_AD
     * @uses self::VALUE_RESPONSIVE_SEARCH_AD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TEXT,
            self::VALUE_LOCAL,
            self::VALUE_PRODUCT,
            self::VALUE_APP_INSTALL,
            self::VALUE_DYNAMIC_SEARCH_AD,
            self::VALUE_EXPANDED_TEXT,
            self::VALUE_RESPONSIVE_AD,
            self::VALUE_RESPONSIVE_SEARCH_AD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
