<?php

namespace EnumType;

/**
 * This class stands for AdGroupStatusReportFilter EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AdGroupStatusReportFilter
 * @subpackage Enumerations
 */
class AdGroupStatusReportFilter
{
    /**
     * Constant for value 'Active'
     * @return string 'Active'
     */
    const VALUE_ACTIVE = 'Active';
    /**
     * Constant for value 'Deleted'
     * @return string 'Deleted'
     */
    const VALUE_DELETED = 'Deleted';
    /**
     * Constant for value 'Expired'
     * @return string 'Expired'
     */
    const VALUE_EXPIRED = 'Expired';
    /**
     * Constant for value 'Paused'
     * @return string 'Paused'
     */
    const VALUE_PAUSED = 'Paused';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACTIVE
     * @uses self::VALUE_DELETED
     * @uses self::VALUE_EXPIRED
     * @uses self::VALUE_PAUSED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACTIVE,
            self::VALUE_DELETED,
            self::VALUE_EXPIRED,
            self::VALUE_PAUSED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
