<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://reporting.api.bingads.microsoft.com/Api/Advertiser/Reporting/V13/ReportingService.svc?singleWsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://reporting.api.bingads.microsoft.com/Api/Advertiser/Reporting/V13/ReportingService.svc?singleWsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Submit ServiceType
 */
$submit = new \ServiceType\Submit($options);
$submit->setSoapHeaderApplicationToken($ApplicationToken);
$submit->setSoapHeaderAuthenticationToken($AuthenticationToken);
$submit->setSoapHeaderCustomerAccountId($CustomerAccountId);
$submit->setSoapHeaderCustomerId($CustomerId);
$submit->setSoapHeaderDeveloperToken($DeveloperToken);
$submit->setSoapHeaderPassword($Password);
$submit->setSoapHeaderUserName($UserName);
/**
 * Sample call for SubmitGenerateReport operation/method
 */
if ($submit->SubmitGenerateReport(new \StructType\SubmitGenerateReportRequest()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Samples for Poll ServiceType
 */
$poll = new \ServiceType\Poll($options);
$poll->setSoapHeaderApplicationToken($ApplicationToken);
$poll->setSoapHeaderAuthenticationToken($AuthenticationToken);
$poll->setSoapHeaderCustomerAccountId($CustomerAccountId);
$poll->setSoapHeaderCustomerId($CustomerId);
$poll->setSoapHeaderDeveloperToken($DeveloperToken);
$poll->setSoapHeaderPassword($Password);
$poll->setSoapHeaderUserName($UserName);
/**
 * Sample call for PollGenerateReport operation/method
 */
if ($poll->PollGenerateReport(new \StructType\PollGenerateReportRequest()) !== false) {
    print_r($poll->getResult());
} else {
    print_r($poll->getLastError());
}
