<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchQueryPerformanceReportFilter StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SearchQueryPerformanceReportFilter
 * @subpackage Structs
 */
class SearchQueryPerformanceReportFilter extends AbstractStructBase
{
    /**
     * The AccountStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AccountStatus;
    /**
     * The AdGroupStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AdGroupStatus;
    /**
     * The AdStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AdStatus;
    /**
     * The AdType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AdType;
    /**
     * The CampaignStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $CampaignStatus;
    /**
     * The DeliveredMatchType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $DeliveredMatchType;
    /**
     * The ExcludeZeroClicks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ExcludeZeroClicks;
    /**
     * The KeywordStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $KeywordStatus;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $Language;
    /**
     * The SearchQueries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $SearchQueries;
    /**
     * Constructor method for SearchQueryPerformanceReportFilter
     * @uses SearchQueryPerformanceReportFilter::setAccountStatus()
     * @uses SearchQueryPerformanceReportFilter::setAdGroupStatus()
     * @uses SearchQueryPerformanceReportFilter::setAdStatus()
     * @uses SearchQueryPerformanceReportFilter::setAdType()
     * @uses SearchQueryPerformanceReportFilter::setCampaignStatus()
     * @uses SearchQueryPerformanceReportFilter::setDeliveredMatchType()
     * @uses SearchQueryPerformanceReportFilter::setExcludeZeroClicks()
     * @uses SearchQueryPerformanceReportFilter::setKeywordStatus()
     * @uses SearchQueryPerformanceReportFilter::setLanguage()
     * @uses SearchQueryPerformanceReportFilter::setSearchQueries()
     * @param string[] $accountStatus
     * @param string[] $adGroupStatus
     * @param string[] $adStatus
     * @param string[] $adType
     * @param string[] $campaignStatus
     * @param string[] $deliveredMatchType
     * @param bool $excludeZeroClicks
     * @param string[] $keywordStatus
     * @param string[] $language
     * @param \ArrayType\ArrayOfstring $searchQueries
     */
    public function __construct(array $accountStatus = array(), array $adGroupStatus = array(), array $adStatus = array(), array $adType = array(), array $campaignStatus = array(), array $deliveredMatchType = array(), $excludeZeroClicks = null, array $keywordStatus = array(), array $language = array(), \ArrayType\ArrayOfstring $searchQueries = null)
    {
        $this
            ->setAccountStatus($accountStatus)
            ->setAdGroupStatus($adGroupStatus)
            ->setAdStatus($adStatus)
            ->setAdType($adType)
            ->setCampaignStatus($campaignStatus)
            ->setDeliveredMatchType($deliveredMatchType)
            ->setExcludeZeroClicks($excludeZeroClicks)
            ->setKeywordStatus($keywordStatus)
            ->setLanguage($language)
            ->setSearchQueries($searchQueries);
    }
    /**
     * Get AccountStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAccountStatus()
    {
        return isset($this->AccountStatus) ? $this->AccountStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAccountStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountStatusForArrayConstraintsFromSetAccountStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchQueryPerformanceReportFilterAccountStatusItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AccountStatusReportFilter::valueIsValid($searchQueryPerformanceReportFilterAccountStatusItem)) {
                $invalidValues[] = is_object($searchQueryPerformanceReportFilterAccountStatusItem) ? get_class($searchQueryPerformanceReportFilterAccountStatusItem) : sprintf('%s(%s)', gettype($searchQueryPerformanceReportFilterAccountStatusItem), var_export($searchQueryPerformanceReportFilterAccountStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AccountStatusReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AccountStatusReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AccountStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AccountStatusReportFilter::valueIsValid()
     * @uses \EnumType\AccountStatusReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $accountStatus
     * @return \StructType\SearchQueryPerformanceReportFilter
     */
    public function setAccountStatus(array $accountStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($accountStatusArrayErrorMessage = self::validateAccountStatusForArrayConstraintsFromSetAccountStatus($accountStatus))) {
            throw new \InvalidArgumentException($accountStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($accountStatus) || (is_array($accountStatus) && empty($accountStatus))) {
            unset($this->AccountStatus);
        } else {
            $this->AccountStatus = is_array($accountStatus) ? implode(' ', $accountStatus) : null;
        }
        return $this;
    }
    /**
     * Get AdGroupStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAdGroupStatus()
    {
        return isset($this->AdGroupStatus) ? $this->AdGroupStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAdGroupStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdGroupStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdGroupStatusForArrayConstraintsFromSetAdGroupStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchQueryPerformanceReportFilterAdGroupStatusItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AdGroupStatusReportFilter::valueIsValid($searchQueryPerformanceReportFilterAdGroupStatusItem)) {
                $invalidValues[] = is_object($searchQueryPerformanceReportFilterAdGroupStatusItem) ? get_class($searchQueryPerformanceReportFilterAdGroupStatusItem) : sprintf('%s(%s)', gettype($searchQueryPerformanceReportFilterAdGroupStatusItem), var_export($searchQueryPerformanceReportFilterAdGroupStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdGroupStatusReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AdGroupStatusReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdGroupStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AdGroupStatusReportFilter::valueIsValid()
     * @uses \EnumType\AdGroupStatusReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $adGroupStatus
     * @return \StructType\SearchQueryPerformanceReportFilter
     */
    public function setAdGroupStatus(array $adGroupStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($adGroupStatusArrayErrorMessage = self::validateAdGroupStatusForArrayConstraintsFromSetAdGroupStatus($adGroupStatus))) {
            throw new \InvalidArgumentException($adGroupStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($adGroupStatus) || (is_array($adGroupStatus) && empty($adGroupStatus))) {
            unset($this->AdGroupStatus);
        } else {
            $this->AdGroupStatus = is_array($adGroupStatus) ? implode(' ', $adGroupStatus) : null;
        }
        return $this;
    }
    /**
     * Get AdStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAdStatus()
    {
        return isset($this->AdStatus) ? $this->AdStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAdStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdStatusForArrayConstraintsFromSetAdStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchQueryPerformanceReportFilterAdStatusItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AdStatusReportFilter::valueIsValid($searchQueryPerformanceReportFilterAdStatusItem)) {
                $invalidValues[] = is_object($searchQueryPerformanceReportFilterAdStatusItem) ? get_class($searchQueryPerformanceReportFilterAdStatusItem) : sprintf('%s(%s)', gettype($searchQueryPerformanceReportFilterAdStatusItem), var_export($searchQueryPerformanceReportFilterAdStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdStatusReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AdStatusReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AdStatusReportFilter::valueIsValid()
     * @uses \EnumType\AdStatusReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $adStatus
     * @return \StructType\SearchQueryPerformanceReportFilter
     */
    public function setAdStatus(array $adStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($adStatusArrayErrorMessage = self::validateAdStatusForArrayConstraintsFromSetAdStatus($adStatus))) {
            throw new \InvalidArgumentException($adStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($adStatus) || (is_array($adStatus) && empty($adStatus))) {
            unset($this->AdStatus);
        } else {
            $this->AdStatus = is_array($adStatus) ? implode(' ', $adStatus) : null;
        }
        return $this;
    }
    /**
     * Get AdType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAdType()
    {
        return isset($this->AdType) ? $this->AdType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAdType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdTypeForArrayConstraintsFromSetAdType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchQueryPerformanceReportFilterAdTypeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AdTypeReportFilter::valueIsValid($searchQueryPerformanceReportFilterAdTypeItem)) {
                $invalidValues[] = is_object($searchQueryPerformanceReportFilterAdTypeItem) ? get_class($searchQueryPerformanceReportFilterAdTypeItem) : sprintf('%s(%s)', gettype($searchQueryPerformanceReportFilterAdTypeItem), var_export($searchQueryPerformanceReportFilterAdTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdTypeReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AdTypeReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AdTypeReportFilter::valueIsValid()
     * @uses \EnumType\AdTypeReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $adType
     * @return \StructType\SearchQueryPerformanceReportFilter
     */
    public function setAdType(array $adType = array())
    {
        // validation for constraint: list
        if ('' !== ($adTypeArrayErrorMessage = self::validateAdTypeForArrayConstraintsFromSetAdType($adType))) {
            throw new \InvalidArgumentException($adTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($adType) || (is_array($adType) && empty($adType))) {
            unset($this->AdType);
        } else {
            $this->AdType = is_array($adType) ? implode(' ', $adType) : null;
        }
        return $this;
    }
    /**
     * Get CampaignStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getCampaignStatus()
    {
        return isset($this->CampaignStatus) ? $this->CampaignStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCampaignStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCampaignStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCampaignStatusForArrayConstraintsFromSetCampaignStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchQueryPerformanceReportFilterCampaignStatusItem) {
            // validation for constraint: enumeration
            if (!\EnumType\CampaignStatusReportFilter::valueIsValid($searchQueryPerformanceReportFilterCampaignStatusItem)) {
                $invalidValues[] = is_object($searchQueryPerformanceReportFilterCampaignStatusItem) ? get_class($searchQueryPerformanceReportFilterCampaignStatusItem) : sprintf('%s(%s)', gettype($searchQueryPerformanceReportFilterCampaignStatusItem), var_export($searchQueryPerformanceReportFilterCampaignStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CampaignStatusReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\CampaignStatusReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CampaignStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\CampaignStatusReportFilter::valueIsValid()
     * @uses \EnumType\CampaignStatusReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $campaignStatus
     * @return \StructType\SearchQueryPerformanceReportFilter
     */
    public function setCampaignStatus(array $campaignStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($campaignStatusArrayErrorMessage = self::validateCampaignStatusForArrayConstraintsFromSetCampaignStatus($campaignStatus))) {
            throw new \InvalidArgumentException($campaignStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($campaignStatus) || (is_array($campaignStatus) && empty($campaignStatus))) {
            unset($this->CampaignStatus);
        } else {
            $this->CampaignStatus = is_array($campaignStatus) ? implode(' ', $campaignStatus) : null;
        }
        return $this;
    }
    /**
     * Get DeliveredMatchType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getDeliveredMatchType()
    {
        return isset($this->DeliveredMatchType) ? $this->DeliveredMatchType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDeliveredMatchType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeliveredMatchType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeliveredMatchTypeForArrayConstraintsFromSetDeliveredMatchType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchQueryPerformanceReportFilterDeliveredMatchTypeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\DeliveredMatchTypeReportFilter::valueIsValid($searchQueryPerformanceReportFilterDeliveredMatchTypeItem)) {
                $invalidValues[] = is_object($searchQueryPerformanceReportFilterDeliveredMatchTypeItem) ? get_class($searchQueryPerformanceReportFilterDeliveredMatchTypeItem) : sprintf('%s(%s)', gettype($searchQueryPerformanceReportFilterDeliveredMatchTypeItem), var_export($searchQueryPerformanceReportFilterDeliveredMatchTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DeliveredMatchTypeReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\DeliveredMatchTypeReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DeliveredMatchType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\DeliveredMatchTypeReportFilter::valueIsValid()
     * @uses \EnumType\DeliveredMatchTypeReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $deliveredMatchType
     * @return \StructType\SearchQueryPerformanceReportFilter
     */
    public function setDeliveredMatchType(array $deliveredMatchType = array())
    {
        // validation for constraint: list
        if ('' !== ($deliveredMatchTypeArrayErrorMessage = self::validateDeliveredMatchTypeForArrayConstraintsFromSetDeliveredMatchType($deliveredMatchType))) {
            throw new \InvalidArgumentException($deliveredMatchTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($deliveredMatchType) || (is_array($deliveredMatchType) && empty($deliveredMatchType))) {
            unset($this->DeliveredMatchType);
        } else {
            $this->DeliveredMatchType = is_array($deliveredMatchType) ? implode(' ', $deliveredMatchType) : null;
        }
        return $this;
    }
    /**
     * Get ExcludeZeroClicks value
     * @return bool|null
     */
    public function getExcludeZeroClicks()
    {
        return $this->ExcludeZeroClicks;
    }
    /**
     * Set ExcludeZeroClicks value
     * @param bool $excludeZeroClicks
     * @return \StructType\SearchQueryPerformanceReportFilter
     */
    public function setExcludeZeroClicks($excludeZeroClicks = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeZeroClicks) && !is_bool($excludeZeroClicks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludeZeroClicks, true), gettype($excludeZeroClicks)), __LINE__);
        }
        $this->ExcludeZeroClicks = $excludeZeroClicks;
        return $this;
    }
    /**
     * Get KeywordStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getKeywordStatus()
    {
        return isset($this->KeywordStatus) ? $this->KeywordStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setKeywordStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKeywordStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKeywordStatusForArrayConstraintsFromSetKeywordStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchQueryPerformanceReportFilterKeywordStatusItem) {
            // validation for constraint: enumeration
            if (!\EnumType\KeywordStatusReportFilter::valueIsValid($searchQueryPerformanceReportFilterKeywordStatusItem)) {
                $invalidValues[] = is_object($searchQueryPerformanceReportFilterKeywordStatusItem) ? get_class($searchQueryPerformanceReportFilterKeywordStatusItem) : sprintf('%s(%s)', gettype($searchQueryPerformanceReportFilterKeywordStatusItem), var_export($searchQueryPerformanceReportFilterKeywordStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KeywordStatusReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\KeywordStatusReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set KeywordStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\KeywordStatusReportFilter::valueIsValid()
     * @uses \EnumType\KeywordStatusReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $keywordStatus
     * @return \StructType\SearchQueryPerformanceReportFilter
     */
    public function setKeywordStatus(array $keywordStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($keywordStatusArrayErrorMessage = self::validateKeywordStatusForArrayConstraintsFromSetKeywordStatus($keywordStatus))) {
            throw new \InvalidArgumentException($keywordStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($keywordStatus) || (is_array($keywordStatus) && empty($keywordStatus))) {
            unset($this->KeywordStatus);
        } else {
            $this->KeywordStatus = is_array($keywordStatus) ? implode(' ', $keywordStatus) : null;
        }
        return $this;
    }
    /**
     * Get Language value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getLanguage()
    {
        return isset($this->Language) ? $this->Language : null;
    }
    /**
     * This method is responsible for validating the values passed to the setLanguage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLanguage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLanguageForArrayConstraintsFromSetLanguage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchQueryPerformanceReportFilterLanguageItem) {
            // validation for constraint: enumeration
            if (!\EnumType\LanguageReportFilter::valueIsValid($searchQueryPerformanceReportFilterLanguageItem)) {
                $invalidValues[] = is_object($searchQueryPerformanceReportFilterLanguageItem) ? get_class($searchQueryPerformanceReportFilterLanguageItem) : sprintf('%s(%s)', gettype($searchQueryPerformanceReportFilterLanguageItem), var_export($searchQueryPerformanceReportFilterLanguageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LanguageReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\LanguageReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Language value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\LanguageReportFilter::valueIsValid()
     * @uses \EnumType\LanguageReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $language
     * @return \StructType\SearchQueryPerformanceReportFilter
     */
    public function setLanguage(array $language = array())
    {
        // validation for constraint: list
        if ('' !== ($languageArrayErrorMessage = self::validateLanguageForArrayConstraintsFromSetLanguage($language))) {
            throw new \InvalidArgumentException($languageArrayErrorMessage, __LINE__);
        }
        if (is_null($language) || (is_array($language) && empty($language))) {
            unset($this->Language);
        } else {
            $this->Language = is_array($language) ? implode(' ', $language) : null;
        }
        return $this;
    }
    /**
     * Get SearchQueries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getSearchQueries()
    {
        return isset($this->SearchQueries) ? $this->SearchQueries : null;
    }
    /**
     * Set SearchQueries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $searchQueries
     * @return \StructType\SearchQueryPerformanceReportFilter
     */
    public function setSearchQueries(\ArrayType\ArrayOfstring $searchQueries = null)
    {
        if (is_null($searchQueries) || (is_array($searchQueries) && empty($searchQueries))) {
            unset($this->SearchQueries);
        } else {
            $this->SearchQueries = $searchQueries;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SearchQueryPerformanceReportFilter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
