<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReportTime StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ReportTime
 * @subpackage Structs
 */
class ReportTime extends AbstractStructBase
{
    /**
     * The CustomDateRangeEnd
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Date
     */
    public $CustomDateRangeEnd;
    /**
     * The CustomDateRangeStart
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Date
     */
    public $CustomDateRangeStart;
    /**
     * The PredefinedTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PredefinedTime;
    /**
     * The ReportTimeZone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReportTimeZone;
    /**
     * Constructor method for ReportTime
     * @uses ReportTime::setCustomDateRangeEnd()
     * @uses ReportTime::setCustomDateRangeStart()
     * @uses ReportTime::setPredefinedTime()
     * @uses ReportTime::setReportTimeZone()
     * @param \StructType\Date $customDateRangeEnd
     * @param \StructType\Date $customDateRangeStart
     * @param string $predefinedTime
     * @param string $reportTimeZone
     */
    public function __construct(\StructType\Date $customDateRangeEnd = null, \StructType\Date $customDateRangeStart = null, $predefinedTime = null, $reportTimeZone = null)
    {
        $this
            ->setCustomDateRangeEnd($customDateRangeEnd)
            ->setCustomDateRangeStart($customDateRangeStart)
            ->setPredefinedTime($predefinedTime)
            ->setReportTimeZone($reportTimeZone);
    }
    /**
     * Get CustomDateRangeEnd value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Date|null
     */
    public function getCustomDateRangeEnd()
    {
        return isset($this->CustomDateRangeEnd) ? $this->CustomDateRangeEnd : null;
    }
    /**
     * Set CustomDateRangeEnd value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Date $customDateRangeEnd
     * @return \StructType\ReportTime
     */
    public function setCustomDateRangeEnd(\StructType\Date $customDateRangeEnd = null)
    {
        if (is_null($customDateRangeEnd) || (is_array($customDateRangeEnd) && empty($customDateRangeEnd))) {
            unset($this->CustomDateRangeEnd);
        } else {
            $this->CustomDateRangeEnd = $customDateRangeEnd;
        }
        return $this;
    }
    /**
     * Get CustomDateRangeStart value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Date|null
     */
    public function getCustomDateRangeStart()
    {
        return isset($this->CustomDateRangeStart) ? $this->CustomDateRangeStart : null;
    }
    /**
     * Set CustomDateRangeStart value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Date $customDateRangeStart
     * @return \StructType\ReportTime
     */
    public function setCustomDateRangeStart(\StructType\Date $customDateRangeStart = null)
    {
        if (is_null($customDateRangeStart) || (is_array($customDateRangeStart) && empty($customDateRangeStart))) {
            unset($this->CustomDateRangeStart);
        } else {
            $this->CustomDateRangeStart = $customDateRangeStart;
        }
        return $this;
    }
    /**
     * Get PredefinedTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPredefinedTime()
    {
        return isset($this->PredefinedTime) ? $this->PredefinedTime : null;
    }
    /**
     * Set PredefinedTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\ReportTimePeriod::valueIsValid()
     * @uses \EnumType\ReportTimePeriod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $predefinedTime
     * @return \StructType\ReportTime
     */
    public function setPredefinedTime($predefinedTime = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ReportTimePeriod::valueIsValid($predefinedTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ReportTimePeriod', is_array($predefinedTime) ? implode(', ', $predefinedTime) : var_export($predefinedTime, true), implode(', ', \EnumType\ReportTimePeriod::getValidValues())), __LINE__);
        }
        if (is_null($predefinedTime) || (is_array($predefinedTime) && empty($predefinedTime))) {
            unset($this->PredefinedTime);
        } else {
            $this->PredefinedTime = $predefinedTime;
        }
        return $this;
    }
    /**
     * Get ReportTimeZone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReportTimeZone()
    {
        return isset($this->ReportTimeZone) ? $this->ReportTimeZone : null;
    }
    /**
     * Set ReportTimeZone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\ReportTimeZone::valueIsValid()
     * @uses \EnumType\ReportTimeZone::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reportTimeZone
     * @return \StructType\ReportTime
     */
    public function setReportTimeZone($reportTimeZone = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ReportTimeZone::valueIsValid($reportTimeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ReportTimeZone', is_array($reportTimeZone) ? implode(', ', $reportTimeZone) : var_export($reportTimeZone, true), implode(', ', \EnumType\ReportTimeZone::getValidValues())), __LINE__);
        }
        if (is_null($reportTimeZone) || (is_array($reportTimeZone) && empty($reportTimeZone))) {
            unset($this->ReportTimeZone);
        } else {
            $this->ReportTimeZone = $reportTimeZone;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReportTime
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
