<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReportRequestStatus StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ReportRequestStatus
 * @subpackage Structs
 */
class ReportRequestStatus extends AbstractStructBase
{
    /**
     * The ReportDownloadUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReportDownloadUrl;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * Constructor method for ReportRequestStatus
     * @uses ReportRequestStatus::setReportDownloadUrl()
     * @uses ReportRequestStatus::setStatus()
     * @param string $reportDownloadUrl
     * @param string $status
     */
    public function __construct($reportDownloadUrl = null, $status = null)
    {
        $this
            ->setReportDownloadUrl($reportDownloadUrl)
            ->setStatus($status);
    }
    /**
     * Get ReportDownloadUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReportDownloadUrl()
    {
        return isset($this->ReportDownloadUrl) ? $this->ReportDownloadUrl : null;
    }
    /**
     * Set ReportDownloadUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reportDownloadUrl
     * @return \StructType\ReportRequestStatus
     */
    public function setReportDownloadUrl($reportDownloadUrl = null)
    {
        // validation for constraint: string
        if (!is_null($reportDownloadUrl) && !is_string($reportDownloadUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportDownloadUrl, true), gettype($reportDownloadUrl)), __LINE__);
        }
        if (is_null($reportDownloadUrl) || (is_array($reportDownloadUrl) && empty($reportDownloadUrl))) {
            unset($this->ReportDownloadUrl);
        } else {
            $this->ReportDownloadUrl = $reportDownloadUrl;
        }
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\ReportRequestStatusType::valueIsValid()
     * @uses \EnumType\ReportRequestStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\ReportRequestStatus
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ReportRequestStatusType::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ReportRequestStatusType', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\ReportRequestStatusType::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReportRequestStatus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
