<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReportRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ReportRequest
 * @subpackage Structs
 */
class ReportRequest extends AbstractStructBase
{
    /**
     * The ExcludeColumnHeaders
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ExcludeColumnHeaders;
    /**
     * The ExcludeReportFooter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ExcludeReportFooter;
    /**
     * The ExcludeReportHeader
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ExcludeReportHeader;
    /**
     * The Format
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Format;
    /**
     * The ReportName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReportName;
    /**
     * The ReturnOnlyCompleteData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ReturnOnlyCompleteData;
    /**
     * Constructor method for ReportRequest
     * @uses ReportRequest::setExcludeColumnHeaders()
     * @uses ReportRequest::setExcludeReportFooter()
     * @uses ReportRequest::setExcludeReportHeader()
     * @uses ReportRequest::setFormat()
     * @uses ReportRequest::setReportName()
     * @uses ReportRequest::setReturnOnlyCompleteData()
     * @param bool $excludeColumnHeaders
     * @param bool $excludeReportFooter
     * @param bool $excludeReportHeader
     * @param string $format
     * @param string $reportName
     * @param bool $returnOnlyCompleteData
     */
    public function __construct($excludeColumnHeaders = null, $excludeReportFooter = null, $excludeReportHeader = null, $format = null, $reportName = null, $returnOnlyCompleteData = null)
    {
        $this
            ->setExcludeColumnHeaders($excludeColumnHeaders)
            ->setExcludeReportFooter($excludeReportFooter)
            ->setExcludeReportHeader($excludeReportHeader)
            ->setFormat($format)
            ->setReportName($reportName)
            ->setReturnOnlyCompleteData($returnOnlyCompleteData);
    }
    /**
     * Get ExcludeColumnHeaders value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getExcludeColumnHeaders()
    {
        return isset($this->ExcludeColumnHeaders) ? $this->ExcludeColumnHeaders : null;
    }
    /**
     * Set ExcludeColumnHeaders value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $excludeColumnHeaders
     * @return \StructType\ReportRequest
     */
    public function setExcludeColumnHeaders($excludeColumnHeaders = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeColumnHeaders) && !is_bool($excludeColumnHeaders)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludeColumnHeaders, true), gettype($excludeColumnHeaders)), __LINE__);
        }
        if (is_null($excludeColumnHeaders) || (is_array($excludeColumnHeaders) && empty($excludeColumnHeaders))) {
            unset($this->ExcludeColumnHeaders);
        } else {
            $this->ExcludeColumnHeaders = $excludeColumnHeaders;
        }
        return $this;
    }
    /**
     * Get ExcludeReportFooter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getExcludeReportFooter()
    {
        return isset($this->ExcludeReportFooter) ? $this->ExcludeReportFooter : null;
    }
    /**
     * Set ExcludeReportFooter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $excludeReportFooter
     * @return \StructType\ReportRequest
     */
    public function setExcludeReportFooter($excludeReportFooter = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeReportFooter) && !is_bool($excludeReportFooter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludeReportFooter, true), gettype($excludeReportFooter)), __LINE__);
        }
        if (is_null($excludeReportFooter) || (is_array($excludeReportFooter) && empty($excludeReportFooter))) {
            unset($this->ExcludeReportFooter);
        } else {
            $this->ExcludeReportFooter = $excludeReportFooter;
        }
        return $this;
    }
    /**
     * Get ExcludeReportHeader value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getExcludeReportHeader()
    {
        return isset($this->ExcludeReportHeader) ? $this->ExcludeReportHeader : null;
    }
    /**
     * Set ExcludeReportHeader value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $excludeReportHeader
     * @return \StructType\ReportRequest
     */
    public function setExcludeReportHeader($excludeReportHeader = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeReportHeader) && !is_bool($excludeReportHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludeReportHeader, true), gettype($excludeReportHeader)), __LINE__);
        }
        if (is_null($excludeReportHeader) || (is_array($excludeReportHeader) && empty($excludeReportHeader))) {
            unset($this->ExcludeReportHeader);
        } else {
            $this->ExcludeReportHeader = $excludeReportHeader;
        }
        return $this;
    }
    /**
     * Get Format value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormat()
    {
        return isset($this->Format) ? $this->Format : null;
    }
    /**
     * Set Format value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\ReportFormat::valueIsValid()
     * @uses \EnumType\ReportFormat::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $format
     * @return \StructType\ReportRequest
     */
    public function setFormat($format = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ReportFormat::valueIsValid($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ReportFormat', is_array($format) ? implode(', ', $format) : var_export($format, true), implode(', ', \EnumType\ReportFormat::getValidValues())), __LINE__);
        }
        if (is_null($format) || (is_array($format) && empty($format))) {
            unset($this->Format);
        } else {
            $this->Format = $format;
        }
        return $this;
    }
    /**
     * Get ReportName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReportName()
    {
        return isset($this->ReportName) ? $this->ReportName : null;
    }
    /**
     * Set ReportName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reportName
     * @return \StructType\ReportRequest
     */
    public function setReportName($reportName = null)
    {
        // validation for constraint: string
        if (!is_null($reportName) && !is_string($reportName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportName, true), gettype($reportName)), __LINE__);
        }
        if (is_null($reportName) || (is_array($reportName) && empty($reportName))) {
            unset($this->ReportName);
        } else {
            $this->ReportName = $reportName;
        }
        return $this;
    }
    /**
     * Get ReturnOnlyCompleteData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getReturnOnlyCompleteData()
    {
        return isset($this->ReturnOnlyCompleteData) ? $this->ReturnOnlyCompleteData : null;
    }
    /**
     * Set ReturnOnlyCompleteData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $returnOnlyCompleteData
     * @return \StructType\ReportRequest
     */
    public function setReturnOnlyCompleteData($returnOnlyCompleteData = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnOnlyCompleteData) && !is_bool($returnOnlyCompleteData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($returnOnlyCompleteData, true), gettype($returnOnlyCompleteData)), __LINE__);
        }
        if (is_null($returnOnlyCompleteData) || (is_array($returnOnlyCompleteData) && empty($returnOnlyCompleteData))) {
            unset($this->ReturnOnlyCompleteData);
        } else {
            $this->ReturnOnlyCompleteData = $returnOnlyCompleteData;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReportRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
